/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Bind;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Fallback;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.GenerateCached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.ArityException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnknownIdentifierException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedTypeException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.DenyReplace;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsPrimitiveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToPrimitiveNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.OrdinaryToPrimitiveNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.SafeInteger;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

@ImportStatic(value={JSConfig.class})
public abstract class JSToPrimitiveNode
extends JavaScriptBaseNode {
    @Node.Child
    private OrdinaryToPrimitiveNode ordinaryToPrimitiveNode;
    protected final Hint hint;

    protected JSToPrimitiveNode(Hint hint) {
        this.hint = hint;
    }

    public abstract Object execute(Object var1);

    @NeverDefault
    public static JSToPrimitiveNode createHintDefault() {
        return JSToPrimitiveNode.create(Hint.Default);
    }

    @NeverDefault
    public static JSToPrimitiveNode createHintString() {
        return JSToPrimitiveNode.create(Hint.String);
    }

    @NeverDefault
    public static JSToPrimitiveNode createHintNumber() {
        return JSToPrimitiveNode.create(Hint.Number);
    }

    @NeverDefault
    public static JSToPrimitiveNode create(Hint hint) {
        return JSToPrimitiveNodeGen.create(hint);
    }

    @Specialization
    protected int doInt(int value) {
        return value;
    }

    @Specialization
    protected SafeInteger doSafeInteger(SafeInteger value) {
        return value;
    }

    @Specialization
    protected long doLong(long value) {
        return value;
    }

    @Specialization
    protected double doDouble(double value) {
        return value;
    }

    @Specialization
    protected boolean doBoolean(boolean value) {
        return value;
    }

    @Specialization
    protected Object doString(TruffleString value) {
        return value;
    }

    @Specialization
    protected Symbol doSymbol(Symbol value) {
        return value;
    }

    @Specialization
    protected BigInt doBigInt(BigInt value) {
        return value;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected JSDynamicObject doNull(Object value) {
        return Null.instance;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected JSDynamicObject doUndefined(Object value) {
        return Undefined.instance;
    }

    @Specialization
    protected final Object doJSObject(JSObject object, @Bind(value="this") Node node, @Cached.Exclusive @Cached(value="createGetToPrimitive()") PropertyGetNode getToPrimitive, @Cached.Exclusive @Cached IsPrimitiveNode isPrimitive, @Cached.Exclusive @Cached InlinedConditionProfile exoticToPrimProfile, @Cached.Exclusive @Cached(value="createCall()") JSFunctionCallNode callExoticToPrim) {
        Object exoticToPrim = getToPrimitive.getValue(object);
        if (exoticToPrimProfile.profile(node, !JSRuntime.isNullOrUndefined(exoticToPrim))) {
            Object result = callExoticToPrim.executeCall(JSArguments.createOneArg(object, exoticToPrim, this.hint.getHintName()));
            if (isPrimitive.executeBoolean(result)) {
                return result;
            }
            throw Errors.createTypeError("[Symbol.toPrimitive] method returned a non-primitive object", (Node)this);
        }
        return this.ordinaryToPrimitive(object);
    }

    protected final boolean isHintString() {
        return this.hint == Hint.String;
    }

    /*
     * Enabled aggressive block sorting
     */
    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"isForeignObject(object)"}, limit="InteropLibraryLimit")
    protected final Object doForeignObject(Object object, @Bind(value="this") Node node, @CachedLibrary(value="object") InteropLibrary interop, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary resultInterop, @Cached.Exclusive @Cached InlinedConditionProfile exoticToPrimProfile, @Cached.Exclusive @Cached ForeignObjectPrototypeNode foreignObjectPrototypeNode, @Cached.Exclusive @Cached(value="createGetToPrimitive()") PropertyGetNode getToPrimitive, @Cached.Exclusive @Cached IsPrimitiveNode isPrimitive, @Cached.Exclusive @Cached(value="createCall()") JSFunctionCallNode callExoticToPrim, @Cached.Exclusive @Cached InlinedBranchProfile errorBranch, @Cached TruffleString.SwitchEncodingNode switchEncoding) {
        Object primitive = JSInteropUtil.toPrimitiveOrDefaultLossless(object, null, interop, switchEncoding, this);
        if (primitive != null) {
            return primitive;
        }
        Object exoticToPrim = getToPrimitive.getValueOrUndefined(foreignObjectPrototypeNode.execute(object), object);
        if (exoticToPrimProfile.profile(node, !JSRuntime.isNullOrUndefined(exoticToPrim))) {
            Object result = callExoticToPrim.executeCall(JSArguments.createOneArg(object, exoticToPrim, this.hint.getHintName()));
            if (!isPrimitive.executeBoolean(result)) {
                errorBranch.enter(node);
                throw Errors.createTypeError("[Symbol.toPrimitive] method returned a non-primitive object", (Node)this);
            }
            primitive = result;
        } else {
            Object maybeResult;
            JSRealm realm = this.getRealm();
            TruffleLanguage.Env env = realm.getEnv();
            if (env.isHostObject(object) && (maybeResult = JSToPrimitiveNode.tryHostObjectToPrimitive(object, this.hint, interop)) != null) {
                return maybeResult;
            }
            primitive = this.ordinaryToPrimitive(object);
        }
        assert (IsPrimitiveNode.getUncached().executeBoolean(primitive)) : primitive;
        if (JSRuntime.isJSPrimitive(primitive)) {
            return primitive;
        }
        if ((primitive = JSInteropUtil.toPrimitiveOrDefaultLossless(primitive, null, resultInterop, switchEncoding, this)) != null) {
            return primitive;
        }
        errorBranch.enter(node);
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(this);
    }

    public static Object tryHostObjectToPrimitive(Object object, Hint hint, InteropLibrary interop) {
        if (hint != Hint.String && JavaScriptLanguage.get(interop).getJSContext().isOptionNashornCompatibilityMode() && interop.isMemberInvocable(object, "doubleValue")) {
            try {
                return interop.invokeMember(object, "doubleValue", new Object[0]);
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e2) {
                throw Errors.createTypeErrorInteropException(object, e2, "doubleValue()", interop);
            }
        }
        if (interop.isMetaObject(object)) {
            return JSToPrimitiveNode.javaClassToString(object, interop);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString javaClassToString(Object object, InteropLibrary interop) {
        try {
            String qualifiedName = InteropLibrary.getUncached().asString(interop.getMetaQualifiedName(object));
            if (JavaScriptLanguage.get(interop).getJSContext().isOptionNashornCompatibilityMode() && qualifiedName.endsWith("[]")) {
                Object hostObject = JSRealm.get(interop).getEnv().asHostObject(object);
                qualifiedName = ((Class)hostObject).getName();
            }
            return Strings.fromJavaString("class " + qualifiedName);
        }
        catch (UnsupportedMessageException e2) {
            throw Errors.createTypeErrorInteropException(object, e2, "getTypeName", interop);
        }
    }

    @Fallback
    protected TruffleString doFallback(Object value) {
        assert (value != null);
        throw Errors.createTypeErrorCannotConvertToPrimitiveValue(this);
    }

    private Object ordinaryToPrimitive(Object object) {
        if (this.ordinaryToPrimitiveNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.ordinaryToPrimitiveNode = this.insert(this.createOrdinaryToPrimitive());
        }
        return this.ordinaryToPrimitiveNode.execute(object);
    }

    protected PropertyGetNode createGetToPrimitive() {
        return PropertyGetNode.createGetMethod(Symbol.SYMBOL_TO_PRIMITIVE, this.getLanguage().getJSContext());
    }

    protected OrdinaryToPrimitiveNode createOrdinaryToPrimitive() {
        return OrdinaryToPrimitiveNode.create(this.isHintString() ? Hint.String : Hint.Number);
    }

    @NeverDefault
    public static JSToPrimitiveNode getUncachedHintDefault() {
        return Uncached.HINT_DEFAULT;
    }

    @NeverDefault
    public static JSToPrimitiveNode getUncachedHintNumber() {
        return Uncached.HINT_NUMBER;
    }

    @NeverDefault
    public static JSToPrimitiveNode getUncachedHintString() {
        return Uncached.HINT_STRING;
    }

    public static enum Hint {
        Default(Strings.HINT_DEFAULT),
        Number(Strings.HINT_NUMBER),
        String(Strings.HINT_STRING);

        private final TruffleString hintName;

        private Hint(TruffleString hintName) {
            this.hintName = hintName;
        }

        public TruffleString getHintName() {
            return this.hintName;
        }
    }

    @DenyReplace
    @GenerateCached(value=false)
    private static final class Uncached
    extends JSToPrimitiveNode {
        private static final JSToPrimitiveNode HINT_DEFAULT = new Uncached(Hint.Default);
        private static final JSToPrimitiveNode HINT_NUMBER = new Uncached(Hint.Number);
        private static final JSToPrimitiveNode HINT_STRING = new Uncached(Hint.String);

        protected Uncached(Hint hint) {
            super(hint);
        }

        @Override
        public Object execute(Object value) {
            return JSRuntime.toPrimitive(value, this.hint);
        }
    }
}

