/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control;

import java.util.ArrayDeque;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.control.AsyncGeneratorResumeNextNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSArguments;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAsyncGeneratorObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public class AsyncGeneratorResolveNode
extends JavaScriptBaseNode {
    @Node.Child
    private CreateIterResultObjectNode createIterResultObjectNode;
    @Node.Child
    private JSFunctionCallNode callResolveNode;
    @Node.Child
    private AsyncGeneratorResumeNextNode asyncGeneratorResumeNextNode;

    protected AsyncGeneratorResolveNode(JSContext context) {
        this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
        this.callResolveNode = JSFunctionCallNode.createCall();
    }

    public static AsyncGeneratorResolveNode create(JSContext context) {
        return new AsyncGeneratorResolveNode(context);
    }

    public Object execute(VirtualFrame frame, JSAsyncGeneratorObject generator, Object value, boolean done) {
        this.performResolve(frame, generator, value, done);
        if (this.asyncGeneratorResumeNextNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.asyncGeneratorResumeNextNode = this.insert(AsyncGeneratorResumeNextNode.create(this.getLanguage().getJSContext()));
        }
        this.asyncGeneratorResumeNextNode.execute(frame, generator);
        return Undefined.instance;
    }

    public void performResolve(VirtualFrame frame, JSAsyncGeneratorObject generator, Object value, boolean done) {
        ArrayDeque<AsyncGeneratorRequest> queue = generator.getAsyncGeneratorQueue();
        assert (!queue.isEmpty());
        AsyncGeneratorRequest next = queue.pollFirst();
        PromiseCapabilityRecord promiseCapability = next.getPromiseCapability();
        JSObject iteratorResult = this.createIterResultObjectNode.execute(frame, value, done);
        Object resolve = promiseCapability.getResolve();
        this.callResolveNode.executeCall(JSArguments.createOneArg(Undefined.instance, resolve, iteratorResult));
    }
}

