/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function;

import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.AbstractFunctionArgumentsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionOneArgumentNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionZeroArgumentsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.SpreadArgumentNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.SpreadFunctionArgumentsNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSInputGeneratingNodeWrapper;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;

public class JSFunctionArgumentsNode
extends AbstractFunctionArgumentsNode {
    @Node.Children
    protected final JavaScriptNode[] args;

    public static AbstractFunctionArgumentsNode create(JSContext context, JavaScriptNode[] args) {
        assert ((long)args.length <= context.getFunctionArgumentsLimit());
        for (JavaScriptNode arg : args) {
            if (!(arg instanceof SpreadArgumentNode)) continue;
            return SpreadFunctionArgumentsNodeGen.create(args);
        }
        if (args.length == 0) {
            return new JSFunctionZeroArgumentsNode();
        }
        if (args.length == 1) {
            return JSFunctionOneArgumentNode.create(args[0]);
        }
        return new JSFunctionArgumentsNode(args);
    }

    protected JSFunctionArgumentsNode(JavaScriptNode[] args) {
        this.args = args;
    }

    @Override
    public int getCount(VirtualFrame frame) {
        return this.args.length;
    }

    @Override
    @ExplodeLoop
    public Object[] executeFillObjectArray(VirtualFrame frame, Object[] arguments, int delta) {
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            arguments[i2 + delta] = this.args[i2].execute(frame);
        }
        return arguments;
    }

    @Override
    protected AbstractFunctionArgumentsNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return new JSFunctionArgumentsNode(JavaScriptNode.cloneUninitialized(this.args, materializedTags));
    }

    @Override
    public void materializeInstrumentableArguments() {
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            if (this.args[i2] instanceof SpreadArgumentNode || this.args[i2].isInstrumentable()) continue;
            this.args[i2] = this.insert(JSInputGeneratingNodeWrapper.create(this.args[i2]));
        }
    }
}

