/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation;

import java.util.ArrayList;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.FrameDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.instrumentation.Tag;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.BlockScopeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.FunctionBodyNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.JSTags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSFrameUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public final class DeclareTagProvider {
    public static JavaScriptNode createMaterializedFunctionBodyNode(JavaScriptNode original, JavaScriptNode body, FrameDescriptor frameDescriptor) {
        return new MaterializedFunctionBodyNode(original, body, frameDescriptor);
    }

    public static JavaScriptNode createMaterializedBlockNode(JavaScriptNode original, JavaScriptNode block, int blockScopeSlot, FrameDescriptor frameDescriptor, int parentSlot, boolean functionBlock, boolean captureFunctionFrame, boolean generatorFunctionBlock, boolean hasParentBlock, int start, int end) {
        return new MaterializedFrameBlockScopeNode(original, block, blockScopeSlot, frameDescriptor, parentSlot, functionBlock, captureFunctionFrame, generatorFunctionBlock, hasParentBlock, start, end);
    }

    public static boolean isMaterializedFrameProvider(JavaScriptNode node) {
        return node instanceof MaterializedFrameBlockScopeNode || node instanceof MaterializedFunctionBodyNode;
    }

    public static NodeObjectDescriptor createDeclareNodeObject(Object name, Object type) {
        NodeObjectDescriptor descriptor = JSTags.createNodeObjectDescriptor();
        descriptor.addProperty("declarationName", name);
        descriptor.addProperty("declarationType", type);
        return descriptor;
    }

    private DeclareTagProvider() {
    }

    private static JavaScriptNode[] initDeclarations(FrameDescriptor frameDescriptor, JavaScriptNode locationNode) {
        assert (locationNode != null);
        if (frameDescriptor != null) {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            for (int i2 = 0; i2 < frameDescriptor.getNumberOfSlots(); ++i2) {
                if (JSFrameUtil.isInternal(frameDescriptor, i2) || JSFrameUtil.isHoistable(frameDescriptor, i2)) continue;
                slots.add(i2);
            }
            JavaScriptNode[] declarations = new JavaScriptNode[slots.size()];
            for (int i3 = 0; i3 < slots.size(); ++i3) {
                DeclareProviderNode declaration = new DeclareProviderNode(frameDescriptor, (Integer)slots.get(i3));
                JavaScriptNode.transferSourceSection(locationNode, declaration);
                declarations[i3] = declaration;
            }
            return declarations;
        }
        return new JavaScriptNode[0];
    }

    private static class MaterializedFunctionBodyNode
    extends FunctionBodyNode {
        @Node.Children
        private JavaScriptNode[] declarations;

        protected MaterializedFunctionBodyNode(JavaScriptNode original, JavaScriptNode body, FrameDescriptor frameDescriptor) {
            this(body, DeclareTagProvider.initDeclarations(frameDescriptor, original));
        }

        protected MaterializedFunctionBodyNode(JavaScriptNode body, JavaScriptNode[] declarations) {
            super(body);
            this.declarations = declarations;
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            for (JavaScriptNode declaration : this.declarations) {
                declaration.execute(frame);
            }
            return super.execute(frame);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new MaterializedFunctionBodyNode(MaterializedFunctionBodyNode.cloneUninitialized(this.getBody(), materializedTags), MaterializedFunctionBodyNode.cloneUninitialized(this.declarations, materializedTags));
        }
    }

    private static class MaterializedFrameBlockScopeNode
    extends BlockScopeNode.FrameBlockScopeNode {
        @Node.Children
        private JavaScriptNode[] declarations;

        protected MaterializedFrameBlockScopeNode(JavaScriptNode original, JavaScriptNode block, int blockScopeSlot, FrameDescriptor frameDescriptor, int parentSlot, boolean functionBlock, boolean captureFunctionFrame, boolean generatorFunctionBlock, boolean hasParentBlock, int start, int end) {
            this(block, blockScopeSlot, frameDescriptor, parentSlot, functionBlock, captureFunctionFrame, generatorFunctionBlock, hasParentBlock, start, end, DeclareTagProvider.initDeclarations(frameDescriptor, original));
        }

        protected MaterializedFrameBlockScopeNode(JavaScriptNode block, int blockScopeSlot, FrameDescriptor frameDescriptor, int parentSlot, boolean functionBlock, boolean captureFunctionFrame, boolean generatorFunctionBlock, boolean hasParentBlock, int start, int end, JavaScriptNode[] declarations) {
            super(block, blockScopeSlot, frameDescriptor, parentSlot, functionBlock, captureFunctionFrame, generatorFunctionBlock, hasParentBlock, start, end);
            this.declarations = declarations;
        }

        @ExplodeLoop
        private void executeDeclarations(VirtualFrame frame) {
            for (JavaScriptNode declaration : this.declarations) {
                declaration.execute(frame);
            }
        }

        @Override
        public Object execute(VirtualFrame frame) {
            this.executeDeclarations(frame);
            return super.execute(frame);
        }

        @Override
        public void executeVoid(VirtualFrame frame) {
            this.executeDeclarations(frame);
            super.executeVoid(frame);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new MaterializedFrameBlockScopeNode(MaterializedFrameBlockScopeNode.cloneUninitialized(this.block, materializedTags), this.blockScopeSlot, this.frameDescriptor, this.parentSlot, this.functionBlock, this.captureFunctionFrame, this.generatorFunctionBlock, this.hasParentBlock, this.start, this.end, MaterializedFrameBlockScopeNode.cloneUninitialized(this.declarations, materializedTags));
        }
    }

    private static class DeclareProviderNode
    extends JavaScriptNode {
        private final FrameDescriptor frameDescriptor;
        private final int slotIndex;

        DeclareProviderNode(FrameDescriptor frameDescriptor, int slotIndex) {
            this.frameDescriptor = frameDescriptor;
            this.slotIndex = slotIndex;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return Undefined.instance;
        }

        @Override
        public boolean hasTag(Class<? extends Tag> tag) {
            if (tag == JSTags.DeclareTag.class) {
                return true;
            }
            return super.hasTag(tag);
        }

        @Override
        public boolean isInstrumentable() {
            return true;
        }

        @Override
        public Object getNodeObject() {
            String type = JSFrameUtil.isConst(this.frameDescriptor, this.slotIndex) ? "const" : (JSFrameUtil.isLet(this.frameDescriptor, this.slotIndex) ? "let" : "var");
            return DeclareTagProvider.createDeclareNodeObject(this.frameDescriptor.getSlotName(this.slotIndex), type);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new DeclareProviderNode(this.frameDescriptor, this.slotIndex);
        }
    }
}

