/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ExportValueNode;

public abstract class ExportArgumentsNode
extends JavaScriptBaseNode {
    private static final int MAX_FIXED = 250;

    public abstract Object[] export(Object[] var1);

    public static ExportArgumentsNode create(int expectedLength) {
        if (expectedLength >= 0 && expectedLength <= 250) {
            final class FixedLength
            extends ExportArgumentsNode {
                @Node.Children
                private final ExportValueNode[] exportNodes;

                FixedLength(int userArgumentCount) {
                    ExportValueNode[] exportNodeArray = new ExportValueNode[userArgumentCount];
                    for (int i2 = 0; i2 < exportNodeArray.length; ++i2) {
                        exportNodeArray[i2] = ExportValueNode.create();
                    }
                    this.exportNodes = exportNodeArray;
                }

                @Override
                @ExplodeLoop
                public Object[] export(Object[] extractedUserArguments) {
                    if (extractedUserArguments.length == this.exportNodes.length) {
                        for (int i2 = 0; i2 < this.exportNodes.length; ++i2) {
                            extractedUserArguments[i2] = this.exportNodes[i2].execute(extractedUserArguments[i2]);
                        }
                        return extractedUserArguments;
                    }
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    final class VariableLength
                    extends ExportArgumentsNode {
                        @Node.Child
                        private ExportValueNode exportNode = ExportValueNode.create();

                        VariableLength() {
                        }

                        @Override
                        public Object[] export(Object[] extractedUserArguments) {
                            for (int i2 = 0; i2 < extractedUserArguments.length; ++i2) {
                                extractedUserArguments[i2] = this.exportNode.execute(extractedUserArguments[i2]);
                            }
                            return extractedUserArguments;
                        }
                    }
                    return this.replace(new VariableLength()).export(extractedUserArguments);
                }
            }
            return new FixedLength(expectedLength);
        }
        return new VariableLength();
    }
}

