/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.intl.GetStringOptionNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class GetStringOptionNode
extends JavaScriptBaseNode {
    public static final List<String> LOCALE_MATCHER_OPTION_VALUES = List.of("best fit", "lookup");
    public static final List<String> HOUR_CYCLE_OPTION_VALUES = List.of("h11", "h12", "h23", "h24");
    public static final List<String> NARROW_SHORT_LONG_OPTION_VALUES = List.of("narrow", "short", "long");
    public static final List<String> LONG_SHORT_NARROW_OPTION_VALUES = List.of("long", "short", "narrow");
    public static final List<String> CASE_FIRST_OPTION_VALUES = List.of("upper", "lower", "false");
    private final List<String> validValues;
    private final String fallback;
    @Node.Child
    PropertyGetNode propertyGetNode;

    protected GetStringOptionNode(JSContext context, TruffleString property, List<String> values, String fallback) {
        this.validValues = values;
        this.fallback = fallback;
        this.propertyGetNode = PropertyGetNode.create(property, false, context);
    }

    public abstract String executeValue(Object var1);

    public static GetStringOptionNode create(JSContext context, TruffleString property, List<String> values, String fallback) {
        return GetStringOptionNodeGen.create(context, property, values, fallback);
    }

    @CompilerDirectives.TruffleBoundary
    private void ensureSelectedValueIsValid(String value) {
        if (!this.validValues.contains(value)) {
            throw Errors.createRangeError(String.format("invalid option %s found where only %s is allowed", value, this.validValues.toString()));
        }
    }

    @Specialization
    public String getOption(Object options, @Cached JSToStringNode toStringNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        Object propertyValue = this.propertyGetNode.getValue(options);
        if (propertyValue == Undefined.instance) {
            return this.fallback;
        }
        String value = toJavaStringNode.execute(toStringNode.executeString(propertyValue));
        if (this.validValues != null) {
            this.ensureSelectedValueIsValid(value);
        }
        return value;
    }
}

