/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class TemporalAddDateNode
extends JavaScriptBaseNode {
    protected TemporalAddDateNode() {
    }

    public abstract JSTemporalPlainDateObject execute(CalendarMethodsRecord var1, JSTemporalPlainDateObject var2, JSTemporalDurationObject var3, JSDynamicObject var4);

    @Specialization
    protected JSTemporalPlainDateObject addDate(CalendarMethodsRecord calendarRec, JSTemporalPlainDateObject plainDate, JSTemporalDurationObject duration, JSDynamicObject options, @Cached ToTemporalCalendarObjectNode toCalendarObject, @Cached(value="createCall()") JSFunctionCallNode callDateAddNode, @Cached InlinedBranchProfile errorBranch, @Cached TemporalGetOptionNode getOptionNode) {
        if (duration.getYears() != 0.0 || duration.getMonths() != 0.0 || duration.getWeeks() != 0.0) {
            return TemporalUtil.calendarDateAdd(calendarRec, plainDate, duration, options, toCalendarObject, callDateAddNode);
        }
        JSContext ctx = this.getJSContext();
        JSRealm realm = this.getRealm();
        TemporalUtil.Overflow overflow = TemporalUtil.toTemporalOverflow(options, getOptionNode);
        BigInt norm = TemporalUtil.normalizeTimeDuration(duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds());
        TimeDurationRecord balancedDuration = TemporalUtil.balanceTimeDuration(norm, TemporalUtil.Unit.DAY);
        double days = duration.getDays() + balancedDuration.days();
        ISODateRecord result = TemporalUtil.addISODate(plainDate.getYear(), plainDate.getMonth(), plainDate.getDay(), 0.0, 0.0, 0.0, days, overflow);
        return JSTemporalPlainDate.create(ctx, realm, result.year(), result.month(), result.day(), calendarRec.receiver(), this, errorBranch);
    }
}

