/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.ImportStatic;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.PropertyGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.cast.JSToStringNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;

@ImportStatic(value={TemporalConstants.class})
public abstract class ToFractionalSecondDigitsNode
extends JavaScriptBaseNode {
    public static final int AUTO = -1;

    public abstract int execute(Object var1);

    @Specialization
    protected int toFractionalSecondDigits(Object normalizedOptions, @Cached(value="create(FRACTIONAL_SECOND_DIGITS, getJSContext())") PropertyGetNode getFractionalSecondDigits, @Cached JSToStringNode toStringNode, @Cached TruffleString.EqualNode equalNode, @Cached InlinedBranchProfile errorBranch) {
        Object digitsValue = getFractionalSecondDigits.getValue(normalizedOptions);
        if (digitsValue == Undefined.instance) {
            return -1;
        }
        if (digitsValue instanceof Number) {
            Number numberValue = (Number)digitsValue;
            if (JSRuntime.isNaN(numberValue)) {
                errorBranch.enter(this);
                throw ToFractionalSecondDigitsNode.invalidDigits();
            }
            double digitCount = Math.floor(JSRuntime.toDouble(numberValue));
            if (digitCount < 0.0 || digitCount > 9.0) {
                errorBranch.enter(this);
                throw ToFractionalSecondDigitsNode.invalidDigits();
            }
            return (int)digitCount;
        }
        TruffleString stringValue = toStringNode.executeString(digitsValue);
        if (!Strings.equals(equalNode, TemporalConstants.AUTO, stringValue)) {
            errorBranch.enter(this);
            throw ToFractionalSecondDigitsNode.invalidDigits();
        }
        return -1;
    }

    private static JSException invalidDigits() {
        return Errors.createRangeError("Invalid fractionalSecondDigits");
    }
}

