/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import java.util.Locale;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ObjectImplementsTemporalCalendarProtocolNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarSlotValueNodeGen;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalCalendarSlotValueNode
extends JavaScriptBaseNode {
    private final TruffleString defaultValue;

    protected ToTemporalCalendarSlotValueNode(TruffleString defaultValue) {
        this.defaultValue = defaultValue;
    }

    @NeverDefault
    public static ToTemporalCalendarSlotValueNode create() {
        return ToTemporalCalendarSlotValueNode.createWithDefault(null);
    }

    @NeverDefault
    public static ToTemporalCalendarSlotValueNode createWithISO8601() {
        return ToTemporalCalendarSlotValueNode.createWithDefault(TemporalConstants.ISO8601);
    }

    @NeverDefault
    public static ToTemporalCalendarSlotValueNode createWithDefault(TruffleString defaultValue) {
        return ToTemporalCalendarSlotValueNodeGen.create(defaultValue);
    }

    public abstract Object execute(Object var1);

    @Specialization
    public Object toTemporalCalendarSlotValue(Object temporalCalendarLike, @Cached IsObjectNode isObjectNode, @Cached ObjectImplementsTemporalCalendarProtocolNode implementsCalendarProtocol, @Cached TruffleString.FromJavaStringNode fromJavaString, @Cached TruffleString.ToJavaStringNode toJavaString) {
        if (this.defaultValue != null && temporalCalendarLike == Undefined.instance) {
            return this.defaultValue;
        }
        if (isObjectNode.executeBoolean(temporalCalendarLike)) {
            if (temporalCalendarLike instanceof JSTemporalCalendarHolder) {
                JSTemporalCalendarHolder calendarHolder = (JSTemporalCalendarHolder)temporalCalendarLike;
                return calendarHolder.getCalendar();
            }
            if (implementsCalendarProtocol.execute(temporalCalendarLike)) {
                return temporalCalendarLike;
            }
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
        if (!(temporalCalendarLike instanceof TruffleString)) {
            throw Errors.createTypeErrorNotAString(temporalCalendarLike);
        }
        TruffleString identifier = TemporalUtil.parseTemporalCalendarString((TruffleString)temporalCalendarLike);
        if (!TemporalUtil.isBuiltinCalendar(identifier)) {
            throw TemporalErrors.createRangeErrorCalendarUnknown();
        }
        return fromJavaString.execute(Strings.javaStringToLowerCase(toJavaString.execute(identifier), Locale.US), TruffleString.Encoding.UTF_16);
    }
}

