/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Cached;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Specialization;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.access.IsObjectNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.CalendarMethodsRecordLookupNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.CreateTimeZoneMethodsRecordNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarSlotValueWithISODefaultNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.SnapshotOwnPropertiesNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneSlotValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.CalendarMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.ParseISODateTimeResult;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.temporal.TimeZoneMethodsRecord;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalConstants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalErrors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TemporalUtil;

public abstract class ToTemporalZonedDateTimeNode
extends JavaScriptBaseNode {
    protected ToTemporalZonedDateTimeNode() {
    }

    public abstract JSTemporalZonedDateTimeObject execute(Object var1, JSDynamicObject var2);

    @Specialization
    public JSTemporalZonedDateTimeObject toTemporalZonedDateTime(Object item, JSDynamicObject options, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile isZonedDateTimeProfile, @Cached SnapshotOwnPropertiesNode snapshotOwnProperties, @Cached IsObjectNode isObjectNode, @Cached(value="createDateFromFields()") CalendarMethodsRecordLookupNode lookupDateFromFields, @Cached(value="createFields()") CalendarMethodsRecordLookupNode lookupFields, @Cached TruffleString.EqualNode equalNode, @Cached TemporalGetOptionNode getOptionNode, @Cached ToTemporalTimeZoneSlotValueNode toTimeZoneSlotValue, @Cached GetTemporalCalendarSlotValueWithISODefaultNode getCalendarSlotValueWithISODefault, @Cached TemporalCalendarFieldsNode calendarFieldsNode, @Cached TemporalCalendarDateFromFieldsNode dateFromFieldsNode, @Cached CreateTimeZoneMethodsRecordNode createTimeZoneMethodsRecord) {
        JSTemporalDateTimeRecord result;
        TemporalUtil.OffsetOption offsetOption;
        TemporalUtil.Disambiguation disambiguation;
        Object timeZone;
        Object calendar;
        TruffleString offsetString = null;
        JSContext ctx = this.getLanguage().getJSContext();
        JSRealm realm = this.getRealm();
        JSObject resolvedOptions = snapshotOwnProperties.snapshot(options, Null.instance);
        TemporalUtil.OffsetBehaviour offsetBehaviour = TemporalUtil.OffsetBehaviour.OPTION;
        TemporalUtil.MatchBehaviour matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_EXACTLY;
        if (isObjectProfile.profile(this, isObjectNode.executeBoolean(item))) {
            if (isZonedDateTimeProfile.profile(this, TemporalUtil.isTemporalZonedDateTime(item))) {
                return (JSTemporalZonedDateTimeObject)item;
            }
            calendar = getCalendarSlotValueWithISODefault.execute(item);
            Object dateFromFieldsMethod = lookupDateFromFields.execute(calendar);
            Object fieldsMethod = lookupFields.execute(calendar);
            CalendarMethodsRecord calendarRec = CalendarMethodsRecord.forDateFromFieldsAndFields(calendar, dateFromFieldsMethod, fieldsMethod);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendarRec, Boundaries.listEditableCopy(TemporalUtil.listDMMCY));
            ToTemporalZonedDateTimeNode.addFieldNames(fieldNames);
            JSObject fields = TemporalUtil.prepareTemporalFields(ctx, item, fieldNames, TemporalUtil.listTimeZone);
            Object timeZoneObj = JSObject.get((JSDynamicObject)fields, TemporalConstants.TIME_ZONE);
            timeZone = toTimeZoneSlotValue.execute(timeZoneObj);
            Object offsetStringObj = JSObject.get((JSDynamicObject)fields, TemporalConstants.OFFSET);
            if (offsetStringObj == Undefined.instance) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.WALL;
            } else {
                offsetString = (TruffleString)offsetStringObj;
            }
            disambiguation = TemporalUtil.toTemporalDisambiguation(resolvedOptions, getOptionNode, equalNode);
            offsetOption = TemporalUtil.toTemporalOffset(resolvedOptions, TemporalConstants.REJECT, getOptionNode, equalNode);
            result = TemporalUtil.interpretTemporalDateTimeFields(calendarRec, fields, resolvedOptions, getOptionNode, dateFromFieldsNode);
        } else if (item instanceof TruffleString) {
            TruffleString string = (TruffleString)item;
            ParseISODateTimeResult resultZDT = TemporalUtil.parseTemporalZonedDateTimeString(string);
            result = resultZDT;
            TruffleString timeZoneName = resultZDT.getTimeZoneResult().getName();
            assert (timeZoneName != null);
            if (!TemporalUtil.canParseAsTimeZoneNumericUTCOffset(timeZoneName) && (timeZoneName = TemporalUtil.canonicalizeTimeZoneName(timeZoneName)) == null) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorInvalidTimeZoneString();
            }
            offsetString = resultZDT.getTimeZoneResult().getOffsetString();
            offsetBehaviour = resultZDT.getTimeZoneResult().isZ() ? TemporalUtil.OffsetBehaviour.EXACT : TemporalUtil.OffsetBehaviour.WALL;
            timeZone = TemporalUtil.createTemporalTimeZone(ctx, realm, timeZoneName);
            calendar = result.getCalendar();
            if (calendar == null) {
                calendar = TemporalConstants.ISO8601;
            }
            if (!TemporalUtil.isBuiltinCalendar((TruffleString)calendar)) {
                errorBranch.enter(this);
                throw TemporalErrors.createRangeErrorCalendarNotSupported();
            }
            matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_MINUTES;
            disambiguation = TemporalUtil.toTemporalDisambiguation(resolvedOptions, getOptionNode, equalNode);
            offsetOption = TemporalUtil.toTemporalOffset(resolvedOptions, TemporalConstants.REJECT, getOptionNode, equalNode);
            TemporalUtil.toTemporalOverflow(resolvedOptions, getOptionNode);
        } else {
            errorBranch.enter(this);
            throw Errors.createTypeErrorNotAString(item);
        }
        long offsetNanoseconds = 0L;
        if (offsetBehaviour == TemporalUtil.OffsetBehaviour.OPTION) {
            offsetNanoseconds = TemporalUtil.parseTimeZoneOffsetString(offsetString);
        }
        TimeZoneMethodsRecord timeZoneRec = createTimeZoneMethodsRecord.executeFull(timeZone);
        BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(ctx, realm, result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), offsetBehaviour, offsetNanoseconds, timeZoneRec, disambiguation, offsetOption, matchBehaviour);
        return JSTemporalZonedDateTime.create(ctx, realm, epochNanoseconds, timeZone, calendar);
    }

    @CompilerDirectives.TruffleBoundary
    private static void addFieldNames(List<TruffleString> fieldNames) {
        fieldNames.add(TemporalConstants.HOUR);
        fieldNames.add(TemporalConstants.MICROSECOND);
        fieldNames.add(TemporalConstants.MILLISECOND);
        fieldNames.add(TemporalConstants.MINUTE);
        fieldNames.add(TemporalConstants.NANOSECOND);
        fieldNames.add(TemporalConstants.OFFSET);
        fieldNames.add(TemporalConstants.SECOND);
        fieldNames.add(TemporalConstants.TIME_ZONE);
    }
}

