/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.Truffle;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.Idempotent;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.InlineSupport;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.ConstantEmptyArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.ConstantObjectArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.InlinedProfileBag;

public abstract class ScriptArray {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public abstract Object getElement(JSDynamicObject var1, long var2);

    public abstract Object getElementInBounds(JSDynamicObject var1, long var2);

    public abstract ScriptArray setElementImpl(JSDynamicObject var1, long var2, Object var4, boolean var5);

    public final ScriptArray setElement(JSDynamicObject object, long index, Object value, boolean strict) {
        if (this.isFrozen()) {
            if (strict) {
                ScriptArray.setElementFrozenStrict(index);
            }
            return this;
        }
        if (this.isLengthNotWritable() && index >= this.length(object)) {
            if (strict) {
                throw Errors.createTypeErrorLengthNotWritable();
            }
            return this;
        }
        return this.setElementImpl(object, index, value, strict);
    }

    @CompilerDirectives.TruffleBoundary
    private static void setElementFrozenStrict(long index) {
        JSContext context = JavaScriptLanguage.getCurrentLanguage().getJSContext();
        if (context.isOptionNashornCompatibilityMode()) {
            throw Errors.createTypeErrorFormat("Cannot set property \"%d\" of frozen array", index);
        }
        throw Errors.createTypeErrorCannotRedefineProperty(index);
    }

    public abstract ScriptArray deleteElementImpl(JSDynamicObject var1, long var2, boolean var4);

    public final ScriptArray deleteElement(JSDynamicObject object, long index, boolean strict) {
        assert (this.canDeleteElement(object, index, strict));
        return this.deleteElementImpl(object, index, strict);
    }

    public final boolean canDeleteElement(JSDynamicObject object, long index, boolean strict) {
        if (this.isSealed() && this.hasElement(object, index)) {
            if (strict) {
                throw Errors.createTypeErrorCannotDeletePropertyOfSealedArray(index);
            }
            return false;
        }
        return true;
    }

    public abstract boolean hasElement(JSDynamicObject var1, long var2);

    public abstract long length(JSDynamicObject var1);

    public abstract int lengthInt(JSDynamicObject var1);

    public abstract ScriptArray setLengthImpl(JSDynamicObject var1, long var2, Node var4, SetLengthProfileAccess var5);

    public final ScriptArray setLength(JSDynamicObject object, long len, boolean strict, Node node, SetLengthProfileAccess profile) {
        if (this.isLengthNotWritable()) {
            if (strict) {
                throw Errors.createTypeErrorLengthNotWritable();
            }
            return this;
        }
        if (this.isSealed()) assert (len >= this.lastElementIndex(object) + 1L);
        return this.setLengthImpl(object, len, node, profile);
    }

    public final ScriptArray setLength(JSDynamicObject object, long len, boolean strict) {
        return this.setLength(object, len, strict, null, SetLengthProfileAccess.getUncached());
    }

    public abstract long firstElementIndex(JSDynamicObject var1);

    public abstract long lastElementIndex(JSDynamicObject var1);

    public abstract long nextElementIndex(JSDynamicObject var1, long var2);

    public abstract long previousElementIndex(JSDynamicObject var1, long var2);

    public boolean isInBoundsFast(JSDynamicObject object, long index) {
        return this.firstElementIndex(object) <= index && index <= this.lastElementIndex(object);
    }

    public Iterable<Object> asIterable(final JSDynamicObject object) {
        return new Iterable<Object>(this){
            final /* synthetic */ ScriptArray this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public Iterator<Object> iterator() {
                return this.this$0.new DefaultIterator(object);
            }
        };
    }

    @CompilerDirectives.TruffleBoundary
    public final Object[] toArray(JSDynamicObject thisObj) {
        int len = this.lengthInt(thisObj);
        Object[] newArray = new Object[len];
        Arrays.fill(newArray, Undefined.instance);
        long i2 = this.firstElementIndex(thisObj);
        while (i2 <= this.lastElementIndex(thisObj)) {
            if (i2 >= 0L) {
                newArray[(int)i2] = this.getElement(thisObj, i2);
            }
            i2 = this.nextElementIndex(thisObj, i2);
        }
        return newArray;
    }

    public static AbstractConstantArray createConstantEmptyArray() {
        return ConstantEmptyArray.createConstantEmptyArray();
    }

    public static AbstractConstantArray createConstantArray(Object[] elements) {
        if (elements == null || elements.length == 0) {
            return ScriptArray.createConstantEmptyArray();
        }
        return ConstantObjectArray.createConstantObjectArray();
    }

    public static boolean valueIsByte(int value) {
        return -128 <= value && value <= 127;
    }

    @CompilerDirectives.TruffleBoundary
    protected static final void traceArrayTransition(ScriptArray oldArray, ScriptArray newArray, long index, Object value) {
        String access = oldArray.getClass().getSimpleName() + " -> " + newArray.getClass().getSimpleName();
        ArrayList stackTrace = new ArrayList();
        Truffle.getRuntime().iterateFrames(frameInstance -> {
            stackTrace.add(frameInstance);
            return null;
        });
        Stream<Node> nodeStream = stackTrace.stream().map(fi -> fi.getCallNode()).filter(callNode -> callNode != null);
        int stackTraceLimit = JavaScriptLanguage.getCurrentLanguage().getJSContext().getLanguageOptions().stackTraceLimit();
        StackTraceElement[] array = (StackTraceElement[])nodeStream.filter(n2 -> n2.getEncapsulatingSourceSection() != null).map(node -> {
            SourceSection callNodeSourceSection = node.getEncapsulatingSourceSection();
            String declaringClass = "js";
            String methodName = node.getRootNode().getName();
            String fileName = callNodeSourceSection.isAvailable() ? callNodeSourceSection.getSource().getName() : "<unknown>";
            int startLine = callNodeSourceSection.getStartLine();
            return new StackTraceElement(declaringClass, methodName != null ? methodName : "<unknown>", fileName, startLine);
        }).limit(stackTraceLimit).toArray(StackTraceElement[]::new);
        System.out.printf("[js]      array transition %-48s |index %5s |value %-20s |caller %5s\n", access, index, value, array[0]);
    }

    @CompilerDirectives.TruffleBoundary
    protected static final void traceWrite(String access, long index, Object value) {
        System.out.printf("[js]      array set        %-48s |index %5s |value %-20s\n", access, index, value);
    }

    @Idempotent
    public boolean isHolesType() {
        return false;
    }

    public abstract boolean hasHoles(JSDynamicObject var1);

    public boolean hasHolesOrUnused(JSDynamicObject object) {
        return this.hasHoles(object);
    }

    public abstract ScriptArray removeRangeImpl(JSDynamicObject var1, long var2, long var4);

    public final ScriptArray removeRange(JSDynamicObject object, long start, long end) {
        assert (start >= 0L && start <= end);
        if (this.isSealed()) {
            throw Errors.createTypeErrorCannotDeletePropertyOfSealedArray(start);
        }
        return this.removeRangeImpl(object, start, end);
    }

    public final ScriptArray removeRange(JSDynamicObject object, long start, long end, BranchProfile errorBranch) {
        assert (start >= 0L && start <= end);
        if (this.isSealed()) {
            errorBranch.enter();
            throw Errors.createTypeErrorCannotDeletePropertyOfSealedArray(start);
        }
        return this.removeRangeImpl(object, start, end);
    }

    public ScriptArray shiftRangeImpl(JSDynamicObject object, long limit) {
        return this.removeRangeImpl(object, 0L, limit);
    }

    public final ScriptArray shiftRange(JSDynamicObject object, long from) {
        assert (from >= 0L);
        assert (!this.isSealed());
        return this.shiftRangeImpl(object, from);
    }

    public abstract ScriptArray addRangeImpl(JSDynamicObject var1, long var2, int var4);

    public final ScriptArray addRange(JSDynamicObject object, long offset, int size) {
        if (!this.isExtensible()) {
            throw this.addRangeNotExtensible();
        }
        return this.addRangeImpl(object, offset, size);
    }

    @CompilerDirectives.TruffleBoundary
    private JSException addRangeNotExtensible() {
        if (this.isFrozen()) {
            throw Errors.createTypeError("Cannot add property of frozen array");
        }
        if (this.isSealed()) {
            throw Errors.createTypeError("Cannot add property to sealed array");
        }
        throw Errors.createTypeError("Cannot add property to non-extensible array");
    }

    public List<Object> ownPropertyKeys(JSDynamicObject object) {
        assert (!this.isHolesType() || !this.hasHoles(object));
        return this.ownPropertyKeysContiguous(object);
    }

    protected final List<Object> ownPropertyKeysContiguous(JSDynamicObject object) {
        return ScriptArray.makeRangeList(this.firstElementIndex(object), this.lastElementIndex(object) + 1L);
    }

    @CompilerDirectives.TruffleBoundary
    protected final List<Object> ownPropertyKeysHoles(JSDynamicObject object) {
        long currentIndex;
        long start = currentIndex = this.firstElementIndex(object);
        long end = currentIndex;
        long total = 0L;
        ArrayList<Long> rangeList = new ArrayList<Long>();
        while (currentIndex <= this.lastElementIndex(object)) {
            if (currentIndex == end) {
                end = currentIndex + 1L;
            } else {
                assert (end < currentIndex);
                assert (start < end);
                total += end - start;
                rangeList.add(start);
                rangeList.add(end);
                start = currentIndex;
                end = currentIndex + 1L;
            }
            currentIndex = this.nextElementIndex(object, currentIndex);
        }
        if (start < end) {
            total += end - start;
            if (rangeList.isEmpty()) {
                return ScriptArray.makeRangeList(start, end);
            }
            rangeList.add(start);
            rangeList.add(end);
        }
        assert (total >= 0L && total <= Integer.MAX_VALUE) : total;
        return ScriptArray.makeMultiRangeList((int)total, ScriptArray.toLongArray(rangeList));
    }

    private static long[] toLongArray(List<Long> longList) {
        long[] longArray = new long[longList.size()];
        for (int i2 = 0; i2 < longArray.length; ++i2) {
            longArray[i2] = longList.get(i2);
        }
        return longArray;
    }

    public static List<Object> makeRangeList(final long rangeStart, final long rangeEnd) {
        assert (rangeEnd - rangeStart >= 0L && rangeEnd - rangeStart <= Integer.MAX_VALUE);
        return new AbstractList<Object>(){

            @Override
            public Object get(int index) {
                if (index >= 0 && rangeStart + (long)index < rangeEnd) {
                    return Strings.fromLong(rangeStart + (long)index);
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int size() {
                return (int)(rangeEnd - rangeStart);
            }
        };
    }

    protected static List<Object> makeMultiRangeList(final int total, final long[] ranges) {
        return new AbstractList<Object>(){

            @Override
            public Object get(int index) {
                if (index >= 0) {
                    long relativeIndex = index;
                    for (int rangeIndex = 0; rangeIndex < ranges.length; rangeIndex += 2) {
                        long rangeEnd = ranges[rangeIndex + 1];
                        long rangeStart = ranges[rangeIndex];
                        long rangeLen = rangeEnd - rangeStart;
                        if (relativeIndex < rangeLen) {
                            return Strings.fromLong(rangeStart + relativeIndex);
                        }
                        relativeIndex -= rangeLen;
                    }
                }
                throw new IndexOutOfBoundsException();
            }

            @Override
            public int size() {
                return total;
            }
        };
    }

    protected static int nextPower(int length) {
        if (length < 8) {
            return 8;
        }
        return ScriptArray.nextPow2(length);
    }

    private static int nextPow2(int val) {
        int x2 = val - 1;
        x2 |= x2 >> 1;
        x2 |= x2 >> 2;
        x2 |= x2 >> 4;
        x2 |= x2 >> 8;
        x2 |= x2 >> 16;
        return x2 + 1;
    }

    public boolean isSealed() {
        return false;
    }

    public boolean isFrozen() {
        return false;
    }

    public boolean isLengthNotWritable() {
        return false;
    }

    public boolean isExtensible() {
        return true;
    }

    public abstract ScriptArray seal();

    public abstract ScriptArray freeze();

    public abstract ScriptArray setLengthNotWritable();

    public abstract ScriptArray preventExtensions();

    public final boolean isInstance(ScriptArray other) {
        CompilerAsserts.partialEvaluationConstant(this);
        return this == other;
    }

    public final ScriptArray cast(ScriptArray other) {
        CompilerAsserts.partialEvaluationConstant(this);
        assert (this == other);
        return this;
    }

    public static class SetLengthProfileAccess
    extends CreateWritableProfileAccess {
        private static final int REQUIRED_BITS = 16;
        protected static final int TOTAL_REQUIRED_BITS = 24;
        private static final int lengthZero;
        private static final int lengthLess;
        private static final int zeroBasedSetUsedLength;
        private static final int zeroBasedClearUnusedArea;
        private static final int contiguousZeroUsed;
        private static final int contiguousNegativeUsed;
        private static final int contiguousShrinkUsed;
        private static final int clearUnusedArea;
        private static final SetLengthProfileAccess UNCACHED;

        @NeverDefault
        public static SetLengthProfileAccess getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static SetLengthProfileAccess inline(@InlineSupport.RequiredField(value=InlineSupport.StateField.class, bits=24) InlineSupport.InlineTarget inlineTarget) {
            return new SetLengthProfileAccess(inlineTarget.getState(0, 24));
        }

        protected SetLengthProfileAccess(InlineSupport.StateField stateField) {
            super(stateField);
        }

        public final boolean lengthZero(Node node, boolean condition) {
            return this.profile(node, condition, lengthZero);
        }

        public final boolean lengthLess(Node node, boolean condition) {
            return this.profile(node, condition, lengthLess);
        }

        public final boolean zeroBasedSetUsedLength(Node node, boolean condition) {
            return this.profile(node, condition, zeroBasedSetUsedLength);
        }

        public final boolean zeroBasedClearUnusedArea(Node node, boolean condition) {
            return this.profile(node, condition, zeroBasedClearUnusedArea);
        }

        public final boolean contiguousZeroUsed(Node node, boolean condition) {
            return this.profile(node, condition, contiguousZeroUsed);
        }

        public final boolean contiguousNegativeUsed(Node node, boolean condition) {
            return this.profile(node, condition, contiguousNegativeUsed);
        }

        public final boolean contiguousShrinkUsed(Node node, boolean condition) {
            return this.profile(node, condition, contiguousShrinkUsed);
        }

        public final boolean clearUnusedArea(Node node, boolean condition) {
            return this.profile(node, condition, clearUnusedArea);
        }

        static {
            try (InlinedProfileBag.Builder b2 = new InlinedProfileBag.Builder(8, 16);){
                lengthZero = b2.conditionProfile();
                lengthLess = b2.conditionProfile();
                zeroBasedSetUsedLength = b2.conditionProfile();
                zeroBasedClearUnusedArea = b2.conditionProfile();
                contiguousZeroUsed = b2.conditionProfile();
                contiguousNegativeUsed = b2.conditionProfile();
                contiguousShrinkUsed = b2.conditionProfile();
                clearUnusedArea = b2.conditionProfile();
            }
            UNCACHED = new SetLengthProfileAccess(null);
        }
    }

    protected final class DefaultIterator
    implements Iterator<Object> {
        private long currentIndex;
        private final JSDynamicObject arrayObject;

        public DefaultIterator(JSDynamicObject arrayObject) {
            this.arrayObject = arrayObject;
            this.currentIndex = ScriptArray.this.firstElementIndex(arrayObject);
        }

        @Override
        public void remove() {
            --this.currentIndex;
        }

        @Override
        public Object next() {
            assert (this.currentIndex >= ScriptArray.this.firstElementIndex(this.arrayObject));
            Object element = ScriptArray.this.getElement(this.arrayObject, this.currentIndex);
            this.currentIndex = ScriptArray.this.nextElementIndex(this.arrayObject, this.currentIndex);
            return element;
        }

        @Override
        public boolean hasNext() {
            assert (this.currentIndex >= ScriptArray.this.firstElementIndex(this.arrayObject));
            return this.currentIndex <= ScriptArray.this.lastElementIndex(this.arrayObject);
        }
    }

    public static class CreateWritableProfileAccess
    extends InlinedProfileBag {
        protected static final int REQUIRED_BITS = 8;
        private static final int newArrayLengthZero;
        private static final int newArrayLengthBelowLimit;
        private static final int indexZero;
        private static final int indexLessThanLength;
        private static final CreateWritableProfileAccess UNCACHED;

        @NeverDefault
        public static CreateWritableProfileAccess getUncached() {
            return UNCACHED;
        }

        @NeverDefault
        public static CreateWritableProfileAccess inline(@InlineSupport.RequiredField(value=InlineSupport.StateField.class, bits=8) InlineSupport.InlineTarget inlineTarget) {
            return new CreateWritableProfileAccess(inlineTarget.getState(0, 8));
        }

        protected CreateWritableProfileAccess(InlineSupport.StateField stateField) {
            super(stateField);
        }

        public boolean newArrayLengthZero(Node node, boolean condition) {
            return this.profile(node, condition, newArrayLengthZero);
        }

        public final boolean newArrayLengthBelowLimit(Node node, boolean condition) {
            return this.profile(node, condition, newArrayLengthBelowLimit);
        }

        public final boolean indexZero(Node node, boolean condition) {
            return this.profile(node, condition, indexZero);
        }

        public final boolean indexLessThanLength(Node node, boolean condition) {
            return this.profile(node, condition, indexLessThanLength);
        }

        static {
            try (InlinedProfileBag.Builder b2 = new InlinedProfileBag.Builder(8);){
                newArrayLengthZero = b2.conditionProfile();
                newArrayLengthBelowLimit = b2.conditionProfile();
                indexZero = b2.conditionProfile();
                indexLessThanLength = b2.conditionProfile();
            }
            UNCACHED = new CreateWritableProfileAccess(null);
        }
    }
}

