/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn;

import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.DynamicArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.HolesObjectArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public abstract class AbstractObjectArray
extends AbstractWritableArray {
    protected AbstractObjectArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    @Override
    AbstractWritableArray sameTypeHolesArray(JSDynamicObject object, int length, Object array, long indexOffset, int arrayOffset, int usedLength, int holeCount) {
        return HolesObjectArray.makeHolesObjectArray(object, length, (Object[])array, indexOffset, arrayOffset, usedLength, holeCount, this.integrityLevel);
    }

    public abstract void setInBoundsFast(JSDynamicObject var1, int var2, Object var3);

    @Override
    public final ScriptArray setElementImpl(JSDynamicObject object, long index, Object value, boolean strict) {
        assert (JSRuntime.isArrayIndex(index)) : index;
        if (CompilerDirectives.injectBranchProbability(0.9999, this.isSupported(object, index))) {
            assert (value != null);
            this.setSupported(object, (int)index, value, null, AbstractWritableArray.SetSupportedProfileAccess.getUncached());
            return this;
        }
        return this.rewrite(object, index, value).setElementImpl(object, index, value, strict);
    }

    private ScriptArray rewrite(JSDynamicObject object, long index, Object value) {
        if (this.isSupportedContiguous(object, index)) {
            return this.toContiguous(object, index, value);
        }
        if (this.isSupportedHoles(object, index)) {
            return this.toHoles(object, index, value);
        }
        return this.toSparse(object, index, value);
    }

    @Override
    public Object getInBoundsFast(JSDynamicObject object, int index) {
        return this.getInBoundsFastObject(object, index);
    }

    @Override
    int getArrayLength(Object array) {
        return ((Object[])array).length;
    }

    protected static Object[] getArray(JSDynamicObject object) {
        Object array = JSAbstractArray.arrayGetArray(object);
        if (array.getClass() == Object[].class) {
            return CompilerDirectives.castExact(array, Object[].class);
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public abstract Object getInBoundsFastObject(JSDynamicObject var1, int var2);

    public final void setInBounds(JSDynamicObject object, int index, Object value, Node node, AbstractWritableArray.SetSupportedProfileAccess profile) {
        AbstractObjectArray.getArray((JSDynamicObject)object)[this.prepareInBounds((JSDynamicObject)object, (int)index, (Node)node, (AbstractWritableArray.SetSupportedProfileAccess)profile)] = AbstractObjectArray.checkNonNull(value);
    }

    public final void setSupported(JSDynamicObject object, int index, Object value, Node node, AbstractWritableArray.SetSupportedProfileAccess profile) {
        int preparedIndex = this.prepareSupported(object, index, node, profile);
        AbstractObjectArray.getArray((JSDynamicObject)object)[preparedIndex] = AbstractObjectArray.checkNonNull(value);
    }

    @Override
    void fillWithHoles(Object array, int fromIndex, int toIndex) {
        Object[] objectArray = (Object[])array;
        for (int i2 = fromIndex; i2 < toIndex; ++i2) {
            objectArray[i2] = null;
        }
    }

    @Override
    protected final void setHoleValue(JSDynamicObject object, int preparedIndex) {
        AbstractObjectArray.getArray((JSDynamicObject)object)[preparedIndex] = null;
    }

    @Override
    protected final void fillHoles(JSDynamicObject object, int internalIndex, int grown, Node node, AbstractWritableArray.SetSupportedProfileAccess profile) {
        if (grown != 0) {
            this.incrementHolesCount(object, Math.abs(grown) - 1);
        }
        assert (this.checkFillHoles(object, internalIndex, grown));
    }

    @Override
    protected final boolean isHolePrepared(JSDynamicObject object, int preparedIndex) {
        return HolesObjectArray.isHoleValue(AbstractObjectArray.getArray(object)[preparedIndex]);
    }

    @Override
    protected final int getArrayCapacity(JSDynamicObject object) {
        return AbstractObjectArray.getArray(object).length;
    }

    @Override
    protected final void resizeArray(JSDynamicObject object, int newCapacity, int oldCapacity, int offset) {
        Object[] newArray = new Object[newCapacity];
        System.arraycopy(AbstractObjectArray.getArray(object), 0, newArray, offset, oldCapacity);
        JSAbstractArray.arraySetArray(object, newArray);
    }

    @Override
    public abstract AbstractObjectArray toHoles(JSDynamicObject var1, long var2, Object var4);

    @Override
    public final AbstractWritableArray toDouble(JSDynamicObject object, long index, double value) {
        return this;
    }

    @Override
    public final AbstractWritableArray toObject(JSDynamicObject object, long index, Object value) {
        return this;
    }

    @Override
    public ScriptArray deleteElementImpl(JSDynamicObject object, long index, boolean strict) {
        return this.toHoles(object, index, null).deleteElementImpl(object, index, strict);
    }

    @Override
    protected final void moveRangePrepared(JSDynamicObject object, int src, int dst, int len) {
        Object[] array = AbstractObjectArray.getArray(object);
        System.arraycopy(array, src, array, dst, len);
    }

    @Override
    public final Object allocateArray(int length) {
        return new Object[length];
    }

    @Override
    public Object cloneArray(JSDynamicObject object) {
        return AbstractObjectArray.getArray(object).clone();
    }

    @Override
    protected abstract AbstractObjectArray withIntegrityLevel(int var1);

    protected static Object checkNonNull(Object value) {
        assert (value != null);
        return value;
    }

    protected Object castNonNull(Object value) {
        return Objects.requireNonNull(value);
    }
}

