/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn;

import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.HolesDoubleArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.HolesIntArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

final class ArrayCopy {
    private ArrayCopy() {
    }

    static int[] byteToInt(byte[] array) {
        int[] copyArray = new int[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            copyArray[i2] = array[i2];
        }
        return copyArray;
    }

    static double[] byteToDouble(byte[] array) {
        double[] copyArray = new double[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            copyArray[i2] = array[i2];
        }
        return copyArray;
    }

    static Object[] byteToObject(byte[] array) {
        Object[] copyArray = new Object[array.length];
        for (int i2 = 0; i2 < array.length; ++i2) {
            copyArray[i2] = (int)array[i2];
        }
        return copyArray;
    }

    static int[] intToInt(int[] array) {
        return Arrays.copyOf(array, array.length);
    }

    static double[] intToDouble(int[] array) {
        return ArrayCopy.intToDouble(array, 0, array.length);
    }

    static double[] intToDouble(int[] array, int arrayOffset, int usedLength) {
        double[] copyArray = new double[array.length];
        for (int i2 = arrayOffset; i2 < arrayOffset + usedLength; ++i2) {
            copyArray[i2] = array[i2];
        }
        return copyArray;
    }

    static double[] intToDoubleHoles(int[] array, int arrayOffset, int usedLength) {
        double[] copyArray = new double[array.length];
        for (int i2 = arrayOffset; i2 < arrayOffset + usedLength; ++i2) {
            int intValue = array[i2];
            copyArray[i2] = HolesIntArray.isHoleValue(intValue) ? HolesDoubleArray.HOLE_VALUE_DOUBLE : (double)intValue;
        }
        return copyArray;
    }

    static Object[] intToObject(int[] array) {
        return ArrayCopy.intToObject(array, 0, array.length);
    }

    static Object[] intToObject(int[] array, int arrayOffset, int usedLength) {
        Object[] copyArray = new Object[array.length];
        for (int i2 = arrayOffset; i2 < arrayOffset + usedLength; ++i2) {
            copyArray[i2] = array[i2];
        }
        return copyArray;
    }

    static Object[] intToObject(int[] array, int arrayOffset, int usedLength, int newLength) {
        Object[] copyArray = new Object[newLength];
        for (int i2 = arrayOffset; i2 < arrayOffset + usedLength; ++i2) {
            copyArray[i2] = array[i2];
        }
        return copyArray;
    }

    static Object[] intToObjectHoles(int[] array, int arrayOffset, int usedLength) {
        Object[] copyArray = new Object[array.length];
        for (int i2 = arrayOffset; i2 < arrayOffset + usedLength; ++i2) {
            int intValue = array[i2];
            copyArray[i2] = intValue == Integer.MIN_VALUE ? null : Integer.valueOf(intValue);
        }
        return copyArray;
    }

    static double[] doubleToDouble(double[] array) {
        return Arrays.copyOf(array, array.length);
    }

    static Object[] doubleToObject(double[] array) {
        return ArrayCopy.doubleToObject(array, 0, array.length);
    }

    static Object[] doubleToObject(double[] array, int arrayOffset, int usedLength) {
        Object[] copyArray = new Object[array.length];
        for (int i2 = arrayOffset; i2 < arrayOffset + usedLength; ++i2) {
            copyArray[i2] = array[i2];
        }
        return copyArray;
    }

    static Object[] doubleToObjectHoles(double[] array, int arrayOffset, int usedLength) {
        Object[] copyArray = new Object[array.length];
        for (int i2 = arrayOffset; i2 < arrayOffset + usedLength; ++i2) {
            double value = array[i2];
            copyArray[i2] = HolesDoubleArray.isHoleValue(value) ? null : Double.valueOf(value);
        }
        return copyArray;
    }

    static Object[] objectToObject(Object[] array) {
        return ArrayCopy.objectToObject(array, array.length);
    }

    static Object[] objectToObject(Object[] array, int usedLength) {
        Object[] newArray = new Object[usedLength];
        System.arraycopy(array, 0, newArray, 0, usedLength);
        return newArray;
    }

    static Object[] jsobjectToObjectHoles(JSDynamicObject[] array, int arrayOffset, int usedLength) {
        return ArrayCopy.jsobjectToObject(array, arrayOffset, usedLength);
    }

    static Object[] jsobjectToObject(JSDynamicObject[] array, int arrayOffset, int usedLength) {
        Object[] newArray = new Object[array.length];
        System.arraycopy(array, arrayOffset, newArray, arrayOffset, usedLength);
        return newArray;
    }
}

