/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.helper.ListGetNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Boundaries;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSConfig;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.DynamicArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.ScriptArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.AbstractWritableArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;

public class LazyArray
extends AbstractConstantArray {
    private static final LazyArray LAZY_ARRAY = (LazyArray)new LazyArray(0, LazyArray.createCache()).maybePreinitializeCache();

    protected LazyArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    public static LazyArray createLazyArray() {
        return LAZY_ARRAY;
    }

    @Override
    protected DynamicArray withIntegrityLevel(int newIntegrityLevel) {
        return new LazyArray(newIntegrityLevel, this.cache);
    }

    private static List<?> arrayGetLazyList(JSDynamicObject object) {
        return (List)JSAbstractArray.arrayGetArray(object);
    }

    @Override
    public Object getElementInBounds(JSDynamicObject object, int index) {
        return Boundaries.listGet(LazyArray.arrayGetLazyList(object), index);
    }

    public Object getElementInBounds(JSDynamicObject object, int index, ListGetNode listGetNode) {
        return listGetNode.execute(JSAbstractArray.arrayGetArray(object), index);
    }

    @Override
    public boolean hasElement(JSDynamicObject object, long index) {
        return index >= 0L && index < (long)this.lengthInt(object);
    }

    @Override
    public int lengthInt(JSDynamicObject object) {
        return (int)JSAbstractArray.arrayGetLength(object);
    }

    @Override
    public AbstractWritableArray createWriteableObject(JSDynamicObject object, long index, Object value, Node node, ScriptArray.CreateWritableProfileAccess profile) {
        int len = this.lengthInt(object);
        Object[] array = new Object[len];
        for (int i2 = 0; i2 < len; ++i2) {
            array[i2] = this.getElementInBounds(object, i2);
        }
        ZeroBasedObjectArray newArray = ZeroBasedObjectArray.makeZeroBasedObjectArray(object, array.length, array.length, array, this.integrityLevel);
        if (JSConfig.TraceArrayTransitions) {
            LazyArray.traceArrayTransition(this, newArray, index, value);
        }
        return newArray;
    }

    @Override
    public AbstractWritableArray createWriteableDouble(JSDynamicObject object, long index, double value, Node node, ScriptArray.CreateWritableProfileAccess profile) {
        return this.createWriteableObject(object, index, value, node, profile);
    }

    @Override
    public AbstractWritableArray createWriteableInt(JSDynamicObject object, long index, int value, Node node, ScriptArray.CreateWritableProfileAccess profile) {
        return this.createWriteableObject(object, index, value, node, profile);
    }

    @Override
    public AbstractWritableArray createWriteableJSObject(JSDynamicObject object, long index, JSDynamicObject value, Node node, ScriptArray.CreateWritableProfileAccess profile) {
        return this.createWriteableObject(object, index, value, node, profile);
    }

    @Override
    public ScriptArray deleteElementImpl(JSDynamicObject object, long index, boolean strict) {
        return this.createWriteableObject(object, index, null, null, ScriptArray.CreateWritableProfileAccess.getUncached()).deleteElementImpl(object, index, strict);
    }

    @Override
    public ScriptArray setLengthImpl(JSDynamicObject object, long len, Node node, ScriptArray.SetLengthProfileAccess profile) {
        return this.createWriteableObject(object, len - 1L, null, node, profile).setLengthImpl(object, len, node, profile);
    }

    @Override
    public ScriptArray removeRangeImpl(JSDynamicObject object, long start, long end) {
        return this.createWriteableObject(object, start, null, null, ScriptArray.CreateWritableProfileAccess.getUncached()).removeRangeImpl(object, start, end);
    }

    @Override
    public ScriptArray addRangeImpl(JSDynamicObject object, long offset, int size) {
        return this.createWriteableObject(object, offset, null, null, ScriptArray.CreateWritableProfileAccess.getUncached()).addRangeImpl(object, offset, size);
    }

    @Override
    public Object cloneArray(JSDynamicObject object) {
        return LazyArray.arrayGetLazyList(object);
    }
}

