/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.CachedLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSDate;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSNonProxyObject;

@ExportLibrary(value=InteropLibrary.class)
public final class JSDateObject
extends JSNonProxyObject {
    private double value;

    protected JSDateObject(Shape shape, JSDynamicObject proto, double value) {
        super(shape, proto);
        this.value = value;
    }

    public double getTimeMillis() {
        return this.value;
    }

    public void setTimeMillis(double value) {
        this.value = value;
    }

    public static JSDateObject create(Shape shape, JSDynamicObject proto, double value) {
        return new JSDateObject(shape, proto, value);
    }

    @Override
    public TruffleString getClassName() {
        return this.getBuiltinToStringTag();
    }

    @Override
    public TruffleString getBuiltinToStringTag() {
        return JSDate.CLASS_NAME;
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isDate"), @ExportMessage(name="isTime"), @ExportMessage(name="isTimeZone")})
    protected boolean isDate() {
        return JSDate.isValidDate(this);
    }

    @ExportMessage
    public LocalDate asDate(@CachedLibrary(value="this") InteropLibrary self) throws UnsupportedMessageException {
        if (this.isDate()) {
            return JSDate.asLocalDate(this, JSRealm.get(self));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public LocalTime asTime(@CachedLibrary(value="this") InteropLibrary self) throws UnsupportedMessageException {
        if (this.isDate()) {
            return JSDate.asLocalTime(this, JSRealm.get(self));
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public ZoneId asTimeZone(@CachedLibrary(value="this") InteropLibrary self) throws UnsupportedMessageException {
        if (this.isDate()) {
            return JSRealm.get(self).getLocalTimeZoneId();
        }
        throw UnsupportedMessageException.create();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        double time = JSDate.getTimeMillisField(this);
        TruffleString formattedDate = JSDate.isTimeValid(time) ? JSDate.toISOStringIntl(time, JSRealm.get(null)) : JSDate.INVALID_DATE_STRING;
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return Strings.concatAll(Strings.BRACKET_DATE_SPC, formattedDate, Strings.BRACKET_CLOSE);
        }
        return formattedDate;
    }
}

