/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.HiddenKey;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.PromiseFunctionBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.PromisePrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public final class JSPromise
extends JSNonProxy
implements JSConstructorFactory.WithFunctionsAndSpecies,
PrototypeSupplier {
    public static final TruffleString CLASS_NAME = Strings.constant("Promise");
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("Promise.prototype");
    public static final JSPromise INSTANCE = new JSPromise();
    public static final TruffleString RESOLVE = Strings.RESOLVE;
    public static final TruffleString THEN = Strings.THEN;
    public static final HiddenKey PROMISE_ON_FINALLY = new HiddenKey("OnFinally");
    public static final HiddenKey PROMISE_FINALLY_CONSTRUCTOR = new HiddenKey("Constructor");
    public static final int PENDING = 0;
    public static final int FULFILLED = 1;
    public static final int REJECTED = 2;
    public static final int REJECTION_TRACKER_OPERATION_REJECT = 0;
    public static final int REJECTION_TRACKER_OPERATION_HANDLE = 1;
    public static final int REJECTION_TRACKER_OPERATION_REJECT_AFTER_RESOLVED = 2;
    public static final int REJECTION_TRACKER_OPERATION_RESOLVE_AFTER_RESOLVED = 3;

    private JSPromise() {
    }

    public static JSPromiseObject create(JSContext context, JSRealm realm) {
        JSObjectFactory factory = context.getPromiseFactory();
        return JSPromise.create(factory, realm, factory.getPrototype(realm));
    }

    public static JSPromiseObject create(JSContext context, JSRealm realm, JSDynamicObject proto) {
        JSObjectFactory factory = context.getPromiseFactory();
        return JSPromise.create(factory, realm, proto);
    }

    private static JSPromiseObject create(JSObjectFactory factory, JSRealm realm, JSDynamicObject proto) {
        Shape shape = factory.getShape(realm, proto);
        JSPromiseObject newObj = factory.initProto(new JSPromiseObject(shape, proto, 0), realm, proto);
        return factory.trackAllocation(newObj);
    }

    public static JSPromiseObject create(JSContext context, Shape shape, JSDynamicObject proto) {
        JSPromiseObject promise = JSPromiseObject.create(shape, proto, 0);
        return context.trackAllocation(promise);
    }

    public static JSPromiseObject createWithoutPrototype(JSContext context, JSDynamicObject proto) {
        Shape shape = context.getPromiseShapePrototypeInObject();
        JSPromiseObject obj = JSPromiseObject.create(shape, proto, 0);
        return obj;
    }

    @Override
    public Shape makeInitialShape(JSContext context, JSDynamicObject prototype) {
        return JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
    }

    public static boolean isJSPromise(Object obj) {
        return obj instanceof JSPromiseObject;
    }

    public static boolean isRejected(JSPromiseObject promise) {
        return 2 == JSPromise.getPromiseState(promise);
    }

    public static boolean isPending(JSPromiseObject promise) {
        return 0 == JSPromise.getPromiseState(promise);
    }

    public static boolean isFulfilled(JSPromiseObject promise) {
        return 1 == JSPromise.getPromiseState(promise);
    }

    public static int getPromiseState(JSPromiseObject promise) {
        return promise.getPromiseState();
    }

    public static void setPromiseState(JSPromiseObject promise, int promiseState) {
        assert (JSPromise.isPending(promise)) : JSPromise.getStatus(promise);
        promise.setPromiseState(promiseState);
    }

    public static TruffleString getStatus(JSPromiseObject obj) {
        if (JSPromise.isFulfilled(obj)) {
            return Strings.RESOLVED;
        }
        if (JSPromise.isRejected(obj)) {
            return Strings.REJECTED;
        }
        assert (JSPromise.isPending(obj));
        return Strings.PENDING;
    }

    public static Object getPromiseResult(JSPromiseObject obj) {
        return JSRuntime.nullToUndefined(obj.getPromiseResult());
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject constructor) {
        JSObject prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        JSObjectUtil.putConstructorProperty(prototype, constructor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, PromisePrototypeBuiltins.BUILTINS);
        JSObjectUtil.putToStringTag(prototype, CLASS_NAME);
        return prototype;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm, PromiseFunctionBuiltins.BUILTINS);
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getPromisePrototype();
    }
}

