/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins;

import java.util.List;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.dsl.NeverDefault;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.DynamicObjectLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.HiddenKey;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.object.Shape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.Source;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.builtins.RegExpPrototypeBuiltins;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.lang.JavaScriptLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.array.dyn.LazyRegexResultIndicesArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSRegExpGroupsObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSRegExpObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSAttributes;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSShape;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyProxy;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.util.TRegexUtil;

public final class JSRegExp
extends JSNonProxy
implements JSConstructorFactory.Default,
PrototypeSupplier {
    static final TruffleString BRACKET_REG_EXP_SPC = Strings.constant("[RegExp ");
    public static final JSRegExp INSTANCE = new JSRegExp();
    public static final TruffleString CLASS_NAME = Strings.constant("RegExp");
    public static final TruffleString PROTOTYPE_NAME = Strings.concat(CLASS_NAME, Strings.DOT_PROTOTYPE);
    public static final TruffleString MULTILINE = Strings.constant("multiline");
    public static final TruffleString GLOBAL = Strings.GLOBAL;
    public static final TruffleString IGNORE_CASE = Strings.constant("ignoreCase");
    public static final TruffleString STICKY = Strings.constant("sticky");
    public static final TruffleString UNICODE = Strings.constant("unicode");
    public static final TruffleString DOT_ALL = Strings.constant("dotAll");
    public static final TruffleString SOURCE = Strings.SOURCE;
    public static final TruffleString FLAGS = Strings.constant("flags");
    public static final TruffleString LAST_INDEX = Strings.constant("lastIndex");
    public static final TruffleString INPUT = Strings.INPUT;
    public static final TruffleString GROUPS = Strings.constant("groups");
    public static final TruffleString INDEX = Strings.INDEX;
    public static final TruffleString INDICES = Strings.constant("indices");
    public static final TruffleString HAS_INDICES = Strings.constant("hasIndices");
    public static final TruffleString UNICODE_SETS = Strings.constant("unicodeSets");
    public static final TruffleString EMPTY_REGEX = Strings.constant("(?:)");
    public static final TruffleString LAST_MATCH = Strings.constant("lastMatch");
    public static final TruffleString LAST_PAREN = Strings.constant("lastParen");
    public static final TruffleString LEFT_CONTEXT = Strings.constant("leftContext");
    public static final TruffleString RIGHT_CONTEXT = Strings.constant("rightContext");
    public static final TruffleString $_ = Strings.constant("$_");
    public static final TruffleString $_AMPERSAND = Strings.constant("$&");
    public static final TruffleString $_PLUS = Strings.constant("$+");
    public static final TruffleString $_BACKTICK = Strings.constant("$`");
    public static final TruffleString $_SQUOT = Strings.constant("$'");
    public static final TruffleString $_1 = Strings.constant("$1");
    public static final TruffleString $_2 = Strings.constant("$2");
    public static final TruffleString $_3 = Strings.constant("$3");
    public static final TruffleString $_4 = Strings.constant("$4");
    public static final TruffleString $_5 = Strings.constant("$5");
    public static final TruffleString $_6 = Strings.constant("$6");
    public static final TruffleString $_7 = Strings.constant("$7");
    public static final TruffleString $_8 = Strings.constant("$8");
    public static final TruffleString $_9 = Strings.constant("$9");
    public static final PropertyProxy LAZY_INDEX_PROXY = new LazyRegexResultIndexProxyProperty();
    public static final HiddenKey GROUPS_RESULT_ID = new HiddenKey("regexResult");
    public static final int MAX_FLAGS_LENGTH = 8;

    private JSRegExp() {
    }

    @NeverDefault
    public static Object getCompiledRegex(JSDynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return ((JSRegExpObject)thisObj).getCompiledRegex();
    }

    public static JSObjectFactory getGroupsFactory(JSDynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return ((JSRegExpObject)thisObj).getGroupsFactory();
    }

    public static Object getRealm(JSDynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return ((JSRegExpObject)thisObj).getRealm();
    }

    public static boolean getLegacyFeaturesEnabled(JSDynamicObject thisObj) {
        assert (JSRegExp.isJSRegExp(thisObj));
        return ((JSRegExpObject)thisObj).getLegacyFeaturesEnabled();
    }

    public static JSRegExpObject create(JSContext ctx, JSRealm realm, Object compiledRegex) {
        JSObjectFactory groupsFactory = JSRegExp.computeGroupsFactory(ctx, compiledRegex);
        JSRegExpObject obj = JSRegExp.create(ctx, realm, compiledRegex, groupsFactory);
        JSObjectUtil.putDataProperty(obj, LAST_INDEX, 0, JSAttributes.notConfigurableNotEnumerableWritable());
        return obj;
    }

    public static JSRegExpObject create(JSContext context, JSRealm realm, JSDynamicObject proto, Object compiledRegex, JSObjectFactory groupsFactory) {
        return JSRegExp.create(context, realm, proto, compiledRegex, groupsFactory, true);
    }

    public static JSRegExpObject create(JSContext context, JSRealm realm, Object compiledRegex, JSObjectFactory groupsFactory) {
        return JSRegExp.create(context, realm, compiledRegex, groupsFactory, true);
    }

    public static JSRegExpObject create(JSContext context, JSRealm realm, JSDynamicObject proto, Object compiledRegex, JSObjectFactory groupsFactory, boolean legacyFeaturesEnabled) {
        JSObjectFactory factory = context.getRegExpFactory();
        return JSRegExp.create(factory, realm, proto, compiledRegex, groupsFactory, legacyFeaturesEnabled);
    }

    public static JSRegExpObject create(JSContext context, JSRealm realm, Object compiledRegex, JSObjectFactory groupsFactory, boolean legacyFeaturesEnabled) {
        JSObjectFactory factory = context.getRegExpFactory();
        return JSRegExp.create(factory, realm, factory.getPrototype(realm), compiledRegex, groupsFactory, legacyFeaturesEnabled);
    }

    private static JSRegExpObject create(JSObjectFactory factory, JSRealm realm, JSDynamicObject proto, Object compiledRegex, JSObjectFactory groupsFactory, boolean legacyFeaturesEnabled) {
        Shape shape = factory.getShape(realm, proto);
        JSRegExpObject newObj = factory.initProto(new JSRegExpObject(shape, proto, compiledRegex, groupsFactory, realm, legacyFeaturesEnabled), realm, proto);
        return factory.trackAllocation(newObj);
    }

    private static void initialize(JSContext ctx, JSDynamicObject regExp, Object regex) {
        ((JSRegExpObject)regExp).setCompiledRegex(regex);
        ((JSRegExpObject)regExp).setGroupsFactory(JSRegExp.computeGroupsFactory(ctx, regex));
    }

    public static void updateCompilation(JSContext ctx, JSDynamicObject thisObj, Object regex) {
        assert (JSRegExp.isJSRegExp(thisObj) && regex != null);
        JSRegExp.initialize(ctx, thisObj, regex);
    }

    public static JSDynamicObject createGroupsObject(JSRealm realm, JSObjectFactory groupsFactory, Object regexResult, TruffleString input, boolean isIndices) {
        JSDynamicObject proto = groupsFactory.getPrototype(realm);
        Shape shape = groupsFactory.getShape(realm, proto);
        JSRegExpGroupsObject newObj = groupsFactory.initProto(new JSRegExpGroupsObject(shape, proto, regexResult, input, isIndices), realm, proto);
        return groupsFactory.trackAllocation(newObj);
    }

    @CompilerDirectives.TruffleBoundary
    private static JSObjectFactory computeGroupsFactory(JSContext ctx, Object compiledRegex) {
        Object namedCaptureGroups = TRegexUtil.InteropReadMemberNode.getUncached().execute(null, compiledRegex, "groups");
        if (InteropLibrary.getUncached().isNull(namedCaptureGroups)) {
            return null;
        }
        return JSRegExp.buildGroupsFactory(ctx, namedCaptureGroups);
    }

    @CompilerDirectives.TruffleBoundary
    public static JSObjectFactory buildGroupsFactory(JSContext ctx, Object namedCaptureGroups) {
        try {
            Shape groupsShape = ctx.getRegExpGroupsEmptyShape();
            Shape.DerivedBuilder builder = Shape.newBuilder(groupsShape);
            List<Object> keys = JSInteropUtil.keys(namedCaptureGroups);
            int firstIndexOfLastGroup = 0;
            for (Object key : keys) {
                int[] groupIndices = TRegexUtil.InteropReadIntArrayMemberNode.getUncached().execute(null, namedCaptureGroups, InteropLibrary.getUncached().asString(key));
                assert (groupIndices[0] > firstIndexOfLastGroup);
                firstIndexOfLastGroup = groupIndices[0];
                TruffleString groupName = Strings.interopAsTruffleString(key);
                builder.addConstantProperty(groupName, new LazyNamedCaptureGroupProperty(groupName, groupIndices), JSAttributes.getDefault() | 0x10);
            }
            groupsShape = builder.build();
            return JSObjectFactory.createBound(ctx, Null.instance, groupsShape);
        }
        catch (UnsupportedMessageException e2) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString prototypeToString(JSDynamicObject thisObj) {
        Object regex = JSRegExp.getCompiledRegex(thisObj);
        TRegexUtil.InteropReadStringMemberNode readString = TRegexUtil.InteropReadStringMemberNode.getUncached();
        TruffleString pattern = readString.execute(null, regex, "pattern");
        if (Strings.length(pattern) == 0) {
            pattern = EMPTY_REGEX;
        }
        Object regexFlags = TRegexUtil.InteropReadMemberNode.getUncached().execute(null, regex, "flags");
        TruffleString flags = readString.execute(null, regexFlags, "source");
        return Strings.concatAll(Strings.SLASH, pattern, Strings.SLASH, flags);
    }

    public static boolean isJSRegExp(Object obj) {
        return obj instanceof JSRegExpObject;
    }

    @Override
    public JSDynamicObject createPrototype(JSRealm realm, JSFunctionObject ctor) {
        JSObject prototype;
        JSContext ctx = realm.getContext();
        if (ctx.getEcmaScriptVersion() < 6) {
            Shape shape = JSShape.createPrototypeShape(realm.getContext(), INSTANCE, realm.getObjectPrototype());
            prototype = JSRegExpObject.create(shape, realm.getObjectPrototype(), JSRegExp.es5GetEmptyRegexEarly(realm), realm);
            JSObjectUtil.setOrVerifyPrototype(ctx, prototype, realm.getObjectPrototype());
            JSObjectUtil.putDataProperty(prototype, LAST_INDEX, 0, JSAttributes.notConfigurableNotEnumerableWritable());
        } else {
            prototype = JSObjectUtil.createOrdinaryPrototypeObject(realm);
        }
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, SOURCE);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, FLAGS);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, MULTILINE);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, GLOBAL);
        JSRegExp.putRegExpPropertyAccessor(realm, prototype, IGNORE_CASE);
        if (ctx.getEcmaScriptVersion() >= 6) {
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, STICKY);
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, UNICODE);
        }
        if (ctx.getEcmaScriptVersion() >= 9) {
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, DOT_ALL);
        }
        if (ctx.isOptionRegexpMatchIndices()) {
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, HAS_INDICES);
        }
        if (ctx.isOptionRegexpUnicodeSets()) {
            JSRegExp.putRegExpPropertyAccessor(realm, prototype, UNICODE_SETS);
        }
        JSObjectUtil.putConstructorProperty(prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, RegExpPrototypeBuiltins.BUILTINS);
        return prototype;
    }

    private static void putRegExpPropertyAccessor(JSRealm realm, JSDynamicObject prototype, TruffleString name) {
        JSObjectUtil.putBuiltinAccessorProperty(prototype, name, realm.lookupAccessor(RegExpPrototypeBuiltins.BUILTINS, name));
    }

    private static Object es5GetEmptyRegexEarly(JSRealm realm) {
        return realm.getEnv().parseInternal(Source.newBuilder("regex", "//", "//").mimeType("application/tregex").internal(true).build(), new String[0]).call(new Object[0]);
    }

    @Override
    public Shape makeInitialShape(JSContext ctx, JSDynamicObject thisObj) {
        return JSObjectUtil.getProtoChildShape(thisObj, INSTANCE, ctx);
    }

    public static Shape makeInitialGroupsObjectShape(JSContext context) {
        CompilerAsserts.neverPartOfCompilation();
        return JSShape.createRootWithNullProto(context, JSOrdinary.BARE_INSTANCE);
    }

    @Override
    public void fillConstructor(JSRealm realm, JSDynamicObject constructor) {
        JSRegExp.putConstructorSpeciesGetter(realm, constructor);
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public TruffleString getClassName() {
        return CLASS_NAME;
    }

    @Override
    public JSDynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getRegExpPrototype();
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleString escapeRegExpPattern(TruffleString pattern) {
        if (Strings.length(pattern) == 0) {
            return EMPTY_REGEX;
        }
        int extraChars = JSRegExp.escapeRegExpExtraCharCount(pattern);
        if (extraChars == 0) {
            return pattern;
        }
        return JSRegExp.escapeRegExpPattern(pattern, extraChars);
    }

    private static int escapeRegExpExtraCharCount(TruffleString pattern) {
        int extraChars = 0;
        boolean insideCharClass = false;
        block12: for (int i2 = 0; i2 < Strings.length(pattern); ++i2) {
            switch (Strings.charAt(pattern, i2)) {
                case '\\': {
                    assert (i2 + 1 < Strings.length(pattern));
                    switch (Strings.charAt(pattern, ++i2)) {
                        case '\n': 
                        case '\r': {
                            extraChars = Math.max(extraChars, 1);
                            break;
                        }
                        case '\u2028': 
                        case '\u2029': {
                            extraChars += 4;
                        }
                    }
                    continue block12;
                }
                case '\n': 
                case '\r': {
                    ++extraChars;
                    continue block12;
                }
                case '\u2028': 
                case '\u2029': {
                    extraChars += 5;
                    continue block12;
                }
                case '/': {
                    if (insideCharClass) continue block12;
                    ++extraChars;
                    continue block12;
                }
                case '[': {
                    insideCharClass = true;
                    continue block12;
                }
                case ']': {
                    insideCharClass = false;
                }
            }
        }
        return extraChars;
    }

    @CompilerDirectives.TruffleBoundary
    private static TruffleString escapeRegExpPattern(TruffleString pattern, int extraChars) {
        StringBuilder sb = new StringBuilder(Strings.length(pattern) + extraChars);
        boolean insideCharClass = false;
        block16: for (int i2 = 0; i2 < Strings.length(pattern); ++i2) {
            char c2 = Strings.charAt(pattern, i2);
            switch (c2) {
                case '\\': {
                    assert (i2 + 1 < Strings.length(pattern));
                    sb.append(c2);
                    c2 = Strings.charAt(pattern, ++i2);
                    switch (c2) {
                        case '\n': {
                            sb.append('n');
                            continue block16;
                        }
                        case '\r': {
                            sb.append('r');
                            continue block16;
                        }
                        case '\u2028': {
                            sb.append("u2028");
                            continue block16;
                        }
                        case '\u2029': {
                            sb.append("u2029");
                            continue block16;
                        }
                    }
                    sb.append(c2);
                    continue block16;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block16;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block16;
                }
                case '\u2028': {
                    sb.append("\\u2028");
                    continue block16;
                }
                case '\u2029': {
                    sb.append("\\u2029");
                    continue block16;
                }
                case '/': {
                    if (!insideCharClass) {
                        sb.append("\\/");
                        continue block16;
                    }
                    sb.append('/');
                    continue block16;
                }
                case '[': {
                    insideCharClass = true;
                    sb.append(c2);
                    continue block16;
                }
                case ']': {
                    insideCharClass = false;
                    sb.append(c2);
                    continue block16;
                }
                default: {
                    sb.append(c2);
                }
            }
        }
        return Strings.fromJavaString(sb.toString());
    }

    public static final class LazyNamedCaptureGroupProperty
    extends PropertyProxy {
        private final int[] groupIndices;
        private final TruffleString groupName;

        public LazyNamedCaptureGroupProperty(TruffleString groupName, int[] groupIndices) {
            this.groupIndices = groupIndices;
            this.groupName = groupName;
        }

        public int[] getGroupIndices() {
            return this.groupIndices;
        }

        @Override
        public Object get(JSDynamicObject object) {
            JSRegExpGroupsObject groups = (JSRegExpGroupsObject)object;
            Object regexResult = groups.getRegexResult();
            if (groups.isIndices()) {
                return LazyRegexResultIndicesArray.getIntIndicesArray(JavaScriptLanguage.getCurrentLanguage().getJSContext(), regexResult, this.groupIndices, null, TRegexUtil.InvokeGetGroupBoundariesMethodNode.getUncached(), TRegexUtil.InvokeGetGroupBoundariesMethodNode.getUncached());
            }
            TruffleString input = groups.getInputString();
            return TRegexUtil.TRegexMaterializeResult.materializeGroupUncached(regexResult, this.groupIndices, input);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean set(JSDynamicObject object, Object value) {
            JSObjectUtil.defineDataProperty(object, this.groupName, value, JSAttributes.getDefault());
            return true;
        }
    }

    public static final class LazyRegexResultIndexProxyProperty
    extends PropertyProxy {
        @Override
        public Object get(JSDynamicObject object) {
            Object regexResult = JSAbstractArray.arrayGetRegexResult(object, DynamicObjectLibrary.getUncached());
            return TRegexUtil.InvokeGetGroupBoundariesMethodNode.getUncached().execute(null, regexResult, "getStart", 0);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean set(JSDynamicObject object, Object value) {
            JSObjectUtil.defineDataProperty(object, INDEX, value, JSAttributes.getDefault());
            return true;
        }
    }
}

