/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.doubleconv;

public final class Bignum {
    static final int kMaxSignificantBits = 3584;
    static final int kChunkSize = 32;
    static final int kDoubleChunkSize = 64;
    static final int kBigitSize = 28;
    static final int kBigitMask = 0xFFFFFFF;
    static final int kBigitCapacity = 128;
    private int used_bigits_;
    private int exponent_;
    private final int[] bigits_ = new int[128];

    void times10() {
        this.multiplyByUInt32(10);
    }

    static boolean equal(Bignum a2, Bignum b2) {
        return Bignum.compare(a2, b2) == 0;
    }

    static boolean lessEqual(Bignum a2, Bignum b2) {
        return Bignum.compare(a2, b2) <= 0;
    }

    static boolean less(Bignum a2, Bignum b2) {
        return Bignum.compare(a2, b2) < 0;
    }

    static boolean plusEqual(Bignum a2, Bignum b2, Bignum c2) {
        return Bignum.plusCompare(a2, b2, c2) == 0;
    }

    static boolean plusLessEqual(Bignum a2, Bignum b2, Bignum c2) {
        return Bignum.plusCompare(a2, b2, c2) <= 0;
    }

    static boolean plusLess(Bignum a2, Bignum b2, Bignum c2) {
        return Bignum.plusCompare(a2, b2, c2) < 0;
    }

    private void ensureCapacity(int size) {
        if (size > 128) {
            throw new RuntimeException();
        }
    }

    int bigitLength() {
        return this.used_bigits_ + this.exponent_;
    }

    void assignUInt16(char value) {
        this.zero();
        if (value > '\u0000') {
            this.bigits_[0] = value;
            this.used_bigits_ = 1;
        }
    }

    void assignUInt64(long value) {
        int kUInt64Size = 64;
        this.zero();
        int i2 = 0;
        while (value > 0L) {
            this.bigits_[i2] = (int)(value & 0xFFFFFFFL);
            value >>>= 28;
            ++this.used_bigits_;
            ++i2;
        }
    }

    void assignBignum(Bignum other) {
        assert (this.isClamped());
        assert (other.isClamped());
        this.exponent_ = other.exponent_;
        for (int i2 = 0; i2 < other.used_bigits_; ++i2) {
            this.bigits_[i2] = other.bigits_[i2];
        }
        this.used_bigits_ = other.used_bigits_;
    }

    static long readUInt64(String str, int from, int digits_to_read) {
        long result = 0L;
        for (int i2 = from; i2 < from + digits_to_read; ++i2) {
            int digit = str.charAt(i2) - 48;
            assert (0 <= digit && digit <= 9);
            result = result * 10L + (long)digit;
        }
        return result;
    }

    public void assignDecimalString(String str) {
        long digits;
        int length;
        int kMaxUint64DecimalDigits = 19;
        this.zero();
        int pos = 0;
        for (length = str.length(); length >= 19; length -= 19) {
            digits = Bignum.readUInt64(str, pos, 19);
            pos += 19;
            this.multiplyByPowerOfTen(19);
            this.addUInt64(digits);
        }
        digits = Bignum.readUInt64(str, pos, length);
        this.multiplyByPowerOfTen(length);
        this.addUInt64(digits);
        this.clamp();
    }

    static int hexCharValue(char c2) {
        if ('0' <= c2 && c2 <= '9') {
            return c2 - 48;
        }
        if ('a' <= c2 && c2 <= 'f') {
            return 10 + c2 - 97;
        }
        assert ('A' <= c2 && c2 <= 'F');
        return 10 + c2 - 65;
    }

    public void assignHexString(String value) {
        this.zero();
        int length = value.length();
        this.ensureCapacity((value.length() * 4 + 28 - 1) / 28);
        long tmp = 0L;
        int cnt = 0;
        for (int value_pos = value.length() - 1; value_pos >= 0; --value_pos) {
            tmp |= (long)Bignum.hexCharValue(value.charAt(value_pos)) << cnt;
            if ((cnt += 4) < 28) continue;
            this.bigits_[this.used_bigits_++] = (int)(tmp & 0xFFFFFFFL);
            cnt -= 28;
            tmp >>>= 28;
        }
        if (tmp != 0L) {
            this.bigits_[this.used_bigits_++] = (int)(tmp & 0xFFFFFFFL);
        }
        this.clamp();
    }

    void addUInt64(long operand) {
        if (operand == 0L) {
            return;
        }
        Bignum other = new Bignum();
        other.assignUInt64(operand);
        this.addBignum(other);
    }

    void addBignum(Bignum other) {
        int i2;
        assert (this.isClamped());
        assert (other.isClamped());
        this.align(other);
        this.ensureCapacity(1 + Math.max(this.bigitLength(), other.bigitLength()) - this.exponent_);
        int carry = 0;
        int bigit_pos = other.exponent_ - this.exponent_;
        assert (bigit_pos >= 0);
        for (i2 = this.used_bigits_; i2 < bigit_pos; ++i2) {
            this.bigits_[i2] = 0;
        }
        for (i2 = 0; i2 < other.used_bigits_; ++i2) {
            int my = bigit_pos < this.used_bigits_ ? this.bigits_[bigit_pos] : 0;
            int sum = my + other.bigits_[i2] + carry;
            this.bigits_[bigit_pos] = sum & 0xFFFFFFF;
            carry = sum >>> 28;
            ++bigit_pos;
        }
        while (carry != 0) {
            int my = bigit_pos < this.used_bigits_ ? this.bigits_[bigit_pos] : 0;
            int sum = my + carry;
            this.bigits_[bigit_pos] = sum & 0xFFFFFFF;
            carry = sum >>> 28;
            ++bigit_pos;
        }
        this.used_bigits_ = Math.max(bigit_pos, this.used_bigits_);
        assert (this.isClamped());
    }

    void subtractBignum(Bignum other) {
        int difference;
        int i2;
        assert (this.isClamped());
        assert (other.isClamped());
        assert (Bignum.lessEqual(other, this));
        this.align(other);
        int offset = other.exponent_ - this.exponent_;
        int borrow = 0;
        for (i2 = 0; i2 < other.used_bigits_; ++i2) {
            assert (borrow == 0 || borrow == 1);
            difference = this.bigits_[i2 + offset] - other.bigits_[i2] - borrow;
            this.bigits_[i2 + offset] = difference & 0xFFFFFFF;
            borrow = difference >>> 31;
        }
        while (borrow != 0) {
            difference = this.bigits_[i2 + offset] - borrow;
            this.bigits_[i2 + offset] = difference & 0xFFFFFFF;
            borrow = difference >>> 31;
            ++i2;
        }
        this.clamp();
    }

    void shiftLeft(int shift_amount) {
        if (this.used_bigits_ == 0) {
            return;
        }
        this.exponent_ += shift_amount / 28;
        int local_shift = shift_amount % 28;
        this.ensureCapacity(this.used_bigits_ + 1);
        this.bigitsShiftLeft(local_shift);
    }

    void multiplyByUInt32(int factor) {
        if (factor == 1) {
            return;
        }
        if (factor == 0) {
            this.zero();
            return;
        }
        if (this.used_bigits_ == 0) {
            return;
        }
        long carry = 0L;
        for (int i2 = 0; i2 < this.used_bigits_; ++i2) {
            long product = ((long)factor & 0xFFFFFFFFL) * (long)this.bigits_[i2] + carry;
            this.bigits_[i2] = (int)(product & 0xFFFFFFFL);
            carry = product >>> 28;
        }
        while (carry != 0L) {
            this.ensureCapacity(this.used_bigits_ + 1);
            this.bigits_[this.used_bigits_] = (int)(carry & 0xFFFFFFFL);
            ++this.used_bigits_;
            carry >>>= 28;
        }
    }

    void multiplyByUInt64(long factor) {
        if (factor == 1L) {
            return;
        }
        if (factor == 0L) {
            this.zero();
            return;
        }
        if (this.used_bigits_ == 0) {
            return;
        }
        long carry = 0L;
        long low = factor & 0xFFFFFFFFL;
        long high = factor >>> 32;
        for (int i2 = 0; i2 < this.used_bigits_; ++i2) {
            long product_low = low * (long)this.bigits_[i2];
            long product_high = high * (long)this.bigits_[i2];
            long tmp = (carry & 0xFFFFFFFL) + product_low;
            this.bigits_[i2] = (int)(tmp & 0xFFFFFFFL);
            carry = (carry >>> 28) + (tmp >>> 28) + (product_high << 4);
        }
        while (carry != 0L) {
            this.ensureCapacity(this.used_bigits_ + 1);
            this.bigits_[this.used_bigits_] = (int)(carry & 0xFFFFFFFL);
            ++this.used_bigits_;
            carry >>>= 28;
        }
    }

    void multiplyByPowerOfTen(int exponent) {
        int remaining_exponent;
        long kFive27 = 7450580596923828125L;
        int kFive1 = 5;
        int kFive2 = 25;
        int kFive3 = 125;
        int kFive4 = 625;
        int kFive5 = 3125;
        int kFive6 = 15625;
        int kFive7 = 78125;
        int kFive8 = 390625;
        int kFive9 = 1953125;
        int kFive10 = 9765625;
        int kFive11 = 48828125;
        int kFive12 = 244140625;
        int kFive13 = 1220703125;
        int[] kFive1_to_12 = new int[]{5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625};
        assert (exponent >= 0);
        if (exponent == 0) {
            return;
        }
        if (this.used_bigits_ == 0) {
            return;
        }
        for (remaining_exponent = exponent; remaining_exponent >= 27; remaining_exponent -= 27) {
            this.multiplyByUInt64(7450580596923828125L);
        }
        while (remaining_exponent >= 13) {
            this.multiplyByUInt32(1220703125);
            remaining_exponent -= 13;
        }
        if (remaining_exponent > 0) {
            this.multiplyByUInt32(kFive1_to_12[remaining_exponent - 1]);
        }
        this.shiftLeft(exponent);
    }

    void square() {
        int int2;
        int int1;
        int bigit_index2;
        int bigit_index1;
        int i2;
        assert (this.isClamped());
        int product_length = 2 * this.used_bigits_;
        this.ensureCapacity(product_length);
        if (256L <= (long)this.used_bigits_) {
            throw new RuntimeException("unimplemented");
        }
        long accumulator = 0L;
        int copy_offset = this.used_bigits_;
        for (i2 = 0; i2 < this.used_bigits_; ++i2) {
            this.bigits_[copy_offset + i2] = this.bigits_[i2];
        }
        for (i2 = 0; i2 < this.used_bigits_; ++i2) {
            bigit_index1 = i2;
            bigit_index2 = 0;
            while (bigit_index1 >= 0) {
                int1 = this.bigits_[copy_offset + bigit_index1];
                int2 = this.bigits_[copy_offset + bigit_index2];
                accumulator += (long)int1 * (long)int2;
                --bigit_index1;
                ++bigit_index2;
            }
            this.bigits_[i2] = (int)(accumulator & 0xFFFFFFFL);
            accumulator >>>= 28;
        }
        for (i2 = this.used_bigits_; i2 < product_length; ++i2) {
            bigit_index1 = this.used_bigits_ - 1;
            for (bigit_index2 = i2 - bigit_index1; bigit_index2 < this.used_bigits_; ++bigit_index2) {
                int1 = this.bigits_[copy_offset + bigit_index1];
                int2 = this.bigits_[copy_offset + bigit_index2];
                accumulator += (long)int1 * (long)int2;
                --bigit_index1;
            }
            this.bigits_[i2] = (int)(accumulator & 0xFFFFFFFL);
            accumulator >>>= 28;
        }
        assert (accumulator == 0L);
        this.used_bigits_ = product_length;
        this.exponent_ *= 2;
        this.clamp();
    }

    void assignPowerUInt16(int base, int power_exponent) {
        int mask;
        assert (base != 0);
        assert (power_exponent >= 0);
        if (power_exponent == 0) {
            this.assignUInt16('\u0001');
            return;
        }
        this.zero();
        int shifts = 0;
        while ((base & 1) == 0) {
            base >>>= 1;
            ++shifts;
        }
        int bit_size = 0;
        int tmp_base = base;
        while (tmp_base != 0) {
            tmp_base >>>= 1;
            ++bit_size;
        }
        int final_size = bit_size * power_exponent;
        this.ensureCapacity(final_size / 28 + 2);
        for (mask = 1; power_exponent >= mask; mask <<= 1) {
        }
        mask >>>= 2;
        long this_value = base;
        boolean delayed_multiplication = false;
        long max_32bits = 0xFFFFFFFFL;
        while (mask != 0 && this_value <= 0xFFFFFFFFL) {
            this_value *= this_value;
            if ((power_exponent & mask) != 0) {
                boolean high_bits_zero;
                assert (bit_size > 0);
                long base_bits_mask = (1L << 64 - bit_size) - 1L ^ 0xFFFFFFFFFFFFFFFFL;
                boolean bl = high_bits_zero = (this_value & base_bits_mask) == 0L;
                if (high_bits_zero) {
                    this_value *= (long)base;
                } else {
                    delayed_multiplication = true;
                }
            }
            mask >>>= 1;
        }
        this.assignUInt64(this_value);
        if (delayed_multiplication) {
            this.multiplyByUInt32(base);
        }
        while (mask != 0) {
            this.square();
            if ((power_exponent & mask) != 0) {
                this.multiplyByUInt32(base);
            }
            mask >>>= 1;
        }
        this.shiftLeft(shifts * power_exponent);
    }

    char divideModuloIntBignum(Bignum other) {
        assert (this.isClamped());
        assert (other.isClamped());
        assert (other.used_bigits_ > 0);
        if (this.bigitLength() < other.bigitLength()) {
            return '\u0000';
        }
        this.align(other);
        char result = '\u0000';
        while (this.bigitLength() > other.bigitLength()) {
            assert (other.bigits_[other.used_bigits_ - 1] >= 0x1000000);
            assert (this.bigits_[this.used_bigits_ - 1] < 65536);
            result = (char)(result + (char)this.bigits_[this.used_bigits_ - 1]);
            this.subtractTimes(other, this.bigits_[this.used_bigits_ - 1]);
        }
        assert (this.bigitLength() == other.bigitLength());
        int this_bigit = this.bigits_[this.used_bigits_ - 1];
        int other_bigit = other.bigits_[other.used_bigits_ - 1];
        if (other.used_bigits_ == 1) {
            int quotient = Integer.divideUnsigned(this_bigit, other_bigit);
            this.bigits_[this.used_bigits_ - 1] = this_bigit - other_bigit * quotient;
            assert (Integer.compareUnsigned(quotient, 65536) < 0);
            result = (char)(result + (char)quotient);
            this.clamp();
            return result;
        }
        int division_estimate = Integer.divideUnsigned(this_bigit, other_bigit + 1);
        assert (Integer.compareUnsigned(division_estimate, 65536) < 0);
        result = (char)(result + (char)division_estimate);
        this.subtractTimes(other, division_estimate);
        if (other_bigit * (division_estimate + 1) > this_bigit) {
            return result;
        }
        while (Bignum.lessEqual(other, this)) {
            this.subtractBignum(other);
            result = (char)(result + '\u0001');
        }
        return result;
    }

    static int sizeInHexChars(int number) {
        assert (number > 0);
        int result = 0;
        while (number != 0) {
            number >>>= 4;
            ++result;
        }
        return result;
    }

    static char hexCharOfValue(int value) {
        assert (0 <= value && value <= 16);
        if (value < 10) {
            return (char)(value + 48);
        }
        return (char)(value - 10 + 65);
    }

    public String toHexString() {
        int i2;
        assert (this.isClamped());
        int kHexCharsPerBigit = 7;
        if (this.used_bigits_ == 0) {
            return "0";
        }
        int needed_chars = (this.bigitLength() - 1) * 7 + Bignum.sizeInHexChars(this.bigits_[this.used_bigits_ - 1]);
        StringBuilder buffer = new StringBuilder(needed_chars);
        buffer.setLength(needed_chars);
        int string_index = needed_chars - 1;
        for (i2 = 0; i2 < this.exponent_; ++i2) {
            for (int j2 = 0; j2 < 7; ++j2) {
                buffer.setCharAt(string_index--, '0');
            }
        }
        for (i2 = 0; i2 < this.used_bigits_ - 1; ++i2) {
            int current_bigit = this.bigits_[i2];
            for (int j3 = 0; j3 < 7; ++j3) {
                buffer.setCharAt(string_index--, Bignum.hexCharOfValue(current_bigit & 0xF));
                current_bigit >>>= 4;
            }
        }
        for (int most_significant_bigit = this.bigits_[this.used_bigits_ - 1]; most_significant_bigit != 0; most_significant_bigit >>>= 4) {
            buffer.setCharAt(string_index--, Bignum.hexCharOfValue(most_significant_bigit & 0xF));
        }
        return buffer.toString();
    }

    int bigitOrZero(int index) {
        if (index >= this.bigitLength()) {
            return 0;
        }
        if (index < this.exponent_) {
            return 0;
        }
        return this.bigits_[index - this.exponent_];
    }

    static int compare(Bignum a2, Bignum b2) {
        int bigit_length_b;
        assert (a2.isClamped());
        assert (b2.isClamped());
        int bigit_length_a = a2.bigitLength();
        if (bigit_length_a < (bigit_length_b = b2.bigitLength())) {
            return -1;
        }
        if (bigit_length_a > bigit_length_b) {
            return 1;
        }
        for (int i2 = bigit_length_a - 1; i2 >= Math.min(a2.exponent_, b2.exponent_); --i2) {
            int bigit_b;
            int bigit_a = a2.bigitOrZero(i2);
            if (bigit_a < (bigit_b = b2.bigitOrZero(i2))) {
                return -1;
            }
            if (bigit_a <= bigit_b) continue;
            return 1;
        }
        return 0;
    }

    static int plusCompare(Bignum a2, Bignum b2, Bignum c2) {
        assert (a2.isClamped());
        assert (b2.isClamped());
        assert (c2.isClamped());
        if (a2.bigitLength() < b2.bigitLength()) {
            return Bignum.plusCompare(b2, a2, c2);
        }
        if (a2.bigitLength() + 1 < c2.bigitLength()) {
            return -1;
        }
        if (a2.bigitLength() > c2.bigitLength()) {
            return 1;
        }
        if (a2.exponent_ >= b2.bigitLength() && a2.bigitLength() < c2.bigitLength()) {
            return -1;
        }
        int borrow = 0;
        int min_exponent = Math.min(Math.min(a2.exponent_, b2.exponent_), c2.exponent_);
        for (int i2 = c2.bigitLength() - 1; i2 >= min_exponent; --i2) {
            int chunk_c;
            int chunk_b;
            int chunk_a = a2.bigitOrZero(i2);
            int sum = chunk_a + (chunk_b = b2.bigitOrZero(i2));
            if (sum > (chunk_c = c2.bigitOrZero(i2)) + borrow) {
                return 1;
            }
            if ((borrow = chunk_c + borrow - sum) > 1) {
                return -1;
            }
            borrow <<= 28;
        }
        if (borrow == 0) {
            return 0;
        }
        return -1;
    }

    void clamp() {
        while (this.used_bigits_ > 0 && this.bigits_[this.used_bigits_ - 1] == 0) {
            --this.used_bigits_;
        }
        if (this.used_bigits_ == 0) {
            this.exponent_ = 0;
        }
    }

    boolean isClamped() {
        return this.used_bigits_ == 0 || this.bigits_[this.used_bigits_ - 1] != 0;
    }

    void zero() {
        this.used_bigits_ = 0;
        this.exponent_ = 0;
    }

    void align(Bignum other) {
        if (this.exponent_ > other.exponent_) {
            int i2;
            int zero_bigits = this.exponent_ - other.exponent_;
            this.ensureCapacity(this.used_bigits_ + zero_bigits);
            for (i2 = this.used_bigits_ - 1; i2 >= 0; --i2) {
                this.bigits_[i2 + zero_bigits] = this.bigits_[i2];
            }
            for (i2 = 0; i2 < zero_bigits; ++i2) {
                this.bigits_[i2] = 0;
            }
            this.used_bigits_ += zero_bigits;
            this.exponent_ -= zero_bigits;
            assert (this.used_bigits_ >= 0);
            assert (this.exponent_ >= 0);
        }
    }

    void bigitsShiftLeft(int shift_amount) {
        assert (shift_amount < 28);
        assert (shift_amount >= 0);
        int carry = 0;
        for (int i2 = 0; i2 < this.used_bigits_; ++i2) {
            int new_carry = this.bigits_[i2] >>> 28 - shift_amount;
            this.bigits_[i2] = (this.bigits_[i2] << shift_amount) + carry & 0xFFFFFFF;
            carry = new_carry;
        }
        if (carry != 0) {
            this.bigits_[this.used_bigits_] = carry;
            ++this.used_bigits_;
        }
    }

    void subtractTimes(Bignum other, int factor) {
        int i2;
        assert (this.exponent_ <= other.exponent_);
        if (factor < 3) {
            for (int i3 = 0; i3 < factor; ++i3) {
                this.subtractBignum(other);
            }
            return;
        }
        int borrow = 0;
        int exponent_diff = other.exponent_ - this.exponent_;
        for (i2 = 0; i2 < other.used_bigits_; ++i2) {
            long product = (long)factor * (long)other.bigits_[i2];
            long remove = (long)borrow + product;
            int difference = this.bigits_[i2 + exponent_diff] - (int)(remove & 0xFFFFFFFL);
            this.bigits_[i2 + exponent_diff] = difference & 0xFFFFFFF;
            borrow = (int)((long)(difference >>> 31) + (remove >>> 28));
        }
        for (i2 = other.used_bigits_ + exponent_diff; i2 < this.used_bigits_; ++i2) {
            if (borrow == 0) {
                return;
            }
            int difference = this.bigits_[i2] - borrow;
            this.bigits_[i2] = difference & 0xFFFFFFF;
            borrow = difference >>> 31;
        }
        this.clamp();
    }

    public String toString() {
        return "Bignum[" + this.toHexString() + "]";
    }
}

