/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.doubleconv;

import java.nio.charset.StandardCharsets;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.doubleconv.DtoaMode;

public final class DtoaBuffer {
    private static final char EXPONENT_CHARACTER = 'e';
    final byte[] chars;
    int length = 0;
    int decimalPoint = 0;
    boolean isNegative = false;
    public static final int kFastDtoaMaximalLength = 17;

    public DtoaBuffer(int capacity) {
        this.chars = new byte[capacity];
    }

    void append(int c2) {
        assert ((c2 & 0xFF) == c2) : c2;
        this.chars[this.length++] = (byte)c2;
    }

    public void reset() {
        this.length = 0;
        this.decimalPoint = 0;
    }

    public String getRawDigits() {
        return new String(this.chars, 0, this.length);
    }

    public int getDecimalPoint() {
        return this.decimalPoint;
    }

    public int getLength() {
        return this.length;
    }

    public String format(DtoaMode mode, int digitsAfterPoint) {
        switch (mode) {
            case SHORTEST: {
                if (this.decimalPoint < -5 || this.decimalPoint > 21) {
                    return this.toExponentialFormat(this.isNegative);
                }
                return this.toFixedFormat(digitsAfterPoint, this.isNegative);
            }
            case FIXED: {
                return this.toFixedFormat(digitsAfterPoint, this.isNegative);
            }
        }
        if (this.decimalPoint < -5 || this.decimalPoint > this.length) {
            return this.toExponentialFormat(this.isNegative);
        }
        return this.toFixedFormat(digitsAfterPoint, this.isNegative);
    }

    private String toFixedFormat(int digitsAfterPoint, boolean minus) {
        int i2;
        int formatLength = this.calculateFixedFormatLength(digitsAfterPoint, minus);
        StringBuilder buffer = new StringBuilder(formatLength);
        if (minus) {
            buffer.append('-');
        }
        if (this.decimalPoint <= 0) {
            buffer.append('0');
            if (this.length > 0) {
                buffer.append('.');
                int padding = -this.decimalPoint;
                for (int i3 = 0; i3 < padding; ++i3) {
                    buffer.append('0');
                }
                DtoaBuffer.appendBytes(buffer, this.chars, 0, this.length);
            } else {
                this.decimalPoint = 1;
            }
        } else if (this.decimalPoint >= this.length) {
            DtoaBuffer.appendBytes(buffer, this.chars, 0, this.length);
            for (i2 = this.length; i2 < this.decimalPoint; ++i2) {
                buffer.append('0');
            }
        } else {
            assert (this.decimalPoint < this.length);
            DtoaBuffer.appendBytes(buffer, this.chars, 0, this.decimalPoint);
            buffer.append('.');
            DtoaBuffer.appendBytes(buffer, this.chars, this.decimalPoint, this.length - this.decimalPoint);
        }
        if (digitsAfterPoint > 0) {
            if (this.decimalPoint >= this.length) {
                buffer.append('.');
            }
            for (i2 = Math.max(0, this.length - this.decimalPoint); i2 < digitsAfterPoint; ++i2) {
                buffer.append('0');
            }
        }
        assert (buffer.length() == formatLength) : "expected length: " + formatLength + " actual length: " + buffer.length();
        return buffer.toString();
    }

    private int calculateFixedFormatLength(int digitsAfterPoint, boolean minus) {
        int formatLength;
        int n2 = formatLength = minus ? 1 : 0;
        if (this.decimalPoint <= 0) {
            ++formatLength;
            if (this.length > 0) {
                ++formatLength;
                int padding = -this.decimalPoint;
                formatLength += padding;
                formatLength += this.length;
            } else {
                this.decimalPoint = 1;
            }
        } else if (this.decimalPoint >= this.length) {
            formatLength += this.length;
            formatLength += this.decimalPoint - this.length;
        } else {
            assert (this.decimalPoint < this.length);
            formatLength += this.decimalPoint;
            ++formatLength;
            formatLength += this.length - this.decimalPoint;
        }
        if (digitsAfterPoint > 0) {
            if (this.decimalPoint >= this.length) {
                ++formatLength;
            }
            formatLength += Math.max(0, digitsAfterPoint - Math.max(0, this.length - this.decimalPoint));
        }
        return formatLength;
    }

    String toExponentialFormat(boolean minus) {
        int formatLength = this.calculateExponentialFormatLength(minus);
        StringBuilder buffer = new StringBuilder(formatLength);
        if (minus) {
            buffer.append('-');
        }
        assert (this.length != 0);
        buffer.append((char)this.chars[0]);
        if (this.length > 1) {
            buffer.append('.');
            DtoaBuffer.appendBytes(buffer, this.chars, 1, this.length - 1);
        }
        buffer.append('e');
        int exponent = this.decimalPoint - 1;
        assert (Math.abs(exponent) < 10000);
        if (exponent >= 0) {
            buffer.append('+');
        }
        buffer.append(exponent);
        assert (buffer.length() == formatLength) : "expected length: " + formatLength + " actual length: " + buffer.length();
        return buffer.toString();
    }

    private int calculateExponentialFormatLength(boolean minus) {
        assert (this.length != 0);
        int formatLength = minus ? 1 : 0;
        formatLength += this.length;
        if (this.length > 1) {
            ++formatLength;
        }
        formatLength += 2;
        int exponent = this.decimalPoint - 1;
        return formatLength += DtoaBuffer.numberOfDigits(Math.abs(exponent));
    }

    private static int numberOfDigits(int x2) {
        assert (x2 >= 0) : x2;
        int i2 = 1;
        int p2 = 10;
        while (i2 < 10) {
            if (x2 < p2) {
                return i2;
            }
            ++i2;
            p2 *= 10;
        }
        return 10;
    }

    private static void appendBytes(StringBuilder buffer, byte[] chars, int start, int len) {
        for (int i2 = start; i2 < start + len; ++i2) {
            buffer.append((char)chars[i2]);
        }
    }

    public String toString() {
        return "[chars:" + new String(this.chars, 0, this.length, StandardCharsets.ISO_8859_1) + ", decimalPoint:" + this.decimalPoint + "]";
    }
}

