/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.interop;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.HostCompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.ArityException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InvalidArrayIndexException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnknownIdentifierException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnknownKeyException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedMessageException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.UnsupportedTypeException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.profiles.BranchProfile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ExportValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ForeignObjectPrototypeNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.nodes.interop.ImportValueNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.BigInt;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Errors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSContext;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRealm;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.JSRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Strings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.Symbol;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSArrayBufferObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.builtins.JSError;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.JSObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Null;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.js.runtime.objects.Undefined;

public final class JSInteropUtil {
    private JSInteropUtil() {
    }

    public static long getArraySize(Object foreignObj, InteropLibrary interop, Node originatingNode) {
        try {
            return interop.getArraySize(foreignObj);
        }
        catch (UnsupportedMessageException e2) {
            throw Errors.createTypeErrorInteropException(foreignObj, e2, "getArraySize", originatingNode);
        }
    }

    public static boolean setArraySize(Object obj, Object value, boolean isStrict, InteropLibrary interop, Node originatingNode, BranchProfile errorBranch) {
        long oldLen;
        long newLen = JSAbstractArray.toArrayLengthOrRangeError(value, originatingNode);
        try {
            oldLen = interop.getArraySize(obj);
        }
        catch (UnsupportedMessageException e2) {
            if (errorBranch != null) {
                errorBranch.enter();
            }
            throw Errors.createTypeErrorInteropException(obj, e2, "getArraySize", originatingNode);
        }
        String message = null;
        try {
            if (newLen < oldLen) {
                message = "removeArrayElement";
                for (long idx = oldLen - 1L; idx >= newLen; --idx) {
                    interop.removeArrayElement(obj, idx);
                }
            } else {
                message = "writeArrayElement";
                for (long idx = oldLen; idx < newLen; ++idx) {
                    interop.writeArrayElement(obj, idx, Undefined.instance);
                }
            }
        }
        catch (InteropException e3) {
            if (isStrict) {
                if (errorBranch != null) {
                    errorBranch.enter();
                }
                throw Errors.createTypeErrorInteropException(obj, e3, message, originatingNode);
            }
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object getOrDefault(JSContext context, Object target, Object propertyKey, Object receiver, Object defaultValue) {
        Object result;
        assert (JSRuntime.isPropertyKey(propertyKey));
        InteropLibrary interop = InteropLibrary.getUncached();
        ImportValueNode importValue = ImportValueNode.getUncached();
        boolean hasArrayElements = interop.hasArrayElements(target);
        if (hasArrayElements && JSRuntime.isArrayIndex(propertyKey)) {
            return JSInteropUtil.readArrayElementOrDefault(target, JSRuntime.parseArrayIndexIsIndexRaw(propertyKey), defaultValue, interop, importValue);
        }
        if (context.getLanguageOptions().hasForeignHashProperties() && interop.hasHashEntries(target)) {
            try {
                return JSInteropUtil.readHashEntryOrDefault(target, propertyKey, defaultValue, interop, importValue);
            }
            catch (UnknownKeyException unknownKeyException) {
                // empty catch block
            }
        }
        if (propertyKey instanceof Symbol) {
            return JSInteropUtil.maybeReadFromPrototype(context, target, propertyKey, receiver, defaultValue, interop);
        }
        TruffleString exportedKeyStr = (TruffleString)propertyKey;
        if (hasArrayElements && Strings.equals(JSAbstractArray.LENGTH, exportedKeyStr)) {
            return JSInteropUtil.getArraySize(target, interop, null);
        }
        if (interop.hasMembers(target) && (result = JSInteropUtil.readMemberOrDefault(target, propertyKey, null, interop, importValue)) != null) {
            return result;
        }
        return JSInteropUtil.maybeReadFromPrototype(context, target, propertyKey, receiver, defaultValue, interop);
    }

    private static Object maybeReadFromPrototype(JSContext context, Object truffleObject, Object key, Object receiver, Object defaultValue, InteropLibrary interop) {
        if (context.getLanguageOptions().hasForeignObjectPrototype() || key instanceof Symbol || JSInteropUtil.isBoxedPrimitive(truffleObject, interop)) {
            JSDynamicObject prototype = ForeignObjectPrototypeNode.getUncached().execute(truffleObject);
            return JSObject.getOrDefault(prototype, key, receiver, defaultValue);
        }
        return defaultValue;
    }

    public static Object readMemberOrDefault(Object obj, Object member, Object defaultValue) {
        return JSInteropUtil.readMemberOrDefault(obj, member, defaultValue, InteropLibrary.getUncached(), ImportValueNode.getUncached());
    }

    public static Object readMemberOrDefault(Object obj, Object member, Object defaultValue, InteropLibrary interop, ImportValueNode importValue) {
        if (!(member instanceof TruffleString)) {
            return defaultValue;
        }
        TruffleString memberName = (TruffleString)member;
        try {
            return importValue.executeWithTarget(interop.readMember(obj, Strings.toJavaString(memberName)));
        }
        catch (UnknownIdentifierException | UnsupportedMessageException e2) {
            return defaultValue;
        }
    }

    public static Object readArrayElementOrDefault(Object obj, long index, Object defaultValue, InteropLibrary interop, ImportValueNode importValue) {
        try {
            return importValue.executeWithTarget(interop.readArrayElement(obj, index));
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e2) {
            return defaultValue;
        }
    }

    public static Object readArrayElementOrDefault(Object obj, long index, Object defaultValue) {
        return JSInteropUtil.readArrayElementOrDefault(obj, index, defaultValue, InteropLibrary.getUncached(), ImportValueNode.getUncached());
    }

    private static Object readHashEntryOrDefault(Object obj, Object propertyKey, Object defaultValue, InteropLibrary interop, ImportValueNode importValue) throws UnknownKeyException {
        try {
            return importValue.executeWithTarget(interop.readHashValue(obj, propertyKey));
        }
        catch (UnsupportedMessageException e2) {
            return defaultValue;
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean set(JSContext context, Object target, Object propertyKey, Object value, boolean strict) {
        assert (JSRuntime.isPropertyKey(propertyKey));
        InteropLibrary interop = InteropLibrary.getUncached();
        ExportValueNode exportValue = ExportValueNode.getUncached();
        boolean hasArrayElements = interop.hasArrayElements(target);
        if (hasArrayElements && JSRuntime.isArrayIndex(propertyKey)) {
            return JSInteropUtil.writeArrayElement(target, JSRuntime.parseArrayIndexIsIndexRaw(propertyKey), value, interop, exportValue, strict);
        }
        if (context.getLanguageOptions().hasForeignHashProperties() && interop.hasHashEntries(target)) {
            return JSInteropUtil.writeHashEntry(target, propertyKey, value, interop, exportValue, strict);
        }
        if (propertyKey instanceof Symbol) {
            return false;
        }
        TruffleString stringKey = (TruffleString)propertyKey;
        if (hasArrayElements && Strings.equals(JSAbstractArray.LENGTH, stringKey)) {
            return JSInteropUtil.setArraySize(target, value, strict, interop, null, null);
        }
        return JSInteropUtil.writeMember(target, propertyKey, value, interop, exportValue, strict, null);
    }

    private static boolean writeArrayElement(Object obj, long index, Object value, InteropLibrary interop, ExportValueNode exportValue, boolean strict) {
        try {
            interop.writeArrayElement(obj, index, exportValue.execute(value));
            return true;
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException | UnsupportedTypeException e2) {
            if (strict) {
                throw Errors.createTypeErrorInteropException(obj, e2, "writeArrayElement", null);
            }
            return false;
        }
    }

    private static boolean writeHashEntry(Object obj, Object propertyKey, Object value, InteropLibrary interop, ExportValueNode exportValue, boolean strict) {
        try {
            interop.writeHashEntry(obj, propertyKey, exportValue.execute(value));
            return true;
        }
        catch (UnknownKeyException | UnsupportedMessageException | UnsupportedTypeException e2) {
            if (strict) {
                throw Errors.createTypeErrorInteropException(obj, e2, "writeHashEntry", null);
            }
            return false;
        }
    }

    public static boolean writeMember(Object obj, Object member, Object value) {
        return JSInteropUtil.writeMember(obj, member, value, InteropLibrary.getUncached(), ExportValueNode.getUncached(), false, null);
    }

    public static boolean writeMember(Object obj, Object member, Object value, InteropLibrary interop, ExportValueNode exportValue, boolean strict, Node originatingNode) {
        if (!(member instanceof TruffleString)) {
            return false;
        }
        TruffleString memberName = (TruffleString)member;
        try {
            interop.writeMember(obj, Strings.toJavaString(memberName), exportValue.execute(value));
            return true;
        }
        catch (UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e2) {
            if (strict) {
                throw Errors.createTypeErrorInteropException(obj, e2, "writeMember", member, originatingNode);
            }
            return false;
        }
    }

    @HostCompilerDirectives.InliningCutoff
    public static Object toPrimitiveOrDefaultLossy(Object obj, Object defaultValue, InteropLibrary interop, Node originatingNode) {
        if (interop.isNull(obj)) {
            return Null.instance;
        }
        try {
            if (interop.isBoolean(obj)) {
                return interop.asBoolean(obj);
            }
            if (interop.isString(obj)) {
                return Strings.interopAsTruffleString(obj, interop);
            }
            if (interop.isNumber(obj)) {
                if (interop.fitsInInt(obj)) {
                    return interop.asInt(obj);
                }
                if (interop.fitsInDouble(obj)) {
                    return interop.asDouble(obj);
                }
                if (interop.fitsInLong(obj)) {
                    return (double)interop.asLong(obj);
                }
                if (interop.fitsInBigInteger(obj)) {
                    return BigInt.doubleValueOf(interop.asBigInteger(obj));
                }
            }
        }
        catch (UnsupportedMessageException e2) {
            throw Errors.createTypeErrorUnboxException(obj, e2, originatingNode);
        }
        return defaultValue;
    }

    @HostCompilerDirectives.InliningCutoff
    public static Object toPrimitiveOrDefaultLossless(Object obj, Object defaultValue, InteropLibrary interop, TruffleString.SwitchEncodingNode switchEncoding, Node originatingNode) {
        if (interop.isNull(obj)) {
            return Null.instance;
        }
        try {
            if (interop.isBoolean(obj)) {
                return interop.asBoolean(obj);
            }
            if (interop.isString(obj)) {
                return Strings.interopAsTruffleString(obj, interop, switchEncoding);
            }
            if (interop.isNumber(obj)) {
                if (interop.fitsInInt(obj)) {
                    return interop.asInt(obj);
                }
                if (interop.fitsInLong(obj)) {
                    return interop.asLong(obj);
                }
                if (interop.fitsInBigInteger(obj)) {
                    return BigInt.fromForeignBigInteger(interop.asBigInteger(obj));
                }
                if (interop.fitsInDouble(obj)) {
                    return interop.asDouble(obj);
                }
            }
        }
        catch (UnsupportedMessageException e2) {
            throw Errors.createTypeErrorUnboxException(obj, e2, originatingNode);
        }
        return defaultValue;
    }

    @CompilerDirectives.TruffleBoundary
    public static List<Object> keys(Object obj) {
        try {
            Object keysObj = InteropLibrary.getUncached().getMembers(obj);
            InteropLibrary keysInterop = InteropLibrary.getUncached(keysObj);
            long size = keysInterop.getArraySize(keysObj);
            if (size < 0L || size >= Integer.MAX_VALUE) {
                throw Errors.createRangeErrorInvalidArrayLength();
            }
            ArrayList<Object> keys = new ArrayList<Object>((int)size);
            int i2 = 0;
            while ((long)i2 < size) {
                Object key = keysInterop.readArrayElement(keysObj, i2);
                keys.add(Strings.interopAsTruffleString(key));
                ++i2;
            }
            return keys;
        }
        catch (InvalidArrayIndexException | UnsupportedMessageException e2) {
            throw Errors.createTypeErrorInteropException(obj, e2, "readArrayElement", null);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean hasProperty(Object obj, Object key) {
        if (key instanceof TruffleString) {
            TruffleString name = (TruffleString)key;
            return InteropLibrary.getUncached().isMemberExisting(obj, Strings.toJavaString(name));
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean delete(JSContext context, Object target, Object propertyKey, boolean strict) {
        assert (JSRuntime.isPropertyKey(propertyKey));
        InteropLibrary interop = InteropLibrary.getUncached();
        if (interop.hasArrayElements(target) && JSRuntime.isArrayIndex(propertyKey)) {
            return JSInteropUtil.deleteArrayElement(target, JSRuntime.parseArrayIndexIsIndexRaw(propertyKey), interop, strict);
        }
        if (context.getLanguageOptions().hasForeignHashProperties() && interop.hasHashEntries(target)) {
            try {
                return JSInteropUtil.deleteHashEntry(target, propertyKey, interop, strict);
            }
            catch (UnknownKeyException unknownKeyException) {
                // empty catch block
            }
        }
        if (interop.hasMembers(target)) {
            if (propertyKey instanceof TruffleString) {
                TruffleString memberName = (TruffleString)propertyKey;
                return JSInteropUtil.deleteMember(target, memberName, interop, strict);
            }
            assert (propertyKey instanceof Symbol);
            return true;
        }
        return true;
    }

    public static boolean deleteArrayElement(Object target, long index, InteropLibrary interop, boolean strict) {
        long length;
        assert (interop.hasArrayElements(target));
        try {
            length = interop.getArraySize(target);
        }
        catch (UnsupportedMessageException e2) {
            return true;
        }
        if (index >= 0L && index < length) {
            if (strict) {
                throw Errors.createTypeErrorNotConfigurableProperty(Strings.fromLong(index));
            }
            return false;
        }
        return true;
    }

    public static boolean deleteHashEntry(Object target, Object key, InteropLibrary interop, boolean strict) throws UnknownKeyException {
        assert (interop.hasHashEntries(target));
        try {
            interop.removeHashEntry(target, key);
            return true;
        }
        catch (UnsupportedMessageException e2) {
            if (strict) {
                throw Errors.createTypeErrorInteropException(target, e2, "removeHashEntry", null);
            }
            return false;
        }
    }

    public static boolean deleteMember(Object target, TruffleString name, InteropLibrary interop, boolean strict) {
        assert (interop.hasMembers(target));
        String javaName = Strings.toJavaString(name);
        if (interop.isMemberExisting(target, javaName)) {
            try {
                interop.removeMember(target, javaName);
                return true;
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e2) {
                if (strict) {
                    throw Errors.createTypeErrorCannotDeletePropertyOf(name, target);
                }
                return false;
            }
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static Object call(Object function, Object[] args) {
        Object[] exportedArgs = JSRuntime.exportValueArray(args);
        try {
            return JSRuntime.importValue(InteropLibrary.getUncached().execute(function, exportedArgs));
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e2) {
            throw Errors.createTypeErrorInteropException(function, e2, "execute", null);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Object construct(Object target, Object[] args) {
        Object[] exportedArgs = JSRuntime.exportValueArray(args);
        try {
            return JSRuntime.importValue(InteropLibrary.getUncached().instantiate(target, exportedArgs));
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e2) {
            throw Errors.createTypeErrorInteropException(target, e2, "instantiate", null);
        }
    }

    public static boolean isBoxedPrimitive(Object receiver, InteropLibrary interop) {
        return interop.isString(receiver) || interop.isNumber(receiver) || interop.isBoolean(receiver);
    }

    public static PropertyDescriptor getOwnProperty(Object object, TruffleString propertyKey) {
        return JSInteropUtil.getOwnProperty(object, propertyKey, InteropLibrary.getUncached(), ImportValueNode.getUncached(), TruffleString.ReadCharUTF16Node.getUncached());
    }

    @HostCompilerDirectives.InliningCutoff
    public static PropertyDescriptor getOwnProperty(Object object, TruffleString propertyKey, InteropLibrary interop, ImportValueNode importValueNode, TruffleString.ReadCharUTF16Node charAtNode) {
        try {
            PropertyDescriptor desc;
            String key = Strings.toJavaString(propertyKey);
            if (interop.hasMembers(object) && interop.isMemberExisting(object, key) && (desc = JSInteropUtil.getExistingMemberProperty(object, key, interop, importValueNode)) != null) {
                return desc;
            }
            long index = JSRuntime.propertyNameToArrayIndex(propertyKey, charAtNode);
            if (JSRuntime.isArrayIndex(index) && interop.hasArrayElements(object)) {
                return JSInteropUtil.getArrayElementProperty(object, index, interop, importValueNode);
            }
        }
        catch (InteropException interopException) {
            // empty catch block
        }
        return null;
    }

    @HostCompilerDirectives.InliningCutoff
    public static PropertyDescriptor getExistingMemberProperty(Object object, String key, InteropLibrary interop, ImportValueNode importValueNode) throws InteropException {
        assert (interop.hasMembers(object) && interop.isMemberExisting(object, key));
        if (interop.isMemberReadable(object, key)) {
            return PropertyDescriptor.createData(importValueNode.executeWithTarget(interop.readMember(object, key)), !interop.isMemberInternal(object, key), interop.isMemberWritable(object, key), interop.isMemberRemovable(object, key));
        }
        return null;
    }

    @HostCompilerDirectives.InliningCutoff
    public static PropertyDescriptor getArrayElementProperty(Object object, long index, InteropLibrary interop, ImportValueNode importValueNode) throws InteropException {
        assert (interop.hasArrayElements(object) && JSRuntime.isArrayIndex(index));
        if (interop.isArrayElementExisting(object, index) && interop.isArrayElementReadable(object, index)) {
            return PropertyDescriptor.createData(importValueNode.executeWithTarget(interop.readArrayElement(object, index)), true, interop.isArrayElementWritable(object, index), interop.isArrayElementRemovable(object, index));
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    public static String formatError(Object error, InteropLibrary interopExc, InteropLibrary interopStr) {
        block12: {
            if (interopExc.isException(error)) {
                try {
                    String message = null;
                    if (interopExc.hasExceptionMessage(error)) {
                        message = interopStr.asString(interopExc.getExceptionMessage(error));
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append(Objects.requireNonNullElse(message, "Error"));
                    if (interopExc.hasExceptionStackTrace(error)) {
                        Object stackTrace = interopExc.getExceptionStackTrace(error);
                        InteropLibrary interopST = InteropLibrary.getUncached(stackTrace);
                        long length = interopST.getArraySize(stackTrace);
                        for (long i2 = 0L; i2 < length; ++i2) {
                            Object stackTraceElement = interopST.readArrayElement(stackTrace, i2);
                            InteropLibrary interopSTE = InteropLibrary.getUncached(stackTraceElement);
                            String name = "";
                            SourceSection sourceLocation = null;
                            if (interopSTE.hasExecutableName(stackTraceElement)) {
                                name = interopStr.asString(interopSTE.getExecutableName(stackTraceElement));
                            }
                            if (interopSTE.hasSourceLocation(stackTraceElement)) {
                                sourceLocation = interopSTE.getSourceLocation(stackTraceElement);
                            }
                            String className = "";
                            if (interopSTE.hasDeclaringMetaObject(stackTraceElement)) {
                                Object metaObject = interopSTE.getDeclaringMetaObject(stackTraceElement);
                                className = interopStr.asString(InteropLibrary.getUncached(metaObject).getMetaQualifiedName(metaObject));
                            }
                            if (name.isEmpty() && sourceLocation == null) continue;
                            sb.append('\n');
                            sb.append("    at ");
                            if (!className.isEmpty()) {
                                sb.append(className).append('.');
                            }
                            if (!name.isEmpty()) {
                                sb.append(name);
                            } else {
                                sb.append(JSError.ANONYMOUS_FUNCTION_NAME);
                            }
                            if (sourceLocation == null) continue;
                            sb.append(" (").append(JSInteropUtil.formatSourceLocation(sourceLocation)).append(")");
                        }
                    }
                    return sb.toString();
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException e2) {
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError((Object)e2);
                }
            }
        }
        return JSRuntime.safeToString(error).toString();
    }

    private static String formatSourceLocation(SourceSection sourceSection) {
        if (sourceSection == null) {
            return "Unknown";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sourceSection.getSource().getName());
        sb.append(":");
        sb.append(sourceSection.getStartLine());
        if (sourceSection.getStartLine() < sourceSection.getEndLine()) {
            sb.append("-").append(sourceSection.getEndLine());
        }
        sb.append(":");
        sb.append(sourceSection.getCharIndex());
        if (sourceSection.getCharLength() > 1) {
            sb.append("-").append(sourceSection.getCharEndIndex() - 1);
        }
        return sb.toString();
    }

    public static ByteBuffer jsInteropBufferAsByteBuffer(JSArrayBufferObject interopArrayBuffer, InteropLibrary interop, JSRealm realm) {
        assert (JSArrayBuffer.isJSInteropArrayBuffer(interopArrayBuffer));
        Object interopBuffer = JSArrayBuffer.getInteropBuffer(interopArrayBuffer);
        if (interopBuffer == null) {
            assert (JSArrayBuffer.isDetachedBuffer(interopArrayBuffer));
            return null;
        }
        return JSInteropUtil.foreignInteropBufferAsByteBuffer(interopBuffer, interop, realm);
    }

    public static ByteBuffer foreignInteropBufferAsByteBuffer(Object foreignInteropBuffer, InteropLibrary interop, JSRealm realm) {
        Object memAsByteBuffer = realm.getWASMMemAsByteBuffer();
        if (memAsByteBuffer == null) {
            return null;
        }
        try {
            Object buffer;
            Object bufferObject = interop.execute(memAsByteBuffer, foreignInteropBuffer);
            TruffleLanguage.Env env = realm.getEnv();
            if (env.isHostObject(bufferObject) && (buffer = env.asHostObject(bufferObject)) instanceof ByteBuffer) {
                return (ByteBuffer)buffer;
            }
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e2) {
            throw CompilerDirectives.shouldNotReachHere(e2);
        }
        return null;
    }
}

