/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.CodePointSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.CompressedCodePointSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.Range;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.AnyMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.BitSetMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.EmptyMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.HybridBitSetMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.InvertibleCharMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.MultiBitSetMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.RangeListMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.RangeTreeMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.SingleCharMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.SingleRangeMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.TwoCharMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.BitSets;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TBitSet;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;

public class CharMatchers {
    public static CharMatcher createMatcher(CodePointSet cps, CompilationBuffer compilationBuffer) {
        EconomicMap<CodePointSet, CharMatcher> matcherDeduplicationMap = compilationBuffer.getMatcherDeduplicationMap();
        CharMatcher matcher = (CharMatcher)matcherDeduplicationMap.get(cps);
        if (matcher != null) {
            return matcher;
        }
        matcher = CharMatchers.createMatcherInner(cps, compilationBuffer);
        matcherDeduplicationMap.put(cps, matcher);
        return matcher;
    }

    private static CharMatcher createMatcherInner(CodePointSet cps, CompilationBuffer compilationBuffer) {
        if (cps.matchesMinAndMax(compilationBuffer.getEncoding()) || cps.inverseIsSameHighByte(compilationBuffer.getEncoding())) {
            return CharMatchers.createMatcher(cps.createInverse(compilationBuffer.getEncoding()), compilationBuffer, true);
        }
        return CharMatchers.createMatcher(cps, compilationBuffer, false);
    }

    private static CharMatcher createMatcher(CodePointSet cps, CompilationBuffer compilationBuffer, boolean inverse) {
        if (cps.isEmpty()) {
            return EmptyMatcher.create(inverse);
        }
        if (cps.matchesEverything(compilationBuffer.getEncoding())) {
            return AnyMatcher.create(inverse);
        }
        if (cps.matchesSingleChar()) {
            return SingleCharMatcher.create(inverse, cps.getMin());
        }
        if (cps.valueCountEquals(2)) {
            return TwoCharMatcher.create(inverse, cps.getMin(), cps.getMax());
        }
        int size = cps.size();
        if (size == 1) {
            return SingleRangeMatcher.create(inverse, cps.getMin(), cps.getMax());
        }
        if (CharMatchers.preferRangeListMatcherOverBitSetMatcher(cps, size)) {
            return RangeListMatcher.create(inverse, cps.toArray());
        }
        if (BitSets.highByte(cps.getMin()) == BitSets.highByte(cps.getMax())) {
            return CharMatchers.convertToBitSetMatcher(cps, compilationBuffer, inverse);
        }
        if (size > 100 && cps.getMax() <= 65535) {
            return MultiBitSetMatcher.fromRanges(inverse, cps);
        }
        CompressedCodePointSet ccps = CompressedCodePointSet.create(cps, compilationBuffer);
        if (ccps.hasBitSets()) {
            return HybridBitSetMatcher.create(inverse, ccps);
        }
        if (ccps.size() <= 6) {
            return RangeListMatcher.create(inverse, ccps.getRanges());
        }
        return RangeTreeMatcher.create(inverse, ccps.getRanges());
    }

    private static boolean preferRangeListMatcherOverBitSetMatcher(CodePointSet cps, int size) {
        return size <= 2 || cps.valueCountMax(4);
    }

    private static InvertibleCharMatcher convertToBitSetMatcher(CodePointSet cps, CompilationBuffer compilationBuffer, boolean inverse) {
        int highByte = BitSets.highByte(cps.getMin());
        TBitSet bs = compilationBuffer.getByteSizeBitSet();
        for (int i2 = 0; i2 < cps.size(); ++i2) {
            assert (BitSets.highByte(cps.getLo(i2)) == highByte && BitSets.highByte(cps.getHi(i2)) == highByte);
            bs.setRange(BitSets.lowByte(cps.getLo(i2)), BitSets.lowByte(cps.getHi(i2)));
        }
        return BitSetMatcher.create(inverse, highByte, bs.toLongArray());
    }

    @CompilerDirectives.TruffleBoundary
    public static String rangesToString(int[] ranges) {
        return CharMatchers.rangesToString(ranges, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static String rangesToString(int[] ranges, boolean numeric) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < ranges.length; i2 += 2) {
            if (numeric) {
                sb.append("[").append(ranges[i2]).append("-").append(ranges[i2 + 1]).append("]");
                continue;
            }
            sb.append(Range.toString(ranges[i2], ranges[i2 + 1]));
        }
        return sb.toString();
    }
}

