/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.Set;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.StateIndex;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.StateSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.BitSets;

final class StateSetImpl<SI extends StateIndex<? super S>, S>
implements StateSet<SI, S> {
    private static final int ELEMENT_SIZE = 32;
    private static final int SWITCH_TO_BACKING_SET_THRESHOLD = 2;
    private static final long ELEMENT_MASK = -1L;
    private final SI stateIndex;
    private long[] backingSet;
    private int size = 0;
    private long stateList = 0L;

    StateSetImpl(SI stateIndex) {
        this.stateIndex = stateIndex;
    }

    StateSetImpl(StateSetImpl<SI, S> copy) {
        this.stateIndex = copy.stateIndex;
        this.size = copy.size;
        this.backingSet = copy.backingSet == null ? null : Arrays.copyOf(copy.backingSet, copy.backingSet.length);
        this.stateList = copy.stateList;
    }

    @Override
    public SI getStateIndex() {
        return this.stateIndex;
    }

    @Override
    public StateSet<SI, S> copy() {
        return new StateSetImpl<SI, S>(this);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    private boolean useBackingSet() {
        return this.size > 2;
    }

    private static int stateListElement(long stateList, int i2) {
        return StateSetImpl.stateListElement(stateList >>> 32 * i2);
    }

    private static int stateListElement(long stateList) {
        return (int)(stateList & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public boolean contains(Object o2) {
        return this.contains(this.stateIndex.getId((Object)o2));
    }

    @Override
    public boolean add(S e2) {
        return this.add(this.stateIndex.getId(e2));
    }

    @Override
    public boolean remove(Object o2) {
        return this.remove(this.stateIndex.getId((Object)o2));
    }

    private boolean contains(int id) {
        if (this.useBackingSet()) {
            return BitSets.get(this.backingSet, id);
        }
        long sl = this.stateList;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (StateSetImpl.stateListElement(sl) == id) {
                return true;
            }
            sl >>>= 32;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        if (c2 instanceof StateSetImpl) {
            StateSetImpl o2 = (StateSetImpl)c2;
            if (this.useBackingSet() && o2.useBackingSet()) {
                return BitSets.contains(this.backingSet, o2.backingSet);
            }
        }
        for (Object o3 : c2) {
            if (this.contains(o3)) continue;
            return false;
        }
        return true;
    }

    @Override
    private boolean add(int id) {
        int i2;
        if (this.useBackingSet()) {
            if (BitSets.add(this.backingSet, id)) {
                ++this.size;
                return true;
            }
            return false;
        }
        long sl = this.stateList;
        for (i2 = 0; i2 < this.size(); ++i2) {
            if (StateSetImpl.stateListElement(sl) == id) {
                return false;
            }
            if (StateSetImpl.stateListElement(sl) > id) break;
            sl >>>= 32;
        }
        if (this.size() == 2) {
            if (this.backingSet == null) {
                this.backingSet = BitSets.createBitSetArray(this.stateIndex.getNumberOfStates());
            }
            for (int j2 = 0; j2 < this.size(); ++j2) {
                BitSets.set(this.backingSet, StateSetImpl.stateListElement(this.stateList));
                this.stateList >>>= 32;
            }
        }
        ++this.size;
        if (this.useBackingSet()) {
            BitSets.set(this.backingSet, id);
        } else {
            this.stateList = (sl << 32 | (long)id) << i2 * 32 | this.stateList & (-1L << i2 * 32 ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends S> c2) {
        if (c2 instanceof StateSetImpl) {
            StateSetImpl o2 = (StateSetImpl)c2;
            if (this.useBackingSet() && o2.useBackingSet()) {
                int oldSize = this.size;
                this.size = BitSets.addAll(this.backingSet, o2.backingSet);
                return this.size != oldSize;
            }
        }
        boolean ret = false;
        for (S s2 : c2) {
            ret |= this.add(s2);
        }
        return ret;
    }

    private boolean remove(int id) {
        if (this.useBackingSet()) {
            if (BitSets.remove(this.backingSet, id)) {
                --this.size;
                if (this.size == 2) {
                    assert (this.stateList == 0L);
                    int shift = 0;
                    PrimitiveIterator.OfInt it = BitSets.iterator(this.backingSet);
                    while (it.hasNext()) {
                        this.stateList |= (long)it.nextInt() << shift;
                        shift += 32;
                    }
                    BitSets.clear(this.backingSet);
                }
                return true;
            }
            return false;
        }
        long sl = this.stateList;
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (StateSetImpl.stateListElement(sl) == id) {
                this.removeStateListElement(i2);
                --this.size;
                return true;
            }
            sl >>>= 32;
        }
        return false;
    }

    private void removeStateListElement(int i2) {
        long maskClrLo = -1L << i2 * 32;
        long maskClrHi = maskClrLo ^ 0xFFFFFFFFFFFFFFFFL;
        this.stateList = this.stateList >>> 32 & maskClrLo | this.stateList & maskClrHi;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        if (c2 instanceof StateSetImpl) {
            StateSetImpl o2 = (StateSetImpl)c2;
            if (this.useBackingSet() && o2.useBackingSet()) {
                int oldSize = this.size;
                this.size = BitSets.removeAll(this.backingSet, o2.backingSet);
                return this.size != oldSize;
            }
        }
        boolean ret = false;
        for (Object s2 : c2) {
            ret |= this.remove(s2);
        }
        return ret;
    }

    @Override
    public void clear() {
        this.stateList = 0L;
        if (this.useBackingSet()) {
            BitSets.clear(this.backingSet);
        }
        this.size = 0;
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        if (c2 instanceof StateSetImpl) {
            StateSetImpl o2 = (StateSetImpl)c2;
            if (this.useBackingSet() && o2.useBackingSet()) {
                int oldSize = this.size;
                this.size = BitSets.retainAll(this.backingSet, o2.backingSet);
                return this.size != oldSize;
            }
        }
        boolean ret = false;
        for (S s2 : this) {
            if (c2.contains(s2)) continue;
            ret |= this.remove(s2);
        }
        return ret;
    }

    @Override
    public boolean isDisjoint(StateSet<SI, ? extends S> other) {
        StateSetImpl o2 = (StateSetImpl)other;
        if (o2.useBackingSet()) {
            if (this.useBackingSet()) {
                return BitSets.isDisjoint(this.backingSet, o2.backingSet);
            }
            long sl = this.stateList;
            for (int i2 = 0; i2 < this.size(); ++i2) {
                if (o2.contains(StateSetImpl.stateListElement(sl))) {
                    return false;
                }
                sl >>>= 32;
            }
            return true;
        }
        long sl = o2.stateList;
        for (int i3 = 0; i3 < o2.size(); ++i3) {
            if (this.contains(StateSetImpl.stateListElement(sl))) {
                return false;
            }
            sl >>>= 32;
        }
        return true;
    }

    private boolean stateListSorted() {
        int i2;
        int last = -1;
        for (i2 = 0; i2 < this.size(); ++i2) {
            if (StateSetImpl.stateListElement(this.stateList, i2) <= last) {
                return false;
            }
            last = StateSetImpl.stateListElement(this.stateList, i2);
        }
        for (i2 = this.size(); i2 < 2; ++i2) {
            if (StateSetImpl.stateListElement(this.stateList, i2) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.useBackingSet()) {
            return BitSets.hashCode(this.backingSet);
        }
        assert (this.stateListSorted());
        return Long.hashCode(this.stateList);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof StateSetImpl) {
            StateSetImpl o2 = (StateSetImpl)obj;
            if (this.size() != o2.size()) {
                return false;
            }
            assert (this.useBackingSet() == o2.useBackingSet());
            if (this.useBackingSet()) {
                return BitSets.equals(this.backingSet, o2.backingSet);
            }
            assert (this.stateListSorted());
            assert (o2.stateListSorted());
            return this.stateList == o2.stateList;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set o3 = (Set)obj;
        return this.size() == o3.size() && this.containsAll(o3);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.defaultToString();
    }

    private PrimitiveIterator.OfInt intIterator() {
        if (this.useBackingSet()) {
            return BitSets.iterator(this.backingSet);
        }
        assert (this.stateListSorted());
        return new StateListIterator();
    }

    @Override
    public Iterator<S> iterator() {
        return new StateSetIterator(this.intIterator());
    }

    private final class StateListIterator
    implements PrimitiveIterator.OfInt {
        private int i;

        private StateListIterator() {
        }

        @Override
        public int nextInt() {
            return StateSetImpl.stateListElement(StateSetImpl.this.stateList, this.i++);
        }

        @Override
        public boolean hasNext() {
            return this.i < StateSetImpl.this.size;
        }

        @Override
        public void remove() {
            StateSetImpl.this.removeStateListElement(--this.i);
        }
    }

    private final class StateSetIterator
    implements Iterator<S> {
        private final PrimitiveIterator.OfInt intIterator;

        private StateSetIterator(PrimitiveIterator.OfInt intIterator) {
            this.intIterator = intIterator;
        }

        @Override
        public boolean hasNext() {
            return this.intIterator.hasNext();
        }

        @Override
        public S next() {
            return StateSetImpl.this.getStateIndex().getState(this.intIterator.nextInt());
        }

        @Override
        public void remove() {
            this.intIterator.remove();
            --StateSetImpl.this.size;
        }
    }
}

