/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer;

import java.util.Iterator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.Range;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.RangesBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.IntArrayBuffer;

public class IntRangesBuffer
extends IntArrayBuffer
implements RangesBuffer {
    public IntRangesBuffer() {
        this(16);
    }

    public IntRangesBuffer(int initialSize) {
        super(initialSize);
    }

    @Override
    public int getLo(int i2) {
        return this.buf[i2 * 2];
    }

    @Override
    public int getHi(int i2) {
        return this.buf[i2 * 2 + 1];
    }

    @Override
    public int size() {
        return this.length() / 2;
    }

    @Override
    public void appendRange(int lo, int hi) {
        assert (this.isEmpty() || this.leftOf(this.size() - 1, lo, hi) && !this.adjacent(this.size() - 1, lo, hi));
        this.add(lo);
        this.add(hi);
    }

    public void addSingleValue(int newValue) {
        assert (this.isEmpty() || this.leftOf(this.size() - 1, newValue, newValue));
        if (!this.isEmpty() && this.adjacent(this.size() - 1, newValue, newValue)) {
            this.buf[(this.size() - 1) * 2 + 1] = newValue;
        } else {
            this.add(newValue);
            this.add(newValue);
        }
    }

    public void appendRangeAllowAdjacent(int lo, int hi) {
        assert (this.isEmpty() || this.leftOf(this.size() - 1, lo, hi));
        this.add(lo);
        this.add(hi);
    }

    public void appendRangeConcatAdjacent(int lo, int hi) {
        assert (this.isEmpty() || this.leftOf(this.size() - 1, lo, hi));
        if (this.isEmpty() || !this.adjacent(this.size() - 1, lo, hi)) {
            this.add(lo);
            this.add(hi);
        } else {
            this.set((this.size() - 1) * 2 + 1, hi);
        }
    }

    @Override
    public void insertRange(int index, int lo, int hi) {
        assert (index >= 0 && index < this.size());
        assert (index == 0 || this.leftOf(index - 1, lo, hi) && !this.adjacent(index - 1, lo, hi));
        assert (this.rightOf(index, lo, hi) && !this.adjacent(index, lo, hi));
        this.ensureCapacity(this.length + 2);
        int i2 = index * 2;
        System.arraycopy(this.buf, i2, this.buf, i2 + 2, this.length - i2);
        this.buf[i2] = lo;
        this.buf[i2 + 1] = hi;
        this.length += 2;
    }

    @Override
    public void replaceRanges(int fromIndex, int toIndex, int lo, int hi) {
        assert (fromIndex >= 0 && fromIndex < toIndex && toIndex >= 0 && toIndex <= this.size());
        assert (fromIndex == 0 || this.leftOf(fromIndex - 1, lo, hi) && !this.adjacent(fromIndex - 1, lo, hi));
        assert (toIndex == this.size() || this.rightOf(toIndex, lo, hi) && !this.adjacent(toIndex, lo, hi));
        this.buf[fromIndex * 2] = lo;
        this.buf[fromIndex * 2 + 1] = hi;
        if (toIndex < this.size()) {
            System.arraycopy(this.buf, toIndex * 2, this.buf, fromIndex * 2 + 2, this.length - toIndex * 2);
        }
        this.length -= (toIndex - (fromIndex + 1)) * 2;
    }

    @Override
    public void appendRangesTo(RangesBuffer buffer, int startIndex, int endIndex) {
        assert (buffer instanceof IntRangesBuffer);
        int bulkLength = (endIndex - startIndex) * 2;
        if (bulkLength == 0) {
            return;
        }
        IntRangesBuffer o2 = (IntRangesBuffer)buffer;
        int newSize = o2.length() + bulkLength;
        o2.ensureCapacity(newSize);
        assert (o2.isEmpty() || this.rightOf(startIndex, o2, o2.size() - 1));
        System.arraycopy(this.buf, startIndex * 2, o2.getBuffer(), o2.length(), bulkLength);
        o2.setLength(newSize);
    }

    public IntRangesBuffer create() {
        return new IntRangesBuffer(this.buf.length);
    }

    public Iterator<Range> rangesIterator() {
        return new IntRangesBufferRangesIterator(this);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.defaultToString();
    }

    private static final class IntRangesBufferRangesIterator
    implements Iterator<Range> {
        private final IntRangesBuffer buf;
        private int i = 0;

        private IntRangesBufferRangesIterator(IntRangesBuffer buf) {
            this.buf = buf;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.buf.size();
        }

        @Override
        public Range next() {
            Range ret = new Range(this.buf.getLo(this.i), this.buf.getHi(this.i));
            ++this.i;
            return ret;
        }
    }
}

