/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer;

public final class IntRingBuffer {
    private final int[] buf;
    private int start = 0;
    private int length = 0;

    public IntRingBuffer(int sizePowerOf2) {
        this.buf = new int[1 << sizePowerOf2];
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public void clear() {
        this.start = 0;
        this.length = 0;
    }

    private int index(int index) {
        assert (Integer.bitCount(this.buf.length) == 1);
        return this.start + index & this.buf.length - 1;
    }

    public int first() {
        assert (!this.isEmpty());
        return this.buf[this.start];
    }

    public int last() {
        assert (!this.isEmpty());
        return this.buf[this.index(this.length - 1)];
    }

    public void add(int i2) {
        assert (this.length < this.buf.length);
        this.buf[this.index((int)this.length++)] = i2;
    }

    public void addAll(int[] o2) {
        int copyLength;
        assert (this.buf.length >= this.length + o2.length);
        int copyStart = this.index(this.length);
        if (copyStart + (copyLength = o2.length) > this.buf.length) {
            copyLength -= copyStart + copyLength - this.buf.length;
            System.arraycopy(o2, copyLength, this.buf, 0, o2.length - copyLength);
        }
        System.arraycopy(o2, 0, this.buf, copyStart, copyLength);
        this.length += o2.length;
    }

    public int removeFirst() {
        assert (!this.isEmpty());
        int first = this.first();
        this.start = this.index(1);
        --this.length;
        return first;
    }
}

