/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.CodePointSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.AbstractTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.BasicState;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.StateSet;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.LookBehindAssertion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.Json;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TBitSet;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;

public final class NFAState
extends BasicState<NFAState, NFAStateTransition>
implements JsonConvertible {
    private static final byte FLAGS_NONE = 0;
    private static final byte FLAG_HAS_PREFIX_STATES = 16;
    private static final byte FLAG_MUST_ADVANCE = 32;
    private static final NFAStateTransition[] EMPTY_TRANSITIONS = new NFAStateTransition[0];
    private final StateSet<RegexAST, ? extends RegexASTNode> stateSet;
    @CompilerDirectives.CompilationFinal
    private short transitionToAnchoredFinalState = (short)-1;
    @CompilerDirectives.CompilationFinal
    private short transitionToUnAnchoredFinalState = (short)-1;
    @CompilerDirectives.CompilationFinal
    private short revTransitionToAnchoredFinalState = (short)-1;
    @CompilerDirectives.CompilationFinal
    private short revTransitionToUnAnchoredFinalState = (short)-1;
    private TBitSet possibleResults;
    private final CodePointSet matcherBuilder;
    private final Set<LookBehindAssertion> finishedLookBehinds;
    private final EconomicMap<Integer, TBitSet> matchedConditionGroupsMap;

    public NFAState(short id, StateSet<RegexAST, ? extends RegexASTNode> stateSet, CodePointSet matcherBuilder, Set<LookBehindAssertion> finishedLookBehinds, boolean hasPrefixStates, boolean mustAdvance) {
        this(id, stateSet, NFAState.initFlags(hasPrefixStates, mustAdvance), null, matcherBuilder, finishedLookBehinds, NFAState.initMatchedConditionGroupsMap(stateSet));
    }

    public NFAState(short id, StateSet<RegexAST, ? extends RegexASTNode> stateSet, CodePointSet matcherBuilder, Set<LookBehindAssertion> finishedLookBehinds, boolean hasPrefixStates, boolean mustAdvance, EconomicMap<Integer, TBitSet> matchedConditionGroupsMap) {
        this(id, stateSet, NFAState.initFlags(hasPrefixStates, mustAdvance), null, matcherBuilder, finishedLookBehinds, matchedConditionGroupsMap);
    }

    private static EconomicMap<Integer, TBitSet> initMatchedConditionGroupsMap(StateSet<RegexAST, ? extends RegexASTNode> stateSet) {
        if (!stateSet.getStateIndex().getProperties().hasConditionalBackReferences()) {
            return null;
        }
        EconomicMap<Integer, TBitSet> matchedConditionGroupsMap = EconomicMap.create();
        for (RegexASTNode node : stateSet) {
            matchedConditionGroupsMap.put(node.getId(), TBitSet.getEmptyInstance());
        }
        return matchedConditionGroupsMap;
    }

    private static byte initFlags(boolean hasPrefixStates, boolean mustAdvance) {
        return (byte)((hasPrefixStates ? 16 : 0) | (mustAdvance ? 32 : 0));
    }

    private NFAState(short id, StateSet<RegexAST, ? extends RegexASTNode> stateSet, short flags, CodePointSet matcherBuilder, Set<LookBehindAssertion> finishedLookBehinds, EconomicMap<Integer, TBitSet> matchedConditionGroupsMap) {
        this(id, stateSet, flags, null, matcherBuilder, finishedLookBehinds, matchedConditionGroupsMap);
    }

    private NFAState(short id, StateSet<RegexAST, ? extends RegexASTNode> stateSet, short flags, TBitSet possibleResults, CodePointSet matcherBuilder, Set<LookBehindAssertion> finishedLookBehinds, EconomicMap<Integer, TBitSet> matchedConditionGroupsMap) {
        super((int)id, (AbstractTransition[])EMPTY_TRANSITIONS);
        this.setFlag(flags);
        this.stateSet = stateSet;
        this.possibleResults = possibleResults;
        this.matcherBuilder = matcherBuilder;
        this.finishedLookBehinds = finishedLookBehinds;
        this.matchedConditionGroupsMap = matchedConditionGroupsMap;
    }

    public NFAState createTraceFinderCopy(short copyID) {
        return new NFAState(copyID, this.getStateSet(), this.getFlags(), this.matcherBuilder, this.finishedLookBehinds, this.matchedConditionGroupsMap);
    }

    public CodePointSet getCharSet() {
        return this.matcherBuilder;
    }

    public Set<LookBehindAssertion> getFinishedLookBehinds() {
        return this.finishedLookBehinds;
    }

    public StateSet<RegexAST, ? extends RegexASTNode> getStateSet() {
        return this.stateSet;
    }

    public boolean hasPrefixStates() {
        return this.getFlag((short)16);
    }

    public void setHasPrefixStates(boolean value) {
        this.setFlag((short)16, value);
    }

    public boolean isMustAdvance() {
        return this.getFlag((short)32);
    }

    public void setMustAdvance(boolean value) {
        this.setFlag((short)32, value);
    }

    public EconomicMap<Integer, TBitSet> getMatchedConditionGroupsMap() {
        return this.matchedConditionGroupsMap;
    }

    public TBitSet getMatchedConditionGroups(RegexASTNode t2) {
        if (!this.stateSet.getStateIndex().getProperties().hasConditionalBackReferences()) {
            return TBitSet.getEmptyInstance();
        }
        assert (this.matchedConditionGroupsMap.containsKey(t2.getId()));
        return (TBitSet)this.matchedConditionGroupsMap.get(t2.getId());
    }

    public TBitSet getMatchedConditionGroupsDebug() {
        if (!this.stateSet.getStateIndex().getProperties().hasConditionalBackReferences()) {
            return TBitSet.getEmptyInstance();
        }
        TBitSet matchedConditionGroups = new TBitSet(64);
        for (RegexASTNode t2 : this.stateSet) {
            matchedConditionGroups.union((TBitSet)this.matchedConditionGroupsMap.get(t2.getId()));
        }
        return matchedConditionGroups;
    }

    public boolean hasTransitionToAnchoredFinalState(boolean forward) {
        return this.getTransitionToAnchoredFinalStateId(forward) >= 0;
    }

    public short getTransitionToAnchoredFinalStateId(boolean forward) {
        return forward ? this.transitionToAnchoredFinalState : this.revTransitionToAnchoredFinalState;
    }

    public NFAStateTransition getTransitionToAnchoredFinalState(boolean forward) {
        assert (this.hasTransitionToAnchoredFinalState(forward));
        return ((NFAStateTransition[])this.getSuccessors(forward))[this.getTransitionToAnchoredFinalStateId(forward)];
    }

    @Override
    public boolean hasTransitionToUnAnchoredFinalState(boolean forward) {
        return this.getTransitionToUnAnchoredFinalStateId(forward) >= 0;
    }

    public NFAStateTransition getTransitionToUnAnchoredFinalState(boolean forward) {
        assert (this.hasTransitionToUnAnchoredFinalState(forward));
        return ((NFAStateTransition[])this.getSuccessors(forward))[this.getTransitionToUnAnchoredFinalStateId(forward)];
    }

    public short getTransitionToUnAnchoredFinalStateId(boolean forward) {
        return forward ? this.transitionToUnAnchoredFinalState : this.revTransitionToUnAnchoredFinalState;
    }

    public boolean hasTransitionToFinalState(boolean forward) {
        return this.hasTransitionToAnchoredFinalState(forward) || this.hasTransitionToUnAnchoredFinalState(forward);
    }

    public int getFirstTransitionToFinalStateIndex(boolean forward) {
        assert (this.hasTransitionToFinalState(forward));
        return Math.min(Short.toUnsignedInt(this.getTransitionToAnchoredFinalStateId(forward)), Short.toUnsignedInt(this.getTransitionToUnAnchoredFinalStateId(forward)));
    }

    public NFAStateTransition getFirstTransitionToFinalState(boolean forward) {
        return ((NFAStateTransition[])this.getSuccessors(forward))[this.getFirstTransitionToFinalStateIndex(forward)];
    }

    public void addLoopBackNext(NFAStateTransition transition) {
        this.updateFinalStateTransitions(transition, (short)((NFAStateTransition[])this.getSuccessors()).length);
        this.setSuccessors(Arrays.copyOf((NFAStateTransition[])this.getSuccessors(), ((NFAStateTransition[])this.getSuccessors()).length + 1));
        ((NFAStateTransition[])this.getSuccessors())[((NFAStateTransition[])this.getSuccessors()).length - 1] = transition;
    }

    public void removeLoopBackNext() {
        this.setSuccessors(Arrays.copyOf((NFAStateTransition[])this.getSuccessors(), ((NFAStateTransition[])this.getSuccessors()).length - 1));
        if (this.transitionToAnchoredFinalState == ((NFAStateTransition[])this.getSuccessors()).length) {
            this.transitionToAnchoredFinalState = (short)-1;
        }
        if (this.transitionToUnAnchoredFinalState == ((NFAStateTransition[])this.getSuccessors()).length) {
            this.transitionToUnAnchoredFinalState = (short)-1;
        }
    }

    public void setSuccessors(NFAStateTransition[] transitions, boolean createReverseTransitions) {
        this.setSuccessors(transitions);
        for (short i2 = 0; i2 < transitions.length; i2 = (short)(i2 + 1)) {
            NFAStateTransition t2 = transitions[i2];
            this.updateFinalStateTransitions(t2, i2);
            if (!createReverseTransitions) continue;
            t2.getTarget().incPredecessors();
        }
    }

    private void updateFinalStateTransitions(NFAStateTransition transition, short i2) {
        if (this.transitionToAnchoredFinalState == -1 && transition.getTarget().isAnchoredFinalState()) {
            this.transitionToAnchoredFinalState = i2;
        }
        if (this.transitionToUnAnchoredFinalState == -1 && transition.getTarget().isUnAnchoredFinalState()) {
            this.transitionToUnAnchoredFinalState = i2;
        }
    }

    public void removeSuccessor(NFAState state) {
        int toRemove = 0;
        for (NFAStateTransition successor : (NFAStateTransition[])this.getSuccessors()) {
            if (successor.getTarget() != state) continue;
            ++toRemove;
        }
        if (toRemove == 0) {
            return;
        }
        AbstractTransition[] newNext = new NFAStateTransition[((NFAStateTransition[])this.getSuccessors()).length - toRemove];
        short iNew = 0;
        for (int i2 = 0; i2 < ((NFAStateTransition[])this.getSuccessors()).length; i2 = (int)((short)(i2 + 1))) {
            if (((NFAStateTransition[])this.getSuccessors())[i2].getTarget() == state) {
                if (i2 == this.transitionToAnchoredFinalState) {
                    this.transitionToAnchoredFinalState = (short)-1;
                }
                if (i2 != this.transitionToUnAnchoredFinalState) continue;
                this.transitionToUnAnchoredFinalState = (short)-1;
                continue;
            }
            if (i2 == this.transitionToAnchoredFinalState) {
                this.transitionToAnchoredFinalState = iNew;
            }
            if (i2 == this.transitionToUnAnchoredFinalState) {
                this.transitionToUnAnchoredFinalState = iNew;
            }
            short s2 = iNew;
            iNew = (short)(iNew + 1);
            newNext[s2] = ((NFAStateTransition[])this.getSuccessors())[i2];
        }
        this.setSuccessors(newNext);
    }

    public void linkPredecessors() {
        for (NFAStateTransition t2 : (NFAStateTransition[])this.getSuccessors()) {
            t2.getTarget().addPredecessor(t2);
            if (this.isAnchoredInitialState()) {
                t2.getTarget().revTransitionToAnchoredFinalState = (short)t2.getTarget().getNPredecessors();
            }
            if (!this.isUnAnchoredInitialState()) continue;
            t2.getTarget().revTransitionToUnAnchoredFinalState = (short)t2.getTarget().getNPredecessors();
        }
    }

    public TBitSet getPossibleResults() {
        if (this.possibleResults == null) {
            return TBitSet.getEmptyInstance();
        }
        return this.possibleResults;
    }

    public boolean hasPossibleResults() {
        return this.possibleResults != null && !this.possibleResults.isEmpty();
    }

    public void addPossibleResult(int index) {
        if (this.possibleResults == null) {
            this.possibleResults = new TBitSet(254);
        }
        this.possibleResults.set(index);
    }

    public NFAState(NFAState original) {
        super(original);
        this.stateSet = original.stateSet;
        this.transitionToAnchoredFinalState = original.transitionToAnchoredFinalState;
        this.transitionToUnAnchoredFinalState = original.transitionToUnAnchoredFinalState;
        this.revTransitionToAnchoredFinalState = original.revTransitionToAnchoredFinalState;
        this.revTransitionToUnAnchoredFinalState = original.revTransitionToUnAnchoredFinalState;
        this.possibleResults = original.possibleResults;
        this.matcherBuilder = original.matcherBuilder;
        this.finishedLookBehinds = original.finishedLookBehinds;
        this.matchedConditionGroupsMap = original.matchedConditionGroupsMap;
    }

    @CompilerDirectives.TruffleBoundary
    public String idToString() {
        return this.getStateSet().stream().map(x2 -> String.valueOf(x2.getId())).collect(Collectors.joining(",", "(", ")")) + "[" + this.getId() + "]";
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return this.idToString();
    }

    public boolean equals(Object o2) {
        return o2 instanceof NFAState && this.getId() == ((NFAState)o2).getId();
    }

    public int hashCode() {
        return this.getId();
    }

    protected NFAStateTransition[] createTransitionsArray(int length) {
        return new NFAStateTransition[length];
    }

    @CompilerDirectives.TruffleBoundary
    private JsonArray sourceSectionsToJson() {
        return RegexAST.sourceSectionsToJson(this.getStateSet().stream().map(x2 -> this.getStateSet().getStateIndex().getSourceSections((RegexASTNode)x2)).filter(Objects::nonNull).flatMap(Collection::stream));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonObject toJson() {
        return Json.obj(Json.prop("id", this.getId()), Json.prop("stateSet", this.getStateSet().stream().map(x2 -> Json.val(x2.getId()))), Json.prop("mustAdvance", this.isMustAdvance()), Json.prop("sourceSections", this.sourceSectionsToJson()), Json.prop("matcherBuilder", this.matcherBuilder.toString()), Json.prop("forwardAnchoredFinalState", this.isAnchoredFinalState()), Json.prop("forwardUnAnchoredFinalState", this.isUnAnchoredFinalState()), Json.prop("reverseAnchoredFinalState", this.isAnchoredInitialState()), Json.prop("reverseUnAnchoredFinalState", this.isUnAnchoredInitialState()), Json.prop("next", Arrays.stream((NFAStateTransition[])this.getSuccessors()).map(x2 -> Json.val(x2.getId()))), Json.prop("prev", Arrays.stream((NFAStateTransition[])this.getPredecessors()).map(x2 -> Json.val(x2.getId()))));
    }

    @CompilerDirectives.TruffleBoundary
    public JsonObject toJson(boolean forward) {
        return Json.obj(Json.prop("id", this.getId()), Json.prop("stateSet", this.getStateSet().stream().map(x2 -> Json.val(x2.getId()))), Json.prop("mustAdvance", this.isMustAdvance()), Json.prop("sourceSections", this.sourceSectionsToJson()), Json.prop("matcherBuilder", this.matcherBuilder.toString()), Json.prop("anchoredFinalState", this.isAnchoredFinalState(forward)), Json.prop("unAnchoredFinalState", this.isUnAnchoredFinalState(forward)), Json.prop("transitions", Arrays.stream((NFAStateTransition[])this.getSuccessors(forward)).map(x2 -> Json.val(x2.getId()))));
    }
}

