/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.ExplodeLoop;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.Matchers;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.BitSets;

public final class AllTransitionsInOneTreeMatcher
extends Matchers {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] ranges;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final short[] successors;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final AllTransitionsInOneTreeLeafMatcher[] leafMatchers;

    public AllTransitionsInOneTreeMatcher(int[] ranges, short[] successors, AllTransitionsInOneTreeLeafMatcher[] leafMatchers) {
        assert (successors.length == ranges.length + 1);
        this.ranges = ranges;
        this.successors = successors;
        this.leafMatchers = leafMatchers;
    }

    public int checkMatchTree(int c2) {
        CompilerAsserts.partialEvaluationConstant(this);
        return this.checkMatchTree(0, this.ranges.length - 1, c2);
    }

    private int checkMatchTree(int fromIndex, int toIndex, int c2) {
        CompilerAsserts.partialEvaluationConstant(fromIndex);
        CompilerAsserts.partialEvaluationConstant(toIndex);
        if (fromIndex > toIndex) {
            short successor = this.successors[fromIndex];
            if (successor < -1) {
                return this.checkMatchLeaf(successor * -1 - 2, c2);
            }
            return successor;
        }
        int mid = fromIndex + toIndex >>> 1;
        CompilerAsserts.partialEvaluationConstant(mid);
        if (c2 < this.ranges[mid]) {
            return this.checkMatchTree(fromIndex, mid - 1, c2);
        }
        return this.checkMatchTree(mid + 1, toIndex, c2);
    }

    @ExplodeLoop
    private int checkMatchLeaf(int iLeaf, int c2) {
        CompilerAsserts.partialEvaluationConstant(iLeaf);
        AllTransitionsInOneTreeLeafMatcher leafMatcher = this.leafMatchers[iLeaf];
        int lowByte = BitSets.lowByte(c2);
        for (int i2 = 0; i2 < leafMatcher.bitSets.length; ++i2) {
            CompilerAsserts.partialEvaluationConstant(i2);
            if (!BitSets.get(leafMatcher.bitSets[i2], lowByte)) continue;
            short successor = leafMatcher.successors[i2];
            CompilerAsserts.partialEvaluationConstant(successor);
            return successor;
        }
        return AllTransitionsInOneTreeMatcher.checkMatchLeafSubTree(leafMatcher, 0, leafMatcher.ranges.length - 1, c2);
    }

    private static int checkMatchLeafSubTree(AllTransitionsInOneTreeLeafMatcher leafMatcher, int fromIndex, int toIndex, int c2) {
        CompilerAsserts.partialEvaluationConstant(leafMatcher);
        CompilerAsserts.partialEvaluationConstant(fromIndex);
        CompilerAsserts.partialEvaluationConstant(toIndex);
        if (fromIndex > toIndex) {
            short successor = leafMatcher.successors[leafMatcher.bitSets.length + fromIndex];
            CompilerAsserts.partialEvaluationConstant(successor);
            if (successor == -1) {
                int lo = fromIndex == 0 ? 0 : leafMatcher.ranges[fromIndex - 1];
                int hi = fromIndex == leafMatcher.ranges.length ? 0x110000 : leafMatcher.ranges[fromIndex];
                CompilerAsserts.partialEvaluationConstant(lo);
                CompilerAsserts.partialEvaluationConstant(hi);
                return successor;
            }
            return successor;
        }
        int mid = fromIndex + toIndex >>> 1;
        CompilerAsserts.partialEvaluationConstant(mid);
        if (c2 < leafMatcher.ranges[mid]) {
            return AllTransitionsInOneTreeMatcher.checkMatchLeafSubTree(leafMatcher, fromIndex, mid - 1, c2);
        }
        return AllTransitionsInOneTreeMatcher.checkMatchLeafSubTree(leafMatcher, mid + 1, toIndex, c2);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        return "AllTransitionsInOneTreeMatcher: " + AllTransitionsInOneTreeMatcher.rangesToString(this.ranges);
    }

    @CompilerDirectives.TruffleBoundary
    private static String rangesToString(int[] ranges) {
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        for (int c2 : ranges) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (c2 > 255) {
                sb.append(String.format("%04x", c2));
                continue;
            }
            sb.append(String.format("%02x", c2));
        }
        sb.append("]");
        return sb.toString();
    }

    public static final class AllTransitionsInOneTreeLeafMatcher {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private final long[][] bitSets;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final short[] successors;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private final int[] ranges;

        public AllTransitionsInOneTreeLeafMatcher(long[][] bitSets, short[] successors, int[] ranges) {
            assert (successors.length == bitSets.length + ranges.length + 1);
            this.bitSets = bitSets;
            this.successors = successors;
            this.ranges = ranges;
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            StringBuilder sb = new StringBuilder("ranges: ").append(AllTransitionsInOneTreeMatcher.rangesToString(this.ranges)).append("\nbitsets:\n");
            for (int i2 = 0; i2 < this.bitSets.length; ++i2) {
                sb.append(BitSets.toString(this.bitSets[i2])).append("\n");
            }
            return sb.toString();
        }
    }
}

