/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa;

import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerAsserts;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.AllTransitionsInOneTreeMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.DFASimpleCG;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.DFASimpleCGTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.Matchers;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.SequentialMatchers;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.DebugUtil;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.Json;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonArray;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.json.JsonValue;

public class DFAStateNode
extends DFAAbstractStateNode {
    private static final byte FLAG_FINAL_STATE = 1;
    private static final byte FLAG_ANCHORED_FINAL_STATE = 2;
    private static final byte FLAG_HAS_BACKWARD_PREFIX_STATE = 4;
    private static final byte FLAG_UTF_16_MUST_DECODE = 8;
    private final byte flags;
    private final short loopTransitionIndex;
    private final short indexOfNodeId;
    private final byte indexOfIsFast;
    private final Matchers matchers;
    private final DFASimpleCG simpleCG;

    DFAStateNode(DFAStateNode nodeSplitCopy, short copyID) {
        this(copyID, nodeSplitCopy.flags, nodeSplitCopy.loopTransitionIndex, nodeSplitCopy.indexOfNodeId, nodeSplitCopy.indexOfIsFast, Arrays.copyOf(nodeSplitCopy.getSuccessors(), nodeSplitCopy.getSuccessors().length), nodeSplitCopy.getMatchers(), nodeSplitCopy.simpleCG);
    }

    public DFAStateNode(short id, byte flags, short loopTransitionIndex, short indexOfNodeId, byte indexOfIsFast, short[] successors, Matchers matchers, DFASimpleCG simpleCG) {
        super(id, successors);
        assert (id > 0);
        this.flags = flags;
        this.loopTransitionIndex = loopTransitionIndex;
        this.indexOfNodeId = indexOfNodeId;
        this.indexOfIsFast = indexOfIsFast;
        this.matchers = matchers;
        this.simpleCG = simpleCG;
    }

    public static byte buildFlags(boolean finalState, boolean anchoredFinalState, boolean hasBackwardPrefixState, boolean utf16MustDecode) {
        byte flags = 0;
        if (finalState) {
            flags = (byte)(flags | 1);
        }
        if (anchoredFinalState) {
            flags = (byte)(flags | 2);
        }
        if (hasBackwardPrefixState) {
            flags = (byte)(flags | 4);
        }
        if (utf16MustDecode) {
            flags = (byte)(flags | 8);
        }
        return flags;
    }

    @Override
    public DFAStateNode createNodeSplitCopy(short copyID) {
        return new DFAStateNode(this, copyID);
    }

    public final Matchers getMatchers() {
        return this.matchers;
    }

    public final SequentialMatchers getSequentialMatchers() {
        return (SequentialMatchers)this.matchers;
    }

    public boolean isFinalState() {
        return this.flagIsSet((byte)1);
    }

    public boolean isAnchoredFinalState() {
        return this.flagIsSet((byte)2);
    }

    public boolean hasBackwardPrefixState() {
        return this.flagIsSet((byte)4);
    }

    public boolean utf16MustDecode() {
        return this.flagIsSet((byte)8);
    }

    private boolean flagIsSet(byte flag) {
        return (this.flags & flag) != 0;
    }

    public boolean hasLoopToSelf() {
        return this.loopTransitionIndex >= 0;
    }

    boolean isLoopToSelf(int transitionIndex) {
        return this.hasLoopToSelf() && transitionIndex == this.getLoopToSelf();
    }

    short getLoopToSelf() {
        assert (this.hasLoopToSelf());
        return this.loopTransitionIndex;
    }

    boolean treeTransitionMatching() {
        return this.matchers instanceof AllTransitionsInOneTreeMatcher;
    }

    AllTransitionsInOneTreeMatcher getTreeMatcher() {
        return (AllTransitionsInOneTreeMatcher)this.matchers;
    }

    public boolean hasIndexOfNodeId() {
        return this.indexOfNodeId >= 0;
    }

    public int getIndexOfNodeId() {
        return this.indexOfNodeId;
    }

    boolean canDoIndexOf(TruffleString.CodeRange codeRange) {
        CompilerAsserts.partialEvaluationConstant((Object)codeRange);
        CompilerAsserts.partialEvaluationConstant(codeRange.ordinal());
        return this.hasLoopToSelf() && this.hasIndexOfNodeId() && (this.indexOfIsFast & 1 << codeRange.ordinal()) != 0;
    }

    void beforeFindSuccessor(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant(this);
        this.checkFinalState(locals, executor);
    }

    void afterIndexOf(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int preLoopIndex, int postLoopIndex, TruffleString.CodeRange codeRange) {
        locals.setIndex(postLoopIndex);
        if (this.simpleCG != null && locals.getIndex() > preLoopIndex) {
            int curIndex = locals.getIndex();
            executor.inputSkipReverse(locals, codeRange);
            this.applySimpleCGTransition(this.simpleCG.getTransitions()[this.getLoopToSelf()], executor, locals);
            locals.setIndex(curIndex);
        }
        this.checkFinalState(locals, executor);
    }

    private void checkFinalState(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant(this);
        CompilerAsserts.partialEvaluationConstant(this.simpleCG);
        if (this.isFinalState()) {
            if (this.simpleCG == null) {
                this.storeResult(locals, executor, false);
            } else if (!this.isAnchoredFinalState() || !executor.inputAtEnd(locals)) {
                this.storeResult(locals, executor, false);
                this.applySimpleCGFinalTransition(this.simpleCG.getTransitionToFinalState(), executor, locals);
            }
        }
    }

    void atEnd(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        boolean anchored;
        CompilerAsserts.partialEvaluationConstant(this);
        boolean bl = anchored = this.isAnchoredFinalState() && executor.inputAtEnd(locals);
        if (this.isFinalState() || anchored) {
            this.storeResult(locals, executor, anchored);
            if (this.simpleCG != null) {
                if (this.isAnchoredFinalState()) {
                    this.applySimpleCGFinalTransition(this.simpleCG.getTransitionToAnchoredFinalState(), executor, locals);
                } else if (this.isFinalState()) {
                    this.applySimpleCGFinalTransition(this.simpleCG.getTransitionToFinalState(), executor, locals);
                }
            }
        }
    }

    void successorFound(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, int i2) {
        if (this.simpleCG != null) {
            this.applySimpleCGTransition(this.simpleCG.getTransitions()[i2], executor, locals);
        }
    }

    void storeResult(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean anchored) {
        CompilerAsserts.partialEvaluationConstant(this);
        if (executor.isSimpleCG()) {
            if (executor.getProperties().isSimpleCGMustCopy()) {
                System.arraycopy(locals.getCGData().results, 0, locals.getCGData().currentResult, 0, locals.getCGData().currentResult.length);
            }
            locals.setResultInt(0);
        } else {
            locals.setResultInt(locals.getIndex());
        }
    }

    void applySimpleCGTransition(DFASimpleCGTransition transition, TRegexDFAExecutorNode executor, TRegexDFAExecutorLocals locals) {
        transition.apply(locals.getCGData().results, locals.getIndex(), executor.getProperties().tracksLastGroup());
    }

    void applySimpleCGFinalTransition(DFASimpleCGTransition transition, TRegexDFAExecutorNode executor, TRegexDFAExecutorLocals locals) {
        transition.applyFinal(locals.getCGData(), locals.getIndex(), executor.getProperties().isSimpleCGMustCopy(), executor.getProperties().tracksLastGroup());
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder();
        DebugUtil.appendNodeId(sb, this.getId()).append(": ");
        if (!this.treeTransitionMatching()) {
            sb.append(this.getSequentialMatchers().size()).append(" successors");
        }
        if (this.isAnchoredFinalState()) {
            sb.append(", AFS");
        }
        if (this.isFinalState()) {
            sb.append(", FS");
        }
        sb.append(":\n");
        if (this.treeTransitionMatching()) {
            sb.append("      ").append(this.getTreeMatcher()).append("\n      successors: ").append(Arrays.toString(this.successors)).append("\n");
        } else {
            for (int i2 = 0; i2 < this.getSequentialMatchers().size(); ++i2) {
                sb.append("      ").append(i2).append(": ").append(this.getSequentialMatchers().toString(i2)).append(" -> ");
                DebugUtil.appendNodeId(sb, this.getSuccessors()[i2]).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        JsonArray transitions = Json.array(new JsonConvertible[0]);
        if (this.matchers != null) {
            for (int i2 = 0; i2 < this.getSequentialMatchers().size(); ++i2) {
                transitions.append(Json.obj(Json.prop("matcher", this.getSequentialMatchers().toString(i2)), Json.prop("target", this.successors[i2])));
            }
        }
        return Json.obj(Json.prop("id", this.getId()), Json.prop("anchoredFinalState", this.isAnchoredFinalState()), Json.prop("finalState", this.isFinalState()), Json.prop("loopToSelf", this.hasLoopToSelf()), Json.prop("transitions", transitions));
    }
}

