/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.nfa;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.frame.VirtualFrame;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexRootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFA;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFAState;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.nfa.TRegexNFAExecutorLocals;

public final class TRegexNFAExecutorNode
extends TRegexExecutorNode {
    private final NFA nfa;
    private final boolean searching;
    private final boolean trackLastGroup;
    private boolean dfaGeneratorBailedOut;

    private TRegexNFAExecutorNode(NFA nfa, int numberOfTransitions) {
        super(nfa.getAst(), numberOfTransitions);
        this.nfa = nfa;
        this.searching = !nfa.getAst().getFlags().isSticky() && !nfa.getAst().getRoot().startsWithCaret() && nfa.getInitialLoopBackTransition() != null;
        this.trackLastGroup = nfa.getAst().getOptions().getFlavor().usesLastGroupResultField();
    }

    private TRegexNFAExecutorNode(TRegexNFAExecutorNode copy) {
        super(copy);
        this.nfa = copy.nfa;
        this.searching = copy.searching;
        this.trackLastGroup = copy.trackLastGroup;
        this.dfaGeneratorBailedOut = copy.dfaGeneratorBailedOut;
    }

    public static TRegexNFAExecutorNode create(NFA nfa) {
        nfa.setInitialLoopBack(false);
        int numberOfTransitions = 0;
        for (int i2 = 0; i2 < nfa.getNumberOfTransitions(); ++i2) {
            if (nfa.getTransitions()[i2] == null) continue;
            nfa.getTransitions()[i2].getGroupBoundaries().materializeArrays();
            ++numberOfTransitions;
        }
        return new TRegexNFAExecutorNode(nfa, numberOfTransitions);
    }

    @Override
    public TRegexNFAExecutorNode shallowCopy() {
        return new TRegexNFAExecutorNode(this);
    }

    public NFA getNFA() {
        return this.nfa;
    }

    public void notifyDfaGeneratorBailedOut() {
        this.dfaGeneratorBailedOut = true;
    }

    @Override
    public String getName() {
        return "nfa";
    }

    @Override
    public boolean isForward() {
        return true;
    }

    @Override
    public boolean isTrivial() {
        return false;
    }

    @Override
    public boolean writesCaptureGroups() {
        return true;
    }

    @Override
    public int getNumberOfStates() {
        return this.nfa.getNumberOfStates();
    }

    @Override
    public TRegexExecutorLocals createLocals(TruffleString input, int fromIndex, int maxIndex, int regionFrom, int regionTo, int index) {
        return new TRegexNFAExecutorLocals(input, fromIndex, maxIndex, regionFrom, regionTo, index, this.getNumberOfCaptureGroups(), this.nfa.getNumberOfStates(), this.trackLastGroup);
    }

    @Override
    public Object execute(VirtualFrame frame, TRegexExecutorLocals abstractLocals, TruffleString.CodeRange codeRange) {
        NFAState unAnchoredInitialState;
        TRegexNFAExecutorLocals locals = (TRegexNFAExecutorLocals)abstractLocals;
        CompilerDirectives.ensureVirtualized(locals);
        int offset = this.rewindUpTo(locals, locals.getRegionFrom(), this.nfa.getAnchoredEntry().length - 1, codeRange);
        NFAState anchoredInitialState = this.nfa.getAnchoredEntry()[offset] == null ? null : this.nfa.getAnchoredEntry()[offset].getTarget();
        NFAState nFAState = unAnchoredInitialState = this.nfa.getUnAnchoredEntry()[offset] == null ? null : this.nfa.getUnAnchoredEntry()[offset].getTarget();
        if (anchoredInitialState != unAnchoredInitialState && this.inputAtBegin(locals)) {
            locals.addInitialState(anchoredInitialState.getId());
        }
        if (unAnchoredInitialState != null) {
            locals.addInitialState(unAnchoredInitialState.getId());
        }
        if (locals.curStatesEmpty()) {
            return null;
        }
        while (true) {
            if (this.dfaGeneratorBailedOut && CompilerDirectives.hasNextTier()) {
                locals.incLoopCount(this);
            }
            if (CompilerDirectives.inInterpreter()) {
                RegexRootNode.checkThreadInterrupted();
            }
            if (CompilerDirectives.injectBranchProbability(0.99, this.inputHasNext(locals))) {
                this.findNextStates(locals, codeRange);
                if (CompilerDirectives.injectBranchProbability(0.010000000000000009, locals.successorsEmpty() && (!this.searching || locals.hasResult()))) {
                    return locals.getResult();
                }
            } else {
                this.findNextStatesAtEnd(locals);
                return locals.getResult();
            }
            locals.nextState();
            this.inputAdvance(locals);
        }
    }

    private void findNextStates(TRegexNFAExecutorLocals locals, TruffleString.CodeRange codeRange) {
        int c2 = this.inputReadAndDecode(locals, codeRange);
        while (CompilerDirectives.injectBranchProbability(0.99, locals.hasNext())) {
            this.expandState(locals, locals.next(), c2, false);
            if (!CompilerDirectives.injectBranchProbability(0.010000000000000009, locals.isResultPushed())) continue;
            return;
        }
        if (CompilerDirectives.injectBranchProbability(0.99, this.searching && !locals.hasResult() && locals.getIndex() > locals.getFromIndex())) {
            this.expandState(locals, this.nfa.getInitialLoopBackTransition().getTarget().getId(), c2, true);
        }
    }

    private void expandState(TRegexNFAExecutorLocals locals, int stateId, int c2, boolean isLoopBack) {
        NFAState state = this.nfa.getState(stateId);
        for (int i2 = 0; i2 < TRegexNFAExecutorNode.maxTransitionIndex(state); ++i2) {
            NFAStateTransition t2 = ((NFAStateTransition[])state.getSuccessors())[i2];
            int targetId = t2.getTarget().getId();
            int markIndex = targetId >> 6;
            long markBit = 1L << targetId;
            if (t2.getTarget().isAnchoredFinalState(true) || (locals.getMarks()[markIndex] & markBit) != 0L) continue;
            long[] lArray = locals.getMarks();
            int n2 = markIndex;
            lArray[n2] = lArray[n2] | markBit;
            if (t2.getTarget().isUnAnchoredFinalState(true)) {
                locals.pushResult(t2, !isLoopBack);
                continue;
            }
            if (!t2.getCodePointSet().contains(c2)) continue;
            locals.pushSuccessor(t2, !isLoopBack);
        }
    }

    private static int maxTransitionIndex(NFAState state) {
        return state.hasTransitionToUnAnchoredFinalState(true) ? state.getTransitionToUnAnchoredFinalStateId(true) + 1 : ((NFAStateTransition[])state.getSuccessors()).length;
    }

    private void findNextStatesAtEnd(TRegexNFAExecutorLocals locals) {
        while (CompilerDirectives.injectBranchProbability(0.99, locals.hasNext())) {
            TRegexNFAExecutorNode.expandStateAtEnd(locals, this.nfa.getState(locals.next()), false);
            if (!CompilerDirectives.injectBranchProbability(0.010000000000000009, locals.isResultPushed())) continue;
            return;
        }
        if (this.searching && CompilerDirectives.injectBranchProbability(0.99, !locals.hasResult() && locals.getIndex() > locals.getFromIndex())) {
            TRegexNFAExecutorNode.expandStateAtEnd(locals, this.nfa.getInitialLoopBackTransition().getTarget(), true);
        }
    }

    private static void expandStateAtEnd(TRegexNFAExecutorLocals locals, NFAState state, boolean isLoopBack) {
        if (state.hasTransitionToFinalState(true)) {
            locals.pushResult(state.getFirstTransitionToFinalState(true), !isLoopBack);
        }
    }
}

