/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.UnsupportedRegexException;

public class Counter {
    protected int count = 0;

    public int getCount() {
        return this.count;
    }

    public void reset() {
        this.count = 0;
    }

    public int inc() {
        return this.inc(1);
    }

    public int inc(int i2) {
        int ret = this.count;
        this.count += i2;
        return ret;
    }

    public int dec() {
        return this.dec(1);
    }

    public int dec(int i2) {
        int ret = this.count;
        this.count -= i2;
        return ret;
    }

    public static class ThreadSafeCounter
    extends Counter {
        @Override
        public int inc() {
            int c2 = this.count;
            if (c2 < Integer.MAX_VALUE) {
                this.count = c2 + 1;
            }
            return this.count;
        }

        @Override
        public int inc(int i2) {
            int c2 = this.count;
            if (c2 <= Integer.MAX_VALUE - i2) {
                this.count = c2 + i2;
            }
            return this.count;
        }

        @Override
        public int dec() {
            int c2 = this.count;
            if (c2 > Integer.MIN_VALUE) {
                this.count = c2 - 1;
            }
            return this.count;
        }

        @Override
        public int dec(int i2) {
            int c2 = this.count;
            if (c2 >= Integer.MIN_VALUE + i2) {
                this.count = c2 - i2;
            }
            return this.count;
        }
    }

    public static class ThresholdCounter
    extends Counter {
        private final int max;
        private final String errorMsg;

        public ThresholdCounter(int max, String errorMsg) {
            this.max = max;
            this.errorMsg = errorMsg;
        }

        @Override
        public int inc(int i2) {
            int ret = super.inc(i2);
            if (this.getCount() > this.max) {
                throw new UnsupportedRegexException(this.errorMsg);
            }
            return ret;
        }
    }
}

