/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexFlags;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSyntaxException;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.JSRegexLexer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.JSRegexParser;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexValidator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.Token;

public class JSRegexValidator
implements RegexValidator {
    private final RegexLanguage language;
    private final RegexSource source;
    private final RegexFlags flags;
    private final CompilationBuffer compilationBuffer;
    private final JSRegexLexer lexer;

    public JSRegexValidator(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        this.language = language;
        this.source = source;
        this.flags = RegexFlags.parseFlags(source);
        this.compilationBuffer = compilationBuffer;
        this.lexer = new JSRegexLexer(source, this.flags, compilationBuffer);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void validate() throws RegexSyntaxException {
        this.parseDryRun();
    }

    private void parseDryRun() throws RegexSyntaxException {
        ArrayList<RegexStackElem> syntaxStack = new ArrayList<RegexStackElem>();
        CurTermState curTermState = CurTermState.Null;
        block19: while (this.lexer.hasNext()) {
            Token token = this.lexer.next();
            switch (token.kind) {
                case caret: 
                case dollar: 
                case wordBoundary: 
                case nonWordBoundary: 
                case backReference: 
                case literalChar: 
                case charClass: 
                case charClassBegin: 
                case charClassAtom: 
                case charClassEnd: 
                case classSet: {
                    curTermState = CurTermState.Other;
                    continue block19;
                }
                case quantifier: {
                    switch (curTermState.ordinal()) {
                        case 0: {
                            throw this.syntaxError("Quantifier without target");
                        }
                        case 1: {
                            if (!this.flags.isEitherUnicode()) break;
                            throw this.syntaxError("Quantifier on lookahead assertion");
                        }
                        case 2: {
                            throw this.syntaxError("Quantifier on lookbehind assertion");
                        }
                    }
                    curTermState = CurTermState.Other;
                    continue block19;
                }
                case alternation: {
                    curTermState = CurTermState.Null;
                    continue block19;
                }
                case captureGroupBegin: 
                case nonCaptureGroupBegin: {
                    syntaxStack.add(RegexStackElem.Group);
                    curTermState = CurTermState.Null;
                    continue block19;
                }
                case lookAheadAssertionBegin: {
                    syntaxStack.add(RegexStackElem.LookAheadAssertion);
                    curTermState = CurTermState.Null;
                    continue block19;
                }
                case lookBehindAssertionBegin: {
                    syntaxStack.add(RegexStackElem.LookBehindAssertion);
                    curTermState = CurTermState.Null;
                    continue block19;
                }
                case groupEnd: {
                    if (syntaxStack.isEmpty()) {
                        throw this.syntaxError("Unmatched ')'");
                    }
                    RegexStackElem poppedElem = (RegexStackElem)((Object)syntaxStack.remove(syntaxStack.size() - 1));
                    switch (poppedElem.ordinal()) {
                        case 1: {
                            curTermState = CurTermState.LookAheadAssertion;
                            break;
                        }
                        case 2: {
                            curTermState = CurTermState.LookBehindAssertion;
                            break;
                        }
                        case 0: {
                            curTermState = CurTermState.Other;
                        }
                    }
                    continue block19;
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
        if (this.lexer.inCharacterClass()) {
            throw this.syntaxError("Unterminated character class");
        }
        if (!syntaxStack.isEmpty()) {
            throw this.syntaxError("Unterminated group");
        }
        this.checkNamedCaptureGroups();
    }

    private void checkNamedCaptureGroups() {
        if (this.lexer.getNamedCaptureGroups() != null) {
            for (Map.Entry<String, List<Integer>> entry : this.lexer.getNamedCaptureGroups().entrySet()) {
                if (entry.getValue().size() <= 1) continue;
                new JSRegexParser(this.language, this.source, this.compilationBuffer).parse();
                break;
            }
        }
    }

    private RegexSyntaxException syntaxError(String msg) {
        return RegexSyntaxException.createPattern(this.source, msg, this.lexer.getLastTokenPosition());
    }

    private static enum CurTermState {
        Null,
        LookAheadAssertion,
        LookBehindAssertion,
        Other;

    }

    private static enum RegexStackElem {
        Group,
        LookAheadAssertion,
        LookBehindAssertion;

    }
}

