/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser;

import java.util.function.Function;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.JSRegexParser;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.Group;

public final class RegexParserGlobals {
    private final Group jsWordBoundarySubstitution;
    private final Group jsNonWordBoundarySubstitution;
    private final Group jsUnicodeIgnoreCaseWordBoundarySubstitution;
    private final Group jsUnicodeIgnoreCaseNonWordBoundarySubsitution;
    private final Group jsMultiLineCaretSubstitution;
    private final Group jsMultiLineDollarSubsitution;
    private final Group jsNoLeadSurrogateBehind;
    private final Group jsNoTrailSurrogateAhead;

    public RegexParserGlobals(RegexLanguage language) {
        String wordBoundarySrc = "(?:^|(?<=\\W))(?=\\w)|(?<=\\w)(?:(?=\\W)|$)";
        String nonWordBoundarySrc = "(?:^|(?<=\\W))(?:(?=\\W)|$)|(?<=\\w)(?=\\w)";
        this.jsWordBoundarySubstitution = JSRegexParser.parseRootLess(language, "(?:^|(?<=\\W))(?=\\w)|(?<=\\w)(?:(?=\\W)|$)");
        this.jsNonWordBoundarySubstitution = JSRegexParser.parseRootLess(language, "(?:^|(?<=\\W))(?:(?=\\W)|$)|(?<=\\w)(?=\\w)");
        Function<String, String> includeExtraCases = s2 -> s2.replace("\\w", "[\\w\\u017F\\u212A]").replace("\\W", "[^\\w\\u017F\\u212A]");
        this.jsUnicodeIgnoreCaseWordBoundarySubstitution = JSRegexParser.parseRootLess(language, includeExtraCases.apply("(?:^|(?<=\\W))(?=\\w)|(?<=\\w)(?:(?=\\W)|$)"));
        this.jsUnicodeIgnoreCaseNonWordBoundarySubsitution = JSRegexParser.parseRootLess(language, includeExtraCases.apply("(?:^|(?<=\\W))(?:(?=\\W)|$)|(?<=\\w)(?=\\w)"));
        this.jsMultiLineCaretSubstitution = JSRegexParser.parseRootLess(language, "(?:^|(?<=[\\r\\n\\u2028\\u2029]))");
        this.jsMultiLineDollarSubsitution = JSRegexParser.parseRootLess(language, "(?:$|(?=[\\r\\n\\u2028\\u2029]))");
        this.jsNoLeadSurrogateBehind = JSRegexParser.parseRootLess(language, "(?:^|(?<=[^\\uD800-\\uDBFF]))");
        this.jsNoTrailSurrogateAhead = JSRegexParser.parseRootLess(language, "(?:$|(?=[^\\uDC00-\\uDFFF]))");
    }

    public Group getJsWordBoundarySubstitution() {
        return this.jsWordBoundarySubstitution;
    }

    public Group getJsNonWordBoundarySubstitution() {
        return this.jsNonWordBoundarySubstitution;
    }

    public Group getJsUnicodeIgnoreCaseWordBoundarySubstitution() {
        return this.jsUnicodeIgnoreCaseWordBoundarySubstitution;
    }

    public Group getJsUnicodeIgnoreCaseNonWordBoundarySubsitution() {
        return this.jsUnicodeIgnoreCaseNonWordBoundarySubsitution;
    }

    public Group getJsMultiLineCaretSubstitution() {
        return this.jsMultiLineCaretSubstitution;
    }

    public Group getJsMultiLineDollarSubsitution() {
        return this.jsMultiLineDollarSubsitution;
    }

    public Group getJsNoLeadSurrogateBehind() {
        return this.jsNoLeadSurrogateBehind;
    }

    public Group getJsNoTrailSurrogateAhead() {
        return this.jsNoTrailSurrogateAhead;
    }
}

