/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.flavors;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexLanguage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.RegexSource;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.UnicodeProperties;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.UnicodePropertyDataVersion;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexParser;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.RegexValidator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.flavors.PythonRegexParser;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.parser.flavors.RegexFlavor;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.Encodings;
import org.cyclops.integratedscripting.vendors.org.graalvm.shadowed.com.ibm.icu.lang.UCharacter;

public final class PythonFlavor
extends RegexFlavor {
    public static final PythonFlavor INSTANCE = new PythonFlavor();
    public static final UnicodeProperties UNICODE = new UnicodeProperties(UnicodePropertyDataVersion.UNICODE_15_1_0, 0);

    private PythonFlavor() {
        super(765);
    }

    @Override
    public RegexValidator createValidator(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RegexParser createParser(RegexLanguage language, RegexSource source, CompilationBuffer compilationBuffer) {
        return new PythonRegexParser(language, source, compilationBuffer);
    }

    @Override
    public RegexFlavor.EqualsIgnoreCasePredicate getEqualsIgnoreCasePredicate(RegexAST ast) {
        if (ast.getOptions().getEncoding() == Encodings.UTF_32) {
            return (codePointA, codePointB, altMode) -> UCharacter.toLowerCase(codePointA) == UCharacter.toLowerCase(codePointB);
        }
        assert (ast.getOptions().getEncoding() == Encodings.LATIN_1);
        return (a2, b2, altMode) -> CaseFoldData.CaseFoldUnfoldAlgorithm.Ascii.getEqualsPredicate().test(a2, b2);
    }

    @Override
    public CaseFoldData.CaseFoldAlgorithm getCaseFoldAlgorithm(RegexAST ast) {
        throw CompilerDirectives.shouldNotReachHere();
    }
}

