/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string;

import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.buffer.ByteArrayBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.AbstractStringBuffer;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.Encodings;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.StringLATIN1;

public final class StringBufferLATIN1
extends ByteArrayBuffer
implements AbstractStringBuffer {
    private final Encodings.Encoding encoding;

    public StringBufferLATIN1(Encodings.Encoding encoding) {
        this(16, encoding);
    }

    public StringBufferLATIN1(int capacity, Encodings.Encoding encoding) {
        super(capacity);
        assert (encoding == Encodings.LATIN_1 || encoding == Encodings.BYTES);
        this.encoding = encoding;
    }

    @Override
    public Encodings.Encoding getEncoding() {
        return this.encoding;
    }

    @Override
    public void append(int codepoint) {
        assert (codepoint <= Encodings.LATIN_1.getMaxValue());
        this.add((byte)codepoint);
    }

    @Override
    public void appendOR(int c1, int c2) {
        assert (c1 <= Encodings.LATIN_1.getMaxValue());
        assert (c2 <= Encodings.LATIN_1.getMaxValue());
        this.add((byte)(c1 | c2));
    }

    @Override
    public void appendXOR(int c1, int c2) {
        assert (c1 <= Encodings.LATIN_1.getMaxValue());
        assert (c2 <= Encodings.LATIN_1.getMaxValue());
        this.add((byte)(c1 ^ c2));
    }

    @Override
    public StringLATIN1 materialize() {
        return new StringLATIN1(this.toArray(), this.encoding);
    }
}

