/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string;

import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.AbstractString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.AbstractStringIterator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.Encodings;

public final class StringLATIN1
implements AbstractString {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final byte[] str;
    private final Encodings.Encoding encoding;

    public StringLATIN1(byte[] str, Encodings.Encoding encoding) {
        this.str = str;
        this.encoding = encoding;
    }

    @Override
    public int encodedLength() {
        return this.str.length;
    }

    @Override
    public Object content() {
        return this.str;
    }

    public String toString() {
        return this.defaultToString();
    }

    @Override
    public StringLATIN1 substring(int start, int end) {
        return new StringLATIN1(Arrays.copyOfRange(this.str, start, end), this.encoding);
    }

    @Override
    public boolean regionMatches(int offset, AbstractString other, int ooffset, int encodedLength) {
        byte[] o2 = ((StringLATIN1)other).str;
        if (offset + encodedLength > this.str.length || ooffset + encodedLength > o2.length) {
            return false;
        }
        for (int i2 = 0; i2 < encodedLength; ++i2) {
            if (this.str[offset + i2] == o2[ooffset + i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public TruffleString asTString() {
        return TruffleString.fromByteArrayUncached(this.str, 0, this.str.length, this.encoding.getTStringEncoding(), false);
    }

    @Override
    public TruffleString.WithMask asTStringMask(TruffleString pattern) {
        return TruffleString.WithMask.createUncached(pattern, this.str, this.encoding.getTStringEncoding());
    }

    @Override
    public AbstractStringIterator iterator() {
        return new StringLATIN1Iterator(this.str);
    }

    private static final class StringLATIN1Iterator
    extends AbstractStringIterator {
        private final byte[] str;

        private StringLATIN1Iterator(byte[] str) {
            this.str = str;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.str.length;
        }

        @Override
        public int nextInt() {
            return Byte.toUnsignedInt(this.str[this.i++]);
        }
    }
}

