/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string;

import java.util.Arrays;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.strings.TruffleString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.AbstractString;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.string.AbstractStringIterator;

public final class StringUTF32
implements AbstractString {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final int[] str;

    public StringUTF32(int[] str) {
        this.str = str;
    }

    @Override
    public int encodedLength() {
        return this.str.length;
    }

    @Override
    public Object content() {
        return this.str;
    }

    public String toString() {
        return this.defaultToString();
    }

    @Override
    public StringUTF32 substring(int start, int end) {
        return new StringUTF32(Arrays.copyOfRange(this.str, start, end));
    }

    @Override
    public boolean regionMatches(int offset, AbstractString other, int ooffset, int encodedLength) {
        int[] o2 = ((StringUTF32)other).str;
        if (offset + encodedLength > this.str.length || ooffset + encodedLength > o2.length) {
            return false;
        }
        for (int i2 = 0; i2 < encodedLength; ++i2) {
            if (this.str[offset + i2] == o2[ooffset + i2]) continue;
            return false;
        }
        return true;
    }

    @Override
    public TruffleString asTString() {
        return TruffleString.fromIntArrayUTF32Uncached(this.str, 0, this.str.length);
    }

    @Override
    public TruffleString.WithMask asTStringMask(TruffleString pattern) {
        return TruffleString.WithMask.createUTF32Uncached(pattern, this.str);
    }

    @Override
    public AbstractStringIterator iterator() {
        return new StringUTF32Iterator(this.str);
    }

    private static final class StringUTF32Iterator
    extends AbstractStringIterator {
        private final int[] str;

        private StringUTF32Iterator(int[] str) {
            this.str = str;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.str.length;
        }

        @Override
        public int nextInt() {
            return this.str[this.i++];
        }
    }
}

