/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.TruffleFile;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.automaton.BasicState;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.dfa.DFAGenerator;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.dfa.DFAStateNodeBuilder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.dfa.DFAStateTransitionBuilder;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.AnyMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.BitSetMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.EmptyMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.SingleCharMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.matchers.SingleRangeMatcher;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.DFAStateNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.nodes.dfa.SequentialMatchers;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util.DotExport;

public class DFAExport {
    @CompilerDirectives.TruffleBoundary
    public static void exportDot(DFAGenerator dfaGenerator, TruffleFile path, boolean shortLabels) {
        DFAStateNodeBuilder[] entryStates = dfaGenerator.getEntryStates();
        Map<DFAStateNodeBuilder, DFAStateNodeBuilder> stateMap = dfaGenerator.getStateMap();
        TreeSet<Integer> entryIDs = new TreeSet<Integer>();
        for (DFAStateNodeBuilder s3 : entryStates) {
            if (s3 == null) continue;
            entryIDs.add(s3.getId());
        }
        try (BufferedWriter writer = path.newBufferedWriter(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            String anchoredFinalStates;
            writer.write("digraph finite_state_machine {");
            writer.newLine();
            String finalStates = stateMap.values().stream().filter(DFAStateNodeBuilder::isUnAnchoredFinalState).map(s2 -> DotExport.escape(DFAExport.dotState(s2, shortLabels))).collect(Collectors.joining("\" \""));
            if (!finalStates.isEmpty()) {
                writer.write(String.format("    node [shape = doublecircle]; \"%s\";", finalStates));
                writer.newLine();
            }
            if (!(anchoredFinalStates = stateMap.values().stream().filter(BasicState::isAnchoredFinalState).map(s2 -> DotExport.escape(DFAExport.dotState(s2, shortLabels))).collect(Collectors.joining("\" \""))).isEmpty()) {
                writer.write(String.format("    node [shape = Mcircle]; \"%s\";", anchoredFinalStates));
                writer.newLine();
            }
            writer.write("    node [shape = circle];");
            writer.newLine();
            for (DFAStateNodeBuilder state : stateMap.values()) {
                if (entryIDs.contains(state.getId())) {
                    for (int i2 = 0; i2 < entryStates.length; ++i2) {
                        if (entryStates[i2] != state) continue;
                        String initStateLabel = i2 < entryStates.length / 2 ? "I^" + i2 : "I" + (i2 - entryStates.length / 2);
                        DotExport.printConnection(writer, initStateLabel, DFAExport.dotState(state, shortLabels), "");
                        break;
                    }
                }
                for (DFAStateTransitionBuilder t2 : (DFAStateTransitionBuilder[])state.getSuccessors()) {
                    DotExport.printConnection(writer, DFAExport.dotState(state, shortLabels), DFAExport.dotState(t2.getTarget(), shortLabels), t2.getCodePointSet().toString());
                }
            }
            writer.write("}");
            writer.newLine();
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    private static String dotState(DFAStateNodeBuilder state, boolean shortLabels) {
        return "S" + String.valueOf(shortLabels ? Integer.valueOf(state.getId()) : state.stateSetToString());
    }

    @CompilerDirectives.TruffleBoundary
    public static void exportUnitTest(DFAStateNode entry, DFAStateNode[] states) {
        System.out.printf("int initialState = %d;\n", entry.getId());
        System.out.printf("DFAStateNode[] states = createStates(%d);\n", states.length);
        for (DFAStateNode state : states) {
            int i2;
            System.out.printf("states[%d].setSuccessors(new int[] { %d", state.getId(), state.getSuccessors()[0]);
            for (i2 = 1; i2 < state.getSuccessors().length; ++i2) {
                System.out.printf(", %d", state.getSuccessors()[i2]);
            }
            System.out.println(" });");
            System.out.printf("states[%d].setMatchers(new ByteMatcher[] {\n    ", state.getId());
            DFAExport.printMatcher(((SequentialMatchers.SimpleSequentialMatchers)state.getSequentialMatchers()).getMatchers()[0]);
            for (i2 = 1; i2 < state.getSequentialMatchers().size(); ++i2) {
                System.out.print(",\n    ");
                DFAExport.printMatcher(((SequentialMatchers.SimpleSequentialMatchers)state.getSequentialMatchers()).getMatchers()[i2]);
            }
            System.out.println("\n});");
            if (!state.isFinalState()) continue;
            System.out.printf("states[%d].setFinalState();\n", state.getId());
        }
    }

    private static void printMatcher(CharMatcher matcher) {
        if (matcher instanceof EmptyMatcher) {
            System.out.print("EmptyByteMatcher.create()");
        }
        if (matcher instanceof SingleCharMatcher) {
            System.out.printf("SingleByteMatcher.create(0x%02x)", ((SingleCharMatcher)matcher).getChar());
        }
        if (matcher instanceof SingleRangeMatcher) {
            System.out.printf("RangeByteMatcher.create(0x%02x, 0x%02x)", ((SingleRangeMatcher)matcher).getLo(), ((SingleRangeMatcher)matcher).getHi());
        }
        if (matcher instanceof BitSetMatcher) {
            long[] words = ((BitSetMatcher)matcher).getBitSet();
            System.out.printf("MultiByteMatcher.create(new CompilationFinalBitSet(new long[] {\n        0x%016xL", words[0]);
            for (int i2 = 1; i2 < words.length; ++i2) {
                System.out.printf(", 0x%016xL", words[i2]);
            }
            System.out.print("}))");
        }
        if (matcher instanceof AnyMatcher) {
            System.out.print("AnyByteMatcher.create()");
        }
    }
}

