/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.tregex.util;

import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.Constants;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.charset.SortedListOfRanges;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TBitSet;

public class DebugUtil {
    private static final TBitSet validSpecialCharsForFileNames = TBitSet.valueOf(36, 40, 41, 42, 43, 45, 46, 63, 91, 93, 94, 123, 124, 125);
    private static final Pattern specialChars = Pattern.compile("[\"\\\\\u0000-\u001f\u007f-\u009f]");

    @CompilerDirectives.TruffleBoundary
    public static String charToString(int c2) {
        if (Constants.WORD_CHARS.contains(c2)) {
            return String.valueOf((char)c2);
        }
        if (c2 <= 255) {
            return String.format("\\x%02x", c2);
        }
        if (c2 <= 65535) {
            return String.format("\\u%04x", c2);
        }
        return String.format("\\u{%06x}", c2);
    }

    @CompilerDirectives.TruffleBoundary
    public static String escapeString(String s2) {
        StringBuilder ret = new StringBuilder();
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            ret.append(DebugUtil.charToString(s2.charAt(i2)));
        }
        return ret.toString();
    }

    public static String regexSourceEscape(String pattern, String flags) {
        StringBuilder sb = new StringBuilder(pattern.length() + 2);
        sb.append('/');
        for (int i2 = 0; i2 < pattern.length(); ++i2) {
            int c2 = pattern.codePointAt(i2);
            if (32 <= c2 && c2 <= 126) {
                sb.appendCodePoint(c2);
                continue;
            }
            sb.append("\\u");
            if (c2 > 65535) {
                ++i2;
                sb.append(String.format("{%06x}", c2));
                continue;
            }
            sb.append(String.format("%04x", c2));
        }
        return sb.append('/').append(flags).toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static StringBuilder appendNodeId(StringBuilder sb, int id) {
        return sb.append(DebugUtil.nodeID(id));
    }

    @CompilerDirectives.TruffleBoundary
    public static String nodeID(int id) {
        return String.format("%04x", id);
    }

    @CompilerDirectives.TruffleBoundary
    public static String jsStringEscape(String str) {
        StringBuffer escapedString = new StringBuffer();
        Matcher m2 = specialChars.matcher(str);
        while (m2.find()) {
            char c2 = str.charAt(m2.start());
            m2.appendReplacement(escapedString, switch (c2) {
                case '\"' -> "\\\\\"";
                case '\\' -> "\\\\\\\\";
                case '\r' -> "\\\\r";
                case '\n' -> "\\\\n";
                case '\t' -> "\\\\t";
                default -> {
                    if (!$assertionsDisabled && !Character.isISOControl(c2)) {
                        throw new AssertionError();
                    }
                    yield String.format("\\\\u%04x", c2);
                }
            });
        }
        m2.appendTail(escapedString);
        return escapedString.toString();
    }

    @CompilerDirectives.TruffleBoundary
    public static String randomJsStringFromRanges(SortedListOfRanges ranges, int length) {
        Random random = new Random(System.currentTimeMillis());
        StringBuilder stringBuilder = new StringBuilder(length);
        for (int i2 = 0; i2 < length; ++i2) {
            int hi;
            int rangeIndex = random.nextInt(ranges.size());
            int lo = ranges.getLo(rangeIndex);
            int randChar = lo + random.nextInt((hi = ranges.getHi(rangeIndex)) + 1 - lo);
            if (randChar == 34) {
                stringBuilder.append("\\\\\"");
                continue;
            }
            if (randChar == 92) {
                stringBuilder.append("\\\\\\\\");
                continue;
            }
            if (randChar > 65535) {
                stringBuilder.append(String.format("\\u{%06x}", randChar));
                continue;
            }
            if (randChar > 127 || Character.isISOControl(randChar)) {
                stringBuilder.append(String.format("\\u%04x", randChar));
                continue;
            }
            stringBuilder.append(randChar);
        }
        return stringBuilder.toString();
    }

    public static boolean isValidCharForFileName(int c2) {
        return Character.isLetterOrDigit(c2) || validSpecialCharsForFileNames.get(c2);
    }

    public static class Timer {
        private long startTime = 0L;

        public void start() {
            this.startTime = System.nanoTime();
        }

        public long getElapsed() {
            return System.nanoTime() - this.startTime;
        }

        public String elapsedToString() {
            return Timer.elapsedToString(this.getElapsed());
        }

        public static String elapsedToString(long elapsed) {
            return String.format("%fms", (double)elapsed / 1000000.0);
        }
    }
}

