/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util;

import java.util.List;
import java.util.Map;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.interop.InteropLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportLibrary;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.library.ExportMessage;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.AbstractRegexObject;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.regex.util.TruffleOrderedReadOnlyKeysArray;

@ExportLibrary(value=InteropLibrary.class)
public final class TruffleSmallReadOnlyStringToIntMap
extends AbstractRegexObject {
    public static final int MAX_SIZE = 8;
    private final TruffleOrderedReadOnlyKeysArray keys;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final String[] map;

    private TruffleSmallReadOnlyStringToIntMap(String[] keys, String[] map) {
        this.keys = new TruffleOrderedReadOnlyKeysArray(keys);
        this.map = map;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean canCreate(Map<String, List<Integer>> map) {
        return TruffleSmallReadOnlyStringToIntMap.maxValue(map) < 8;
    }

    @CompilerDirectives.TruffleBoundary
    public static TruffleSmallReadOnlyStringToIntMap create(Map<String, List<Integer>> argMap) {
        String[] keys = new String[argMap.size()];
        String[] map = new String[TruffleSmallReadOnlyStringToIntMap.maxValue(argMap) + 1];
        assert (map.length <= 8);
        int i2 = 0;
        for (Map.Entry<String, List<Integer>> entry : argMap.entrySet()) {
            keys[i2++] = entry.getKey();
            assert (entry.getValue().size() == 1);
            assert (map[entry.getValue().get(0)] == null);
            map[entry.getValue().get((int)0).intValue()] = entry.getKey();
        }
        return new TruffleSmallReadOnlyStringToIntMap(keys, map);
    }

    @CompilerDirectives.TruffleBoundary
    private static int maxValue(Map<String, List<Integer>> map) {
        int max = 0;
        for (List<Integer> groups : map.values()) {
            assert (groups.size() == 1);
            max = Math.max(max, groups.get(0));
        }
        return max;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return this.keys;
    }

    @ExportMessage
    boolean isMemberReadable(String symbol) {
        return this.keys.contains(symbol);
    }

    @ExportMessage
    int readMember(String symbol) {
        for (int i2 = 0; i2 < this.map.length; ++i2) {
            if (this.map[i2] == null || !this.map[i2].equals(symbol)) continue;
            return i2;
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    public String toString() {
        return "TRegexReadOnlyMap";
    }
}

