/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.debug;

import java.util.Map;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.RootNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.source.SourceSection;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedCallTarget;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedDirectCallNode;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.OptimizedTruffleRuntimeListener;

public final class TraceSplittingListener
implements OptimizedTruffleRuntimeListener {
    private int splitCount;

    private TraceSplittingListener() {
    }

    public static void install(OptimizedTruffleRuntime runtime) {
        runtime.addListener(new TraceSplittingListener());
    }

    @Override
    public void onCompilationSplit(OptimizedDirectCallNode callNode) {
        OptimizedCallTarget callTarget = callNode.getCallTarget();
        if (callTarget.getOptionValue(OptimizedRuntimeOptions.TraceSplitting).booleanValue()) {
            String label = String.format("split %3s-%08x-%-4s ", this.splitCount++, 0xFFFFFFFFL & (long)callNode.getCurrentCallTarget().hashCode(), callNode.getCallCount());
            Map<String, Object> debugProperties = callTarget.getDebugProperties();
            debugProperties.put("SourceSection", TraceSplittingListener.extractSourceSection(callNode));
            OptimizedTruffleRuntime.getRuntime().logEvent(callTarget, 0, label, debugProperties);
        }
    }

    @Override
    public void onCompilationSplitFailed(OptimizedDirectCallNode callNode, CharSequence reason) {
        OptimizedCallTarget callTarget = callNode.getCallTarget();
        if (callTarget.getOptionValue(OptimizedRuntimeOptions.TraceSplitting).booleanValue()) {
            String label = String.format("split failed " + String.valueOf(reason), new Object[0]);
            Map<String, Object> debugProperties = callTarget.getDebugProperties();
            debugProperties.put("SourceSection", TraceSplittingListener.extractSourceSection(callNode));
            OptimizedTruffleRuntime.getRuntime().logEvent(callTarget, 0, label, debugProperties);
        }
    }

    private static String extractSourceSection(OptimizedDirectCallNode node) {
        Node cnode = node;
        while (cnode.getSourceSection() == null && !(cnode instanceof RootNode)) {
            if ((cnode = cnode.getParent()) != null) continue;
            return "";
        }
        return TraceSplittingListener.getShortDescription(cnode.getSourceSection());
    }

    static String getShortDescription(SourceSection sourceSection) {
        if (sourceSection == null) {
            return "<Unknown>";
        }
        StringBuilder b2 = new StringBuilder();
        if (sourceSection.getSource().getPath() == null) {
            b2.append(sourceSection.getSource().getName());
        } else {
            b2.append(sourceSection.getSource().getPath());
        }
        b2.append("~").append(TraceSplittingListener.formatIndices(sourceSection, true));
        return b2.toString();
    }

    static String formatIndices(SourceSection sourceSection, boolean needsColumnSpecifier) {
        boolean singleLine;
        StringBuilder b2 = new StringBuilder();
        boolean bl = singleLine = sourceSection.getStartLine() == sourceSection.getEndLine();
        if (singleLine) {
            b2.append(sourceSection.getStartLine());
        } else {
            b2.append(sourceSection.getStartLine()).append("-").append(sourceSection.getEndLine());
        }
        if (needsColumnSpecifier) {
            b2.append(":");
            if (sourceSection.getCharLength() <= 1) {
                b2.append(sourceSection.getCharIndex());
            } else {
                b2.append(sourceSection.getCharIndex()).append("-").append(sourceSection.getCharIndex() + sourceSection.getCharLength() - 1);
            }
        }
        return b2.toString();
    }
}

