/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot;

import jdk.internal.access.JavaLangAccess;
import jdk.internal.access.SharedSecrets;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.CompilerDirectives;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.impl.ThreadLocalHandshake;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.api.nodes.Node;
import org.cyclops.integratedscripting.vendors.com.oracle.truffle.runtime.hotspot.HotSpotTruffleRuntime;
import sun.misc.Unsafe;

final class HotSpotThreadLocalHandshake
extends ThreadLocalHandshake {
    private static final Unsafe UNSAFE = HotSpotTruffleRuntime.UNSAFE;
    private static final JavaLangAccess JAVA_LANG_ACCESS = SharedSecrets.getJavaLangAccess();
    static final HotSpotThreadLocalHandshake SINGLETON = new HotSpotThreadLocalHandshake();
    private static final ThreadLocal<ThreadLocalHandshake.TruffleSafepointImpl> STATE = new ThreadLocal();
    private static final int PENDING_OFFSET = HotSpotTruffleRuntime.getRuntime().getJVMCIReservedLongOffset0();
    private static final long THREAD_EETOP_OFFSET;
    private static final long THREAD_CARRIER_THREAD_OFFSET;

    HotSpotThreadLocalHandshake() {
    }

    @Override
    protected boolean isSupported() {
        return true;
    }

    @Override
    public void ensureThreadInitialized() {
        STATE.set(this.getThreadState(Thread.currentThread()));
    }

    @Override
    public void poll(Node enclosingNode) {
        Thread carrierThread = JAVA_LANG_ACCESS.currentCarrierThread();
        long eetop = UNSAFE.getLong(carrierThread, THREAD_EETOP_OFFSET);
        if (UNSAFE.getInt(null, eetop + (long)PENDING_OFFSET) != 0) {
            this.processHandshake(enclosingNode);
        }
    }

    static void doHandshake(Object node) {
        SINGLETON.processHandshake((Node)node);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public ThreadLocalHandshake.TruffleSafepointImpl getCurrent() {
        ThreadLocalHandshake.TruffleSafepointImpl state = STATE.get();
        if (state == null) {
            throw CompilerDirectives.shouldNotReachHere("Thread local handshake is not initialized for this thread. Did you call getCurrent() outside while a polyglot context not entered?");
        }
        return state;
    }

    @Override
    protected void clearFastPending() {
        Thread carrierThread = JAVA_LANG_ACCESS.currentCarrierThread();
        long eetop = UNSAFE.getLongVolatile(carrierThread, THREAD_EETOP_OFFSET);
        UNSAFE.putIntVolatile(null, eetop + (long)PENDING_OFFSET, 0);
    }

    @Override
    protected void setFastPending(Thread thread) {
        assert (thread.isAlive()) : "thread must remain alive while setting the pending flag";
        long eetop = UNSAFE.getLongVolatile(thread, THREAD_EETOP_OFFSET);
        if (eetop != 0L) {
            UNSAFE.putIntVolatile(null, eetop + (long)PENDING_OFFSET, 1);
        } else {
            Object carrierThread = UNSAFE.getObjectVolatile(thread, THREAD_CARRIER_THREAD_OFFSET);
            if (carrierThread == null) {
                return;
            }
            eetop = UNSAFE.getLongVolatile(carrierThread, THREAD_EETOP_OFFSET);
            UNSAFE.putIntVolatile(null, eetop + (long)PENDING_OFFSET, 1);
        }
    }

    static void setPendingFlagForVirtualThread() {
        ThreadLocalHandshake.TruffleSafepointImpl safepoint = STATE.get();
        if (safepoint != null) {
            Thread carrierThread = JAVA_LANG_ACCESS.currentCarrierThread();
            long eetop = UNSAFE.getLongVolatile(carrierThread, THREAD_EETOP_OFFSET);
            boolean pendingBefore = safepoint.isFastPendingSet();
            UNSAFE.putIntVolatile(null, eetop + (long)PENDING_OFFSET, pendingBefore ? 1 : 0);
            boolean pendingAfter = safepoint.isFastPendingSet();
            if (!pendingBefore && pendingAfter) {
                UNSAFE.putIntVolatile(null, eetop + (long)PENDING_OFFSET, 1);
            }
        }
    }

    static {
        try {
            THREAD_EETOP_OFFSET = HotSpotTruffleRuntime.getObjectFieldOffset(Thread.class.getDeclaredField("eetop"));
            Class<?> virtualThreadClass = Class.forName("java.lang.VirtualThread");
            THREAD_CARRIER_THREAD_OFFSET = HotSpotTruffleRuntime.getObjectFieldOffset(virtualThreadClass.getDeclaredField("carrierThread"));
        }
        catch (Exception e2) {
            throw new InternalError(e2);
        }
    }
}

