/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.compiler;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.function.Supplier;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.SpeculationLog;

public interface TruffleCompilable {
    public JavaConstant asJavaConstant();

    public SpeculationLog getCompilationSpeculationLog();

    public void onCompilationFailed(Supplier<String> var1, boolean var2, boolean var3, boolean var4, boolean var5);

    public boolean onInvalidate(Object var1, CharSequence var2, boolean var3);

    public String getName();

    public int getNonTrivialNodeCount();

    public int countDirectCallNodes();

    public int getCallCount();

    public boolean cancelCompilation(CharSequence var1);

    public boolean isSameOrSplit(TruffleCompilable var1);

    public int getKnownCallSiteCount();

    public void prepareForCompilation();

    public static String serializeException(Throwable e2) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Class<?> c2 = e2.getClass(); c2 != Throwable.class; c2 = c2.getSuperclass()) {
            pw.print(c2.getName() + ":");
        }
        pw.print('\n');
        e2.printStackTrace(pw);
        return sw.toString();
    }

    public boolean isTrivial();

    public long engineId();

    public Map<String, String> getCompilerOptions();
}

