/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.WeakMapPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.helper.CanBeHeldWeaklyNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSWeakMap;
import com.oracle.truffle.js.runtime.builtins.JSWeakMapObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.WeakMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class WeakMapPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<WeakMapPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new WeakMapPrototypeBuiltins();

    protected WeakMapPrototypeBuiltins() {
        super(JSWeakMap.PROTOTYPE_NAME, WeakMapPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, WeakMapPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapDeleteNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapSetNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 2: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapGetNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 3: {
                return WeakMapPrototypeBuiltinsFactory.JSWeakMapHasNodeGen.create(context, builtin, WeakMapPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    protected static RuntimeException typeErrorKeyIsNotValid() {
        throw Errors.createTypeError("Invalid value used as weak map key");
    }

    protected static RuntimeException typeErrorWeakMapExpected() {
        throw Errors.createTypeError("WeakMap expected");
    }

    public static enum WeakMapPrototype implements BuiltinEnum<WeakMapPrototype>
    {
        delete(1),
        set(2),
        get(1),
        has(1);

        private final int length;

        private WeakMapPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSWeakMapDeleteNode
    extends JSWeakMapBaseNode {
        public JSWeakMapDeleteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean deleteJSObject(JSWeakMapObject thisObj, JSObject key, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedGetter, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Object inverted = JSWeakMapDeleteNode.getInvertedMap(key, invertedGetter);
            if (hasInvertedProfile.profile(this, inverted != null)) {
                WeakHashMap<WeakMap, Object> invertedMap = JSWeakMapDeleteNode.castWeakHashMap(inverted);
                return Boundaries.mapRemove(invertedMap, map) != null;
            }
            return false;
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"})
        protected boolean deleteSymbol(JSWeakMapObject thisObj, Symbol key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Map<WeakMap, Object> invertedMap = key.getInvertedMap();
            if (hasInvertedProfile.profile(this, invertedMap != null)) {
                return Boundaries.mapRemove(invertedMap, map) != null;
            }
            return false;
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"})
        protected static boolean deleteInvalidKey(JSWeakMapObject thisObj, Object key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            return false;
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static boolean notWeakMap(Object thisObj, Object key) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSWeakMapSetNode
    extends JSWeakMapBaseNode {
        public JSWeakMapSetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object setJSObject(JSWeakMapObject thisObj, JSObject key, Object value, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedGetter, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedSetter, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Object inverted = JSWeakMapSetNode.getInvertedMap(key, invertedGetter);
            if (hasInvertedProfile.profile(this, inverted != null)) {
                WeakHashMap<WeakMap, Object> invertedMap = JSWeakMapSetNode.castWeakHashMap(inverted);
                JSWeakMapSetNode.mapPut(invertedMap, map, value);
            } else {
                Map<WeakMap, Object> newInvertedMap = map.newInvertedMapWithEntry(key, value);
                invertedSetter.put(key, WeakMap.INVERTED_WEAK_MAP_KEY, newInvertedMap);
            }
            return thisObj;
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"})
        protected Object setSymbol(JSWeakMapObject thisObj, Symbol key, Object value, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Map<WeakMap, Object> invertedMap = key.getInvertedMap();
            if (hasInvertedProfile.profile(this, invertedMap != null)) {
                Boundaries.mapPut(invertedMap, map, value);
            } else {
                Map<WeakMap, Object> newInvertedMap = map.newInvertedMapWithEntry(key, value);
                key.setInvertedMap(newInvertedMap);
            }
            return thisObj;
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"})
        protected static Object setInvalidKey(JSWeakMapObject thisObj, Object key, Object value, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            throw WeakMapPrototypeBuiltins.typeErrorKeyIsNotValid();
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static Object notWeakMap(Object thisObj, Object key, Object value) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static Object mapPut(WeakHashMap<WeakMap, Object> invertedMap, WeakMap map, Object value) {
            return invertedMap.put(map, value);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSWeakMapGetNode
    extends JSWeakMapBaseNode {
        public JSWeakMapGetNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object getJSObject(JSWeakMapObject thisObj, JSObject key, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedGetter, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakHashMap<WeakMap, Object> invertedMap;
            Object value;
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Object inverted = JSWeakMapGetNode.getInvertedMap(key, invertedGetter);
            if (hasInvertedProfile.profile(this, inverted != null) && (value = JSWeakMapGetNode.mapGet(invertedMap = JSWeakMapGetNode.castWeakHashMap(inverted), map)) != null) {
                return value;
            }
            return Undefined.instance;
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"})
        protected Object getSymbol(JSWeakMapObject thisObj, Symbol key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            Object value;
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Map<WeakMap, Object> invertedMap = key.getInvertedMap();
            if (hasInvertedProfile.profile(this, invertedMap != null) && (value = Boundaries.mapGet(invertedMap, map)) != null) {
                return value;
            }
            return Undefined.instance;
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"})
        protected static Object getInvalidKey(JSWeakMapObject thisObj, Object key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            return Undefined.instance;
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static Object notWeakMap(Object thisObj, Object key) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static Object mapGet(WeakHashMap<WeakMap, Object> invertedMap, WeakMap map) {
            return invertedMap.get(map);
        }
    }

    @ImportStatic(value={JSConfig.class})
    public static abstract class JSWeakMapHasNode
    extends JSWeakMapBaseNode {
        public JSWeakMapHasNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean hasJSObject(JSWeakMapObject thisObj, JSObject key, @CachedLibrary(limit="PropertyCacheLimit") DynamicObjectLibrary invertedGetter, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Object inverted = JSWeakMapHasNode.getInvertedMap(key, invertedGetter);
            if (hasInvertedProfile.profile(this, inverted != null)) {
                WeakHashMap<WeakMap, Object> invertedMap = JSWeakMapHasNode.castWeakHashMap(inverted);
                return JSWeakMapHasNode.mapHas(invertedMap, map);
            }
            return false;
        }

        @Specialization(guards={"canBeHeldWeakly.execute(this, key)"})
        protected boolean hasSymbol(JSWeakMapObject thisObj, Symbol key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly, @Cached @Cached.Shared InlinedConditionProfile hasInvertedProfile) {
            WeakMap map = (WeakMap)thisObj.getWeakHashMap();
            Map<WeakMap, Object> invertedMap = key.getInvertedMap();
            if (hasInvertedProfile.profile(this, invertedMap != null)) {
                return Boundaries.mapContainsKey(invertedMap, map);
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static boolean mapHas(WeakHashMap<WeakMap, Object> invertedMap, WeakMap map) {
            return invertedMap.containsKey(map);
        }

        @Specialization(guards={"!canBeHeldWeakly.execute(this, key)"})
        protected static boolean hasInvalidKey(JSWeakMapObject thisObj, Object key, @Cached @Cached.Shared CanBeHeldWeaklyNode canBeHeldWeakly) {
            return false;
        }

        @Specialization(guards={"!isJSWeakMap(thisObj)"})
        protected static boolean notWeakMap(Object thisObj, Object key) {
            throw WeakMapPrototypeBuiltins.typeErrorWeakMapExpected();
        }
    }

    protected static abstract class JSWeakMapBaseNode
    extends JSBuiltinNode {
        protected JSWeakMapBaseNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        protected static Object getInvertedMap(JSObject key, DynamicObjectLibrary library) {
            return library.getOrDefault(key, WeakMap.INVERTED_WEAK_MAP_KEY, null);
        }

        protected static WeakHashMap<WeakMap, Object> castWeakHashMap(Object map) {
            return CompilerDirectives.castExact(map, WeakHashMap.class);
        }
    }
}

