/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.testing;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.testing.PolyglotInternalBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.ImportValueNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.interop.JSInteropUtil;
import com.oracle.truffle.js.runtime.objects.Null;

public final class PolyglotInternalBuiltins
extends JSBuiltinsContainer.SwitchEnum<PolyglotInternal> {
    public static final JSBuiltinsContainer BUILTINS = new PolyglotInternalBuiltins();

    protected PolyglotInternalBuiltins() {
        super(JSRealm.POLYGLOT_CLASS_NAME, PolyglotInternal.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, PolyglotInternal builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return PolyglotInternalBuiltinsFactory.PolyglotIsExecutableNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 1: {
                return PolyglotInternalBuiltinsFactory.PolyglotIsBoxedPrimitiveNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 2: {
                return PolyglotInternalBuiltinsFactory.PolyglotIsNullNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 15: {
                return PolyglotInternalBuiltinsFactory.PolyglotIsInstantiableNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 3: {
                return PolyglotInternalBuiltinsFactory.PolyglotHasSizeNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 4: {
                return PolyglotInternalBuiltinsFactory.PolyglotReadNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 5: {
                return PolyglotInternalBuiltinsFactory.PolyglotWriteNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(3).createArgumentNodes(context));
            }
            case 10: {
                return PolyglotInternalBuiltinsFactory.PolyglotRemoveNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 6: {
                return PolyglotInternalBuiltinsFactory.PolyglotUnboxValueNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 7: {
                return PolyglotInternalBuiltinsFactory.PolyglotConstructNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case 8: {
                return PolyglotInternalBuiltinsFactory.PolyglotExecuteNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).varArgs().createArgumentNodes(context));
            }
            case 9: {
                return PolyglotInternalBuiltinsFactory.PolyglotGetSizeNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 13: {
                return PolyglotInternalBuiltinsFactory.PolyglotKeysNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 11: {
                return PolyglotInternalBuiltinsFactory.PolyglotToJSValueNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 12: {
                return PolyglotInternalBuiltinsFactory.PolyglotToPolyglotValueNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
            case 14: {
                return PolyglotInternalBuiltinsFactory.PolyglotHasKeysNodeGen.create(context, builtin, PolyglotInternalBuiltins.args().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum PolyglotInternal implements BuiltinEnum<PolyglotInternal>
    {
        isExecutable(1),
        isBoxed(1),
        isNull(1),
        hasSize(1),
        read(2),
        write(3),
        unbox(1),
        construct(1),
        execute(1),
        getSize(1),
        remove(2),
        toJSValue(1),
        toPolyglotValue(1),
        keys(1),
        hasKeys(1),
        isInstantiable(1);

        private final int length;

        private PolyglotInternal(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotIsExecutableNode
    extends JSBuiltinNode {
        PolyglotIsExecutableNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static boolean truffleObject(TruffleObject obj, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            return interop.isExecutable(obj);
        }

        @Specialization(guards={"isJavaPrimitive(obj)"})
        protected static boolean primitive(Object obj) {
            return false;
        }

        @Specialization(guards={"!isTruffleObject(obj)", "!isJavaPrimitive(obj)"})
        protected static boolean unsupported(Object obj) {
            return false;
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotIsBoxedPrimitiveNode
    extends JSBuiltinNode {
        PolyglotIsBoxedPrimitiveNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization(limit="InteropLibraryLimit")
        protected static boolean truffleObject(TruffleObject obj, @CachedLibrary(value="obj") InteropLibrary interop) {
            return JSInteropUtil.isBoxedPrimitive(obj, interop);
        }

        @Specialization(guards={"isJavaPrimitive(obj)"})
        protected static boolean primitive(Object obj) {
            return false;
        }

        @Specialization(guards={"!isTruffleObject(obj)", "!isJavaPrimitive(obj)"})
        protected static boolean unsupported(Object obj) {
            return false;
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotIsNullNode
    extends JSBuiltinNode {
        PolyglotIsNullNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static boolean truffleObject(TruffleObject obj, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            return interop.isNull(obj);
        }

        @Specialization(guards={"isJavaPrimitive(obj)"})
        protected static boolean primitive(Object obj) {
            return false;
        }

        @Specialization(guards={"!isTruffleObject(obj)", "!isJavaPrimitive(obj)"})
        protected static boolean unsupported(Object obj) {
            return false;
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotIsInstantiableNode
    extends JSBuiltinNode {
        PolyglotIsInstantiableNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected static boolean isInstantiable(TruffleObject obj, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            return interop.isInstantiable(obj);
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected static boolean unsupported(Object obj) {
            return false;
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotHasSizeNode
    extends JSBuiltinNode {
        PolyglotHasSizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean truffleObject(TruffleObject obj, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            return interop.hasArrayElements(obj);
        }

        @Specialization(guards={"isJavaPrimitive(obj)"})
        protected boolean primitive(Object obj) {
            return false;
        }

        @Specialization(guards={"!isTruffleObject(obj)", "!isJavaPrimitive(obj)"})
        protected boolean unsupported(Object obj) {
            return false;
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotReadNode
    extends JSBuiltinNode {
        PolyglotReadNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object member(TruffleObject obj, TruffleString name, @Cached.Shared @Cached ImportValueNode foreignConvert, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            return JSInteropUtil.readMemberOrDefault(obj, name, Null.instance, interop, foreignConvert);
        }

        @Specialization
        protected Object arrayElementInt(TruffleObject obj, int index, @Cached.Shared @Cached ImportValueNode foreignConvert, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            return JSInteropUtil.readArrayElementOrDefault(obj, index, Null.instance, interop, foreignConvert);
        }

        @Specialization(guards={"isNumber(index)"}, replaces={"arrayElementInt"})
        protected Object arrayElement(TruffleObject obj, Number index, @Cached.Shared @Cached ImportValueNode foreignConvert, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            return JSInteropUtil.readArrayElementOrDefault(obj, JSRuntime.longValue(index), Null.instance, interop, foreignConvert);
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isString(key)", "!isNumber(key)"})
        protected Object unsupportedKey(TruffleObject obj, Object key, @Cached.Shared @Cached ImportValueNode foreignConvert, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached.Exclusive @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary keyInterop, @Cached TruffleString.SwitchEncodingNode switchEncoding) {
            try {
                if (keyInterop.isString(key)) {
                    return this.member(obj, Strings.interopAsTruffleString(key, keyInterop, switchEncoding), foreignConvert, interop);
                }
                if (keyInterop.fitsInInt(key)) {
                    return this.arrayElement(obj, keyInterop.asInt(key), foreignConvert, interop);
                }
            }
            catch (UnsupportedMessageException e2) {
                throw Errors.createTypeErrorUnboxException(obj, e2, this);
            }
            return Null.instance;
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj, Object name) {
            throw Errors.createTypeErrorNotATruffleObject("read");
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotWriteNode
    extends JSBuiltinNode {
        PolyglotWriteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object member(TruffleObject obj, TruffleString name, Object value, @Cached.Shared @Cached ExportValueNode exportValue, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached.Shared @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
            Object convertedValue = exportValue.execute(value);
            try {
                interop.writeMember(obj, Strings.toJavaString(toJavaStringNode, name), convertedValue);
                return convertedValue;
            }
            catch (UnknownIdentifierException e2) {
                return Null.instance;
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e3) {
                throw Errors.createTypeErrorInteropException(obj, e3, "writeMember", name, this);
            }
        }

        @Specialization
        protected Object arrayElementInt(TruffleObject obj, int index, Object value, @Cached.Shared @Cached ExportValueNode exportValue, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            Object convertedValue = exportValue.execute(value);
            try {
                interop.writeArrayElement(obj, index, convertedValue);
                return convertedValue;
            }
            catch (InvalidArrayIndexException e2) {
                return Null.instance;
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e3) {
                throw Errors.createTypeErrorInteropException(obj, e3, "writeArrayElement", index, this);
            }
        }

        @Specialization(guards={"isNumber(index)"}, replaces={"arrayElementInt"})
        protected Object arrayElement(TruffleObject obj, Number index, Object value, @Cached.Shared @Cached ExportValueNode exportValue, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            Object convertedValue = exportValue.execute(value);
            try {
                interop.writeArrayElement(obj, JSRuntime.longValue(index), convertedValue);
                return convertedValue;
            }
            catch (InvalidArrayIndexException e2) {
                return Null.instance;
            }
            catch (UnsupportedMessageException | UnsupportedTypeException e3) {
                throw Errors.createTypeErrorInteropException(obj, e3, "writeArrayElement", index, this);
            }
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isString(key)", "!isNumber(key)"})
        protected Object unsupportedKey(TruffleObject obj, Object key, Object value, @Cached.Shared @Cached ExportValueNode exportValue, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached.Exclusive @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary keyInterop, @Cached.Shared @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached TruffleString.SwitchEncodingNode switchEncoding) {
            try {
                if (keyInterop.isString(key)) {
                    return this.member(obj, Strings.interopAsTruffleString(key, keyInterop, switchEncoding), value, exportValue, interop, toJavaStringNode);
                }
                if (keyInterop.fitsInInt(key)) {
                    return this.arrayElement(obj, keyInterop.asInt(key), value, exportValue, interop);
                }
            }
            catch (UnsupportedMessageException e2) {
                throw Errors.createTypeErrorUnboxException(obj, e2, this);
            }
            return Null.instance;
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj, Object name, Object value) {
            throw Errors.createTypeErrorNotATruffleObject("write");
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotRemoveNode
    extends JSBuiltinNode {
        PolyglotRemoveNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean member(TruffleObject obj, TruffleString name, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached.Shared @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
            try {
                interop.removeMember(obj, Strings.toJavaString(toJavaStringNode, name));
                return true;
            }
            catch (UnknownIdentifierException e2) {
                return false;
            }
            catch (UnsupportedMessageException e3) {
                throw Errors.createTypeErrorInteropException(obj, e3, "removeMember", name, this);
            }
        }

        @Specialization
        protected boolean arrayElementInt(TruffleObject obj, int index, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            try {
                interop.removeArrayElement(obj, index);
                return true;
            }
            catch (InvalidArrayIndexException e2) {
                return false;
            }
            catch (UnsupportedMessageException e3) {
                throw Errors.createTypeErrorInteropException(obj, e3, "removeArrayElement", index, this);
            }
        }

        @Specialization(guards={"isNumber(index)"}, replaces={"arrayElementInt"})
        protected boolean arrayElement(TruffleObject obj, Number index, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            try {
                interop.removeArrayElement(obj, JSRuntime.longValue(index));
                return true;
            }
            catch (InvalidArrayIndexException e2) {
                return false;
            }
            catch (UnsupportedMessageException e3) {
                throw Errors.createTypeErrorInteropException(obj, e3, "removeArrayElement", index, this);
            }
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!isString(key)", "!isNumber(key)"})
        protected Object unsupportedKey(TruffleObject obj, Object key, @Cached.Shared @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop, @Cached.Exclusive @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary keyInterop, @Cached.Shared @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached TruffleString.SwitchEncodingNode switchEncoding) {
            try {
                if (keyInterop.isString(key)) {
                    return this.member(obj, Strings.interopAsTruffleString(key, keyInterop, switchEncoding), interop, toJavaStringNode);
                }
                if (keyInterop.fitsInInt(key)) {
                    return this.arrayElementInt(obj, keyInterop.asInt(key), interop);
                }
            }
            catch (UnsupportedMessageException e2) {
                throw Errors.createTypeErrorUnboxException(obj, e2, this);
            }
            return Null.instance;
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj, Object key) {
            throw Errors.createTypeErrorNotATruffleObject("remove");
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotUnboxValueNode
    extends JSBuiltinNode {
        PolyglotUnboxValueNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object truffleObject(TruffleObject obj, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            Object unboxed = JSInteropUtil.toPrimitiveOrDefaultLossy(obj, obj, interop, this);
            if (unboxed == obj) {
                throw Errors.createTypeErrorNotATruffleObject("unbox");
            }
            return unboxed;
        }

        @Specialization(guards={"isJavaPrimitive(obj)"})
        protected Object primitive(Object obj) {
            return obj;
        }

        @Specialization(guards={"!isTruffleObject(obj)", "!isJavaPrimitive(obj)"})
        protected boolean unsupported(Object obj) {
            throw Errors.createTypeErrorNotATruffleObject("unbox");
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotConstructNode
    extends JSBuiltinNode {
        PolyglotConstructNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doNew(TruffleObject obj, Object[] arguments, @Cached ExportValueNode exportValue, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            Object target = exportValue.execute(obj);
            Object[] convertedArgs = new Object[arguments.length];
            for (int i2 = 0; i2 < arguments.length; ++i2) {
                convertedArgs[i2] = exportValue.execute(arguments[i2]);
            }
            try {
                return interop.instantiate(target, convertedArgs);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e2) {
                throw Errors.createTypeErrorInteropException(obj, e2, "instantiate", this);
            }
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj, Object[] arguments) {
            throw Errors.createTypeErrorNotATruffleObject("construct");
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotExecuteNode
    extends JSBuiltinNode {
        PolyglotExecuteNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object doExecute(TruffleObject obj, Object[] arguments, @Cached ExportValueNode exportValue, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            Object target = exportValue.execute(obj);
            Object[] convertedArgs = new Object[arguments.length];
            for (int i2 = 0; i2 < arguments.length; ++i2) {
                convertedArgs[i2] = exportValue.execute(arguments[i2]);
            }
            try {
                return interop.execute(target, convertedArgs);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e2) {
                throw Errors.createTypeErrorInteropException(obj, e2, "execute", this);
            }
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj, Object[] arguments) {
            throw Errors.createTypeErrorNotATruffleObject("execute");
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotGetSizeNode
    extends JSBuiltinNode {
        PolyglotGetSizeNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object getSize(TruffleObject obj, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            try {
                return interop.getArraySize(obj);
            }
            catch (UnsupportedMessageException e2) {
                return Null.instance;
            }
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj) {
            throw Errors.createTypeErrorNotATruffleObject("getSize");
        }
    }

    static abstract class PolyglotKeysNode
    extends JSBuiltinNode {
        PolyglotKeysNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected Object keys(TruffleObject obj) {
            return JSArray.createConstantObjectArray(this.getContext(), this.getRealm(), JSInteropUtil.keys(obj).toArray());
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj) {
            throw Errors.createTypeErrorNotATruffleObject("keys");
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotToJSValueNode
    extends JSBuiltinNode {
        PolyglotToJSValueNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected final Object toJSValue(TruffleObject obj, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            return JSInteropUtil.toPrimitiveOrDefaultLossy(obj, obj, interop, this);
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected static Object toJSValue(Object obj) {
            return obj;
        }
    }

    static abstract class PolyglotToPolyglotValueNode
    extends JSBuiltinNode {
        @Node.Child
        private ExportValueNode exportValueNode = ExportValueNode.create();

        PolyglotToPolyglotValueNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object toPolyglotValue(Object value) {
            return this.exportValueNode.execute(value);
        }
    }

    @ImportStatic(value={JSConfig.class})
    static abstract class PolyglotHasKeysNode
    extends JSBuiltinNode {
        PolyglotHasKeysNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean hasKeys(TruffleObject obj, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary interop) {
            return interop.hasMembers(obj);
        }

        @Specialization(guards={"!isTruffleObject(obj)"})
        protected boolean unsupported(Object obj) {
            return false;
        }
    }
}

