/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSBinaryNode;
import com.oracle.truffle.js.nodes.binary.JSModuloNodeGen;
import com.oracle.truffle.js.nodes.binary.JSOverloadedBinaryNode;
import com.oracle.truffle.js.nodes.cast.JSToNumericNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.Strings;
import java.util.Set;

@NodeInfo(shortName="%")
public abstract class JSModuloNode
extends JSBinaryNode {
    protected JSModuloNode(JavaScriptNode left, JavaScriptNode right) {
        super(left, right);
    }

    public static JSModuloNode create(JavaScriptNode left, JavaScriptNode right) {
        return JSModuloNodeGen.create(left, right);
    }

    public static JSModuloNode create() {
        return JSModuloNode.create(null, null);
    }

    public abstract Object execute(Object var1, Object var2);

    static boolean isPowOf2(int b2) {
        return b2 > 0 && (b2 & b2 - 1) == 0;
    }

    @Specialization(rewriteOn={ArithmeticException.class}, guards={"isPowOf2(b)"})
    protected int doIntPow2(int a2, int b2, @Cached @Cached.Exclusive InlinedBranchProfile negativeBranch, @Cached @Cached.Exclusive InlinedBranchProfile negativeZeroBranch) {
        int result;
        int mask = b2 - 1;
        if (a2 < 0) {
            negativeBranch.enter(this);
            result = -(-a2 & mask);
            if (result == 0) {
                negativeZeroBranch.enter(this);
                throw new ArithmeticException();
            }
        } else {
            result = a2 & mask;
        }
        return result;
    }

    @Specialization(rewriteOn={ArithmeticException.class}, guards={"!isPowOf2(b)"})
    protected int doInt(int a2, int b2, @Cached @Cached.Exclusive InlinedBranchProfile specialBranch) {
        int result = a2 % b2;
        if (result == 0) {
            specialBranch.enter(this);
            if (a2 < 0) {
                throw new ArithmeticException();
            }
        }
        return result;
    }

    @Specialization
    protected double doDouble(double a2, double b2) {
        return a2 % b2;
    }

    @Specialization(guards={"isBigIntZero(b)"})
    protected void doBigIntegerZeroDivision(BigInt a2, BigInt b2) {
        throw Errors.createRangeError("Remainder of zero division");
    }

    @Specialization(guards={"!isBigIntZero(b)"})
    protected BigInt doBigInteger(BigInt a2, BigInt b2) {
        return a2.remainder(b2);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"hasOverloadedOperators(a) || hasOverloadedOperators(b)"})
    protected Object doOverloaded(Object a2, Object b2, @Cached(value="createNumeric(getOverloadedOperatorName())") JSOverloadedBinaryNode overloadedOperatorNode) {
        return overloadedOperatorNode.execute(a2, b2);
    }

    protected TruffleString getOverloadedOperatorName() {
        return Strings.SYMBOL_PERCENT;
    }

    @Specialization(guards={"!hasOverloadedOperators(a)", "!hasOverloadedOperators(b)"}, replaces={"doInt", "doDouble", "doBigIntegerZeroDivision", "doBigInteger"})
    protected static Object doGeneric(Object a2, Object b2, @Bind(value="this") Node node, @Cached JSModuloNode nestedModuloNode, @Cached JSToNumericNode toNumeric1Node, @Cached JSToNumericNode toNumeric2Node, @Cached @Cached.Exclusive InlinedBranchProfile mixedNumericTypes) {
        Object operandA = toNumeric1Node.execute(a2);
        Object operandB = toNumeric2Node.execute(b2);
        JSModuloNode.ensureBothSameNumericType(operandA, operandB, node, mixedNumericTypes);
        return nestedModuloNode.execute(operandA, operandB);
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSModuloNodeGen.create(JSModuloNode.cloneUninitialized(this.getLeft(), materializedTags), JSModuloNode.cloneUninitialized(this.getRight(), materializedTags));
    }
}

