/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.EnterprisePolyglotImpl;
import com.oracle.truffle.polyglot.enterprise.IsolateSourceCache;
import com.oracle.truffle.polyglot.enterprise.NativeContext;
import com.oracle.truffle.polyglot.enterprise.NativePolyglotIsolateServices;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.Pair;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolate;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObject;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class NativeEngine
extends NativeObject {
    private final EnterprisePolyglotImpl polyglot;
    private final Object localEngine;
    private final boolean bound;
    private final long hostStackHeadRoom;
    private final NativePolyglotIsolateServices isolateServices;
    private final Set<Object> contexts;
    private boolean closed;
    private volatile Object api;

    NativeEngine(EnterprisePolyglotImpl enterprisePolyglotImpl, NativeIsolate nativeIsolate, long l2, Object object, boolean bl, long l3, NativePolyglotIsolateServices nativePolyglotIsolateServices) {
        super(nativeIsolate, l2);
        this.polyglot = enterprisePolyglotImpl;
        this.localEngine = object;
        this.bound = bl;
        this.hostStackHeadRoom = l3;
        this.isolateServices = nativePolyglotIsolateServices;
        this.contexts = Collections.newSetFromMap(new WeakHashMap());
    }

    Object getLocalEngine() {
        return this.localEngine;
    }

    void setAPI(Object object) {
        this.api = object;
    }

    Object getAPI() {
        return this.api;
    }

    boolean isBound() {
        return this.bound;
    }

    long getHostStackHeadRoom() {
        return this.hostStackHeadRoom;
    }

    IsolateSourceCache getSourceCache() {
        return this.getPolyglotIsolateServices().getSourceCache();
    }

    NativePolyglotIsolateServices getPolyglotIsolateServices() {
        return this.isolateServices;
    }

    Pair<Long, Long> getKey() {
        return Pair.create(this.getIsolate().getIsolateId(), this.getHandle());
    }

    synchronized void onContextCreated(Object object) {
        if (this.closed) {
            throw new IllegalStateException("Engine is already closed.");
        }
        NativeContext nativeContext = (NativeContext)this.polyglot.getAPIAccess().getContextReceiver(object);
        this.polyglot.registerContext(object, nativeContext);
        this.contexts.add(object);
    }

    synchronized void close() {
        this.closed = true;
        if (!this.contexts.isEmpty()) {
            AbstractPolyglotImpl.APIAccess aPIAccess = this.polyglot.getAPIAccess();
            Iterator<Object> iterator = this.contexts.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                iterator.remove();
                NativeContext nativeContext = (NativeContext)aPIAccess.getContextReceiver(object);
                if (!this.polyglot.requireContextRegistered(nativeContext)) continue;
                this.polyglot.releaseContextRegisteredRequirement(nativeContext, true);
            }
        }
    }
}

