/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot.enterprise;

import com.oracle.truffle.polyglot.enterprise.NativeOptionConverter;
import com.oracle.truffle.polyglot.enterprise.PolyglotIsolateGuestFeatureEnabled;
import com.oracle.truffle.polyglot.enterprise.PolyglotJNIConfig;
import java.util.function.Function;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNI;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIMethodScope;
import org.cyclops.integratedscripting.vendors.org.graalvm.jniutils.JNIUtil;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryInput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryMarshaller;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.BinaryOutput;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.ForeignException;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.JNIConfig;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolate;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeIsolateThread;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativebridge.NativeObjectHandles;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.ImageInfo;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.StackValue;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.function.CEntryPoint;
import org.cyclops.integratedscripting.vendors.org.graalvm.nativeimage.c.type.CCharPointer;
import org.cyclops.integratedscripting.vendors.org.graalvm.word.WordFactory;

final class NativeOptionConverterGen {
    NativeOptionConverterGen() {
    }

    static NativeOptionConverter createHSToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeOptionConverter createNativeToNative(NativeIsolate nativeIsolate, long l2) {
        return new StartPoint(nativeIsolate, l2);
    }

    static NativeOptionConverter create(NativeIsolate nativeIsolate, long l2) {
        if (ImageInfo.inImageCode()) {
            return NativeOptionConverterGen.createNativeToNative(nativeIsolate, l2);
        }
        return NativeOptionConverterGen.createHSToNative(nativeIsolate, l2);
    }

    private static final class StartPoint
    extends NativeOptionConverter {
        private static final BinaryMarshaller<Object> objectWithOptionValueMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        StartPoint(NativeIsolate nativeIsolate, long l2) {
            super(nativeIsolate, l2);
        }

        @Override
        public Object apply(String string) {
            NativeIsolateThread nativeIsolateThread = this.getIsolate().enter();
            try {
                byte[] byArray = StartPoint.apply0(nativeIsolateThread.getIsolateThreadId(), this.getHandle(), string);
                BinaryInput binaryInput = BinaryInput.create(byArray);
                Object object = objectWithOptionValueMarshaller.read(binaryInput);
                return object;
            }
            catch (ForeignException foreignException) {
                throw foreignException.throwOriginalException(throwableMarshaller);
            }
            finally {
                nativeIsolateThread.leave();
            }
        }

        private static native byte[] apply0(long var0, long var2, String var4);

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            objectWithOptionValueMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.OptionValue.class);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }

    private static final class EndPoint {
        private static final BinaryMarshaller<Object> objectWithOptionValueMarshaller;
        private static final BinaryMarshaller<Throwable> throwableMarshaller;

        private EndPoint() {
        }

        @CEntryPoint(name="Java_com_oracle_truffle_polyglot_enterprise_NativeOptionConverterGen_00024StartPoint_apply0", include=PolyglotIsolateGuestFeatureEnabled.class)
        static JNI.JByteArray apply(JNI.JNIEnv jNIEnv, JNI.JClass jClass, @CEntryPoint.IsolateThreadContext long l2, long l3, JNI.JString jString) {
            JNIMethodScope jNIMethodScope = new JNIMethodScope("NativeOptionConverterGen::apply", jNIEnv);
            try (JNIMethodScope jNIMethodScope2 = jNIMethodScope;){
                Function function = NativeObjectHandles.resolve(l3, Function.class);
                CCharPointer cCharPointer = (CCharPointer)StackValue.get(256);
                Object r2 = function.apply(JNIUtil.createString(jNIEnv, jString));
                int n2 = objectWithOptionValueMarshaller.inferSize(r2);
                try (BinaryOutput.CCharPointerBinaryOutput cCharPointerBinaryOutput = n2 > 256 ? BinaryOutput.CCharPointerBinaryOutput.create(n2) : BinaryOutput.create(cCharPointer, 256, false);){
                    objectWithOptionValueMarshaller.write(cCharPointerBinaryOutput, r2);
                    int n3 = cCharPointerBinaryOutput.getPosition();
                    JNI.JByteArray jByteArray = JNIUtil.NewByteArray(jNIEnv, n3);
                    JNIUtil.SetByteArrayRegion(jNIEnv, jByteArray, 0, n3, cCharPointerBinaryOutput.getAddress());
                    jNIMethodScope.setObjectResult(jByteArray);
                }
            }
            catch (Throwable throwable) {
                ForeignException.forThrowable(throwable, throwableMarshaller).throwUsingJNI(jNIEnv);
                jNIMethodScope.setObjectResult((JNI.JObject)WordFactory.nullPointer());
            }
            return (JNI.JByteArray)jNIMethodScope.getObjectResult();
        }

        static {
            JNIConfig jNIConfig = PolyglotJNIConfig.getInstance();
            objectWithOptionValueMarshaller = jNIConfig.lookupMarshaller(Object.class, PolyglotJNIConfig.OptionValue.class);
            throwableMarshaller = jNIConfig.lookupMarshaller(Throwable.class, new Class[0]);
        }
    }
}

