/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.parser;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.charset.ClassSetContents;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonObject;
import java.util.Arrays;
import java.util.Objects;

public class Token
implements JsonConvertible {
    private static final Token A = new Token(Kind.A);
    private static final Token Z = new Token(Kind.Z);
    private static final Token Z_LOWER_CASE = new Token(Kind.z);
    private static final Token CARET = new Token(Kind.caret);
    private static final Token DOLLAR = new Token(Kind.dollar);
    private static final Token LINEBREAK = new Token(Kind.linebreak);
    private static final Token WORD_BOUNDARY = new Token(Kind.wordBoundary);
    private static final Token NON_WORD_BOUNDARY = new Token(Kind.nonWordBoundary);
    private static final Token ALTERNATION = new Token(Kind.alternation);
    private static final Token CAPTURE_GROUP_BEGIN = new Token(Kind.captureGroupBegin);
    private static final Token NON_CAPTURE_GROUP_BEGIN = new Token(Kind.nonCaptureGroupBegin);
    private static final Token CHAR_CLASS_BEGIN = new Token(Kind.charClassBegin);
    private static final Token CHAR_CLASS_END = new Token(Kind.charClassEnd);
    private static final Token ATOMIC_GROUP_BEGIN = new Token(Kind.atomicGroupBegin);
    private static final Token LOOK_AHEAD_ASSERTION_BEGIN = new LookAheadAssertionBegin(false);
    private static final Token NEGATIVE_LOOK_AHEAD_ASSERTION_BEGIN = new LookAheadAssertionBegin(true);
    private static final Token LOOK_BEHIND_ASSERTION_BEGIN = new LookBehindAssertionBegin(false);
    private static final Token NEGATIVE_LOOK_BEHIND_ASSERTION_BEGIN = new LookBehindAssertionBegin(true);
    private static final Token GROUP_END = new Token(Kind.groupEnd);
    public final Kind kind;
    private SourceSection sourceSection;
    private int position;

    public static Token createA() {
        return A;
    }

    public static Token createZ() {
        return Z;
    }

    public static Token createZLowerCase() {
        return Z_LOWER_CASE;
    }

    public static Token createCaret() {
        return CARET;
    }

    public static Token createDollar() {
        return DOLLAR;
    }

    public static Token createLineBreak() {
        return LINEBREAK;
    }

    public static Token createWordBoundary() {
        return WORD_BOUNDARY;
    }

    public static Token createNonWordBoundary() {
        return NON_WORD_BOUNDARY;
    }

    public static Token createAlternation() {
        return ALTERNATION;
    }

    public static Token createCaptureGroupBegin() {
        return CAPTURE_GROUP_BEGIN;
    }

    public static Token createNonCaptureGroupBegin() {
        return NON_CAPTURE_GROUP_BEGIN;
    }

    public static Token createAtomicGroupBegin() {
        return ATOMIC_GROUP_BEGIN;
    }

    public static Token createLookAheadAssertionBegin() {
        return LOOK_AHEAD_ASSERTION_BEGIN;
    }

    public static Token createLookBehindAssertionBegin() {
        return LOOK_BEHIND_ASSERTION_BEGIN;
    }

    public static Token createGroupEnd() {
        return GROUP_END;
    }

    public static BackReference createBackReference(int groupNr, boolean namedReference) {
        return new BackReference(Kind.backReference, new int[]{groupNr}, namedReference);
    }

    public static BackReference createBackReference(int[] groupNumbers, boolean namedReference) {
        return new BackReference(Kind.backReference, groupNumbers, namedReference);
    }

    public static Quantifier createQuantifier(int min, int max, boolean greedy, boolean possessive, boolean singleChar) {
        return new Quantifier(min, max, greedy, possessive, singleChar);
    }

    public static LiteralCharacter createLiteralCharacter(int codePoint) {
        return new LiteralCharacter(codePoint);
    }

    public static LiteralString createLiteralString(int start, int end) {
        return new LiteralString(start, end);
    }

    public static CharacterClass createCharClass(CodePointSet codePointSet) {
        return new CharacterClass(codePointSet, false);
    }

    public static CharacterClass createCharClass(CodePointSet codePointSet, boolean wasSingleChar) {
        return new CharacterClass(codePointSet, wasSingleChar);
    }

    public static ClassSet createClassSetExpression(ClassSetContents contents) {
        return new ClassSet(contents);
    }

    public static Token createCharacterClassBegin() {
        return CHAR_CLASS_BEGIN;
    }

    public static Token createCharacterClassAtom(ClassSetContents contents) {
        return new CharacterClassAtom(contents);
    }

    public static Token createCharacterClassEnd() {
        return CHAR_CLASS_END;
    }

    public static Token createLookAheadAssertionBegin(boolean negated) {
        return negated ? NEGATIVE_LOOK_AHEAD_ASSERTION_BEGIN : LOOK_AHEAD_ASSERTION_BEGIN;
    }

    public static Token createLookBehindAssertionBegin(boolean negated) {
        return negated ? NEGATIVE_LOOK_BEHIND_ASSERTION_BEGIN : LOOK_BEHIND_ASSERTION_BEGIN;
    }

    public static InlineFlags createInlineFlags(AbstractRegexObject flags, boolean global) {
        return new InlineFlags(flags, global);
    }

    public static BackReference createConditionalBackReference(int groupNr, boolean namedReference) {
        return new BackReference(Kind.conditionalBackreference, new int[]{groupNr}, namedReference);
    }

    public Token(Kind kind) {
        this.kind = kind;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public void setSourceSection(SourceSection sourceSection) {
        this.sourceSection = sourceSection;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonObject toJson() {
        return Json.obj(Json.prop("kind", this.kind.name()));
    }

    public static final class BackReference
    extends Token {
        private final int[] groupNumbers;
        private final boolean namedReference;

        public BackReference(Kind kind, int[] groupNumbers, boolean namedReference) {
            super(kind);
            assert (kind == Kind.backReference || kind == Kind.conditionalBackreference);
            this.groupNumbers = groupNumbers;
            this.namedReference = namedReference;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public JsonObject toJson() {
            return super.toJson().append(Json.prop("groupNumbers", Arrays.stream(this.groupNumbers).mapToObj(Json::val)));
        }

        public int[] getGroupNumbers() {
            return this.groupNumbers;
        }

        public boolean isNamedReference() {
            return this.namedReference;
        }
    }

    public static enum Kind {
        A,
        Z,
        z,
        caret,
        dollar,
        linebreak,
        wordBoundary,
        nonWordBoundary,
        backReference,
        quantifier,
        alternation,
        captureGroupBegin,
        nonCaptureGroupBegin,
        atomicGroupBegin,
        lookAheadAssertionBegin,
        lookBehindAssertionBegin,
        groupEnd,
        literalChar,
        literalString,
        charClass,
        charClassBegin,
        charClassAtom,
        charClassEnd,
        classSet,
        inlineFlags,
        conditionalBackreference;

    }

    public static final class Quantifier
    extends Token {
        public static final int INFINITY = -1;
        private final int min;
        private final int max;
        private final boolean greedy;
        private final boolean possessive;
        private final boolean singleChar;
        @CompilerDirectives.CompilationFinal
        private int index = -1;
        @CompilerDirectives.CompilationFinal
        private int zeroWidthIndex = -1;

        public Quantifier(int min, int max, boolean greedy, boolean possessive, boolean singleChar) {
            super(Kind.quantifier);
            this.min = min;
            this.max = max;
            this.greedy = greedy;
            this.possessive = possessive;
            this.singleChar = singleChar;
        }

        public boolean isInfiniteLoop() {
            return this.getMax() == -1;
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }

        public boolean isGreedy() {
            return this.greedy;
        }

        public boolean isPossessive() {
            return this.possessive;
        }

        public boolean isSingleChar() {
            return this.singleChar;
        }

        public boolean hasIndex() {
            return this.index >= 0;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean hasZeroWidthIndex() {
            return this.zeroWidthIndex >= 0;
        }

        public int getZeroWidthIndex() {
            return this.zeroWidthIndex;
        }

        public void setZeroWidthIndex(int zeroWidthIndex) {
            this.zeroWidthIndex = zeroWidthIndex;
        }

        public boolean isWithinThreshold(int threshold) {
            return this.min <= threshold && this.max <= threshold;
        }

        public boolean isUnrollTrivial() {
            return this.min == 0 && this.max <= 1;
        }

        public boolean isDead() {
            return this.min == -1 || Integer.compareUnsigned(this.min, this.max) > 0;
        }

        public int hashCode() {
            return Objects.hash(this.min, this.max, this.greedy, this.possessive, this.index, this.zeroWidthIndex);
        }

        public boolean equalsSemantic(Quantifier o2) {
            return this.min == o2.min && this.max == o2.max && this.greedy == o2.greedy && this.possessive == o2.possessive;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Quantifier)) {
                return false;
            }
            Quantifier o2 = (Quantifier)obj;
            return this.min == o2.min && this.max == o2.max && this.greedy == o2.greedy && this.possessive == o2.possessive && this.index == o2.index && this.zeroWidthIndex == o2.zeroWidthIndex;
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            String ret = this.minMaxToString();
            return this.isPossessive() ? ret + "+" : (this.isGreedy() ? ret : ret + "?");
        }

        @CompilerDirectives.TruffleBoundary
        public String toStringNoSuffix() {
            return this.minMaxToString();
        }

        private String minMaxToString() {
            if (this.isSingleChar()) {
                if (this.min == 0 && this.max == 1) {
                    return "?";
                }
                if (this.min == 0 && this.isInfiniteLoop()) {
                    return "*";
                }
                if (this.min == 1 && this.isInfiniteLoop()) {
                    return "+";
                }
            }
            return String.format("{%d,%s}", this.min, this.isInfiniteLoop() ? "" : String.valueOf(this.max));
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public JsonObject toJson() {
            return super.toJson().append(Json.prop("min", this.getMin()), Json.prop("max", this.getMax()), Json.prop("greedy", this.isGreedy()), Json.prop("possessive", this.isPossessive()));
        }
    }

    public static final class LiteralCharacter
    extends Token {
        private final int codePoint;

        public LiteralCharacter(int codePoint) {
            super(Kind.literalChar);
            this.codePoint = codePoint;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public JsonObject toJson() {
            return super.toJson().append(Json.prop("codePoint", this.codePoint));
        }

        public int getCodePoint() {
            return this.codePoint;
        }
    }

    public static final class LiteralString
    extends Token {
        private final int start;
        private final int end;

        public LiteralString(int start, int end) {
            super(Kind.literalString);
            this.start = start;
            this.end = end;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public JsonObject toJson() {
            return super.toJson().append(Json.prop("start", this.start), Json.prop("end", this.end));
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }

    public static final class CharacterClass
    extends Token {
        private final CodePointSet codePointSet;
        private final boolean wasSingleChar;

        public CharacterClass(CodePointSet codePointSet, boolean wasSingleChar) {
            super(Kind.charClass);
            this.codePointSet = codePointSet;
            this.wasSingleChar = wasSingleChar;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public JsonObject toJson() {
            return super.toJson().append(Json.prop("codePointSet", this.codePointSet));
        }

        public CodePointSet getCodePointSet() {
            return this.codePointSet;
        }

        public boolean wasSingleChar() {
            return this.wasSingleChar;
        }
    }

    public static final class ClassSet
    extends Token {
        private final ClassSetContents contents;

        public ClassSet(ClassSetContents contents) {
            super(Kind.classSet);
            this.contents = contents;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public JsonObject toJson() {
            return super.toJson().append(Json.prop("contents", this.contents));
        }

        public ClassSetContents getContents() {
            return this.contents;
        }
    }

    public static final class CharacterClassAtom
    extends Token {
        private final ClassSetContents contents;

        public CharacterClassAtom(ClassSetContents contents) {
            super(Kind.charClassAtom);
            this.contents = contents;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public JsonObject toJson() {
            return super.toJson().append(Json.prop("contents", this.contents));
        }

        public ClassSetContents getContents() {
            return this.contents;
        }
    }

    public static final class InlineFlags
    extends Token {
        private final AbstractRegexObject flags;
        private final boolean global;

        public InlineFlags(AbstractRegexObject flags, boolean global) {
            super(Kind.inlineFlags);
            this.flags = flags;
            this.global = global;
        }

        public AbstractRegexObject getFlags() {
            return this.flags;
        }

        public boolean isGlobal() {
            return this.global;
        }
    }

    public static final class LookAheadAssertionBegin
    extends LookAroundAssertionBegin {
        public LookAheadAssertionBegin(boolean negated) {
            super(Kind.lookAheadAssertionBegin, negated);
        }
    }

    public static final class LookBehindAssertionBegin
    extends LookAroundAssertionBegin {
        public LookBehindAssertionBegin(boolean negated) {
            super(Kind.lookBehindAssertionBegin, negated);
        }
    }

    public static class LookAroundAssertionBegin
    extends Token {
        private final boolean negated;

        protected LookAroundAssertionBegin(Kind kind, boolean negated) {
            super(kind);
            this.negated = negated;
        }

        public boolean isNegated() {
            return this.negated;
        }
    }
}

