/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.AbstractFastThreadLocal;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.impl.FrameWithoutBoxing;
import com.oracle.truffle.api.impl.ThreadLocalHandshake;
import com.oracle.truffle.api.nodes.BlockNode;
import com.oracle.truffle.api.nodes.BytecodeOSRNode;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.runtime.BackgroundCompileQueue;
import com.oracle.truffle.runtime.BaseOSRRootNode;
import com.oracle.truffle.runtime.BytecodeOSRMetadata;
import com.oracle.truffle.runtime.EngineCacheSupport;
import com.oracle.truffle.runtime.EngineData;
import com.oracle.truffle.runtime.OptimizedAssumption;
import com.oracle.truffle.runtime.OptimizedBlockNode;
import com.oracle.truffle.runtime.OptimizedCallTarget;
import com.oracle.truffle.runtime.OptimizedDirectCallNode;
import com.oracle.truffle.runtime.OptimizedIndirectCallNode;
import com.oracle.truffle.runtime.OptimizedOSRLoopNode;
import com.oracle.truffle.runtime.OptimizedRuntimeAccessor;
import com.oracle.truffle.runtime.OptimizedRuntimeOptions;
import com.oracle.truffle.runtime.OptimizedTruffleRuntime;
import com.oracle.truffle.runtime.TruffleSplittingStrategy;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionDescriptors;
import org.cyclops.integratedscripting.vendors.org.graalvm.options.OptionValues;
import org.cyclops.integratedscripting.vendors.org.graalvm.polyglot.SandboxPolicy;

final class OptimizedRuntimeSupport
extends Accessor.RuntimeSupport {
    static final String CALL_INLINED_METHOD_NAME = "callInlined";

    OptimizedRuntimeSupport(Object permission) {
        super(permission);
    }

    @Override
    public RootCallTarget newCallTarget(CallTarget source, RootNode rootNode) {
        assert (OptimizedRuntimeAccessor.NODES.getCallTargetWithoutInitialization(rootNode) == null) : "CallTarget for root node already initialized.";
        CompilerAsserts.neverPartOfCompilation();
        return OptimizedTruffleRuntime.getRuntime().createOptimizedCallTarget((OptimizedCallTarget)source, rootNode);
    }

    @Override
    public long getCallTargetId(CallTarget target) {
        if (target instanceof OptimizedCallTarget) {
            return ((OptimizedCallTarget)target).id;
        }
        return 0L;
    }

    @Override
    public boolean isLoaded(CallTarget callTarget) {
        return ((OptimizedCallTarget)callTarget).isLoaded();
    }

    @Override
    public IndirectCallNode createIndirectCallNode() {
        return new OptimizedIndirectCallNode();
    }

    @Override
    public DirectCallNode createDirectCallNode(CallTarget target) {
        OptimizedCallTarget optimizedTarget = (OptimizedCallTarget)target;
        OptimizedDirectCallNode directCallNode = new OptimizedDirectCallNode(optimizedTarget);
        optimizedTarget.addDirectCallNode(directCallNode);
        return directCallNode;
    }

    @Override
    public void notifyOnLoad(CallTarget callTarget) {
        CompilerAsserts.neverPartOfCompilation();
        OptimizedCallTarget target = (OptimizedCallTarget)callTarget;
        OptimizedRuntimeAccessor.INSTRUMENT.onLoad(target.getRootNode());
        if (target.engine.compileAOTOnCreate && target.prepareForAOT()) {
            target.compile(true);
        }
        TruffleSplittingStrategy.newTargetCreated(target);
        target.setLoaded();
    }

    @Override
    @ExplodeLoop
    public void onLoopCount(Node source, int count) {
        RootCallTarget target;
        Node parentNode;
        CompilerAsserts.partialEvaluationConstant(source);
        Node node = parentNode = source != null ? source.getParent() : null;
        for (Node node2 = source; node2 != null; node2 = node2.getParent()) {
            if (node2 instanceof OptimizedOSRLoopNode) {
                ((OptimizedOSRLoopNode)node2).reportChildLoopCount(count);
            }
            parentNode = node2;
        }
        if (parentNode instanceof RootNode && (target = ((RootNode)parentNode).getCallTarget()) instanceof OptimizedCallTarget) {
            ((OptimizedCallTarget)target).onLoopCount(count);
        }
    }

    @Override
    public boolean pollBytecodeOSRBackEdge(BytecodeOSRNode osrNode) {
        CompilerAsserts.neverPartOfCompilation();
        TruffleSafepoint.poll((Node)((Object)osrNode));
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        if (osrMetadata == null) {
            osrMetadata = OptimizedRuntimeSupport.initializeBytecodeOSRMetadata(osrNode);
        }
        if (osrMetadata.isDisabled()) {
            return false;
        }
        return osrMetadata.incrementAndPoll();
    }

    private static BytecodeOSRMetadata initializeBytecodeOSRMetadata(BytecodeOSRNode osrNode) {
        Node node = (Node)((Object)osrNode);
        return node.atomic(() -> {
            BytecodeOSRMetadata metadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
            if (metadata == null) {
                OptimizedCallTarget callTarget = (OptimizedCallTarget)node.getRootNode().getCallTarget();
                metadata = callTarget.engine.compilation && callTarget.getOptionValue(OptimizedRuntimeOptions.OSR) != false ? new BytecodeOSRMetadata(osrNode, callTarget.getOptionValue(OptimizedRuntimeOptions.OSRCompilationThreshold), callTarget.getOptionValue(OptimizedRuntimeOptions.OSRMaxCompilationReAttempts)) : BytecodeOSRMetadata.DISABLED;
                osrNode.setOSRMetadata(metadata);
            }
            return metadata;
        });
    }

    @Override
    public Object tryBytecodeOSR(BytecodeOSRNode osrNode, int target, Object interpreterState, Runnable beforeTransfer, VirtualFrame parentFrame) {
        CompilerAsserts.neverPartOfCompilation();
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        return osrMetadata.tryOSR(target, interpreterState, beforeTransfer, parentFrame);
    }

    @Override
    public void onOSRNodeReplaced(BytecodeOSRNode osrNode, Node oldNode, Node newNode, CharSequence reason) {
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        if (osrMetadata != null) {
            osrMetadata.nodeReplaced(oldNode, newNode, reason);
        }
    }

    @Override
    public void transferOSRFrame(BytecodeOSRNode osrNode, Frame source, Frame target, int bytecodeTarget) {
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        BytecodeOSRMetadata.OsrEntryDescription targetMetadata = osrMetadata.getLazyState().get(bytecodeTarget);
        osrMetadata.transferFrame((FrameWithoutBoxing)source, (FrameWithoutBoxing)target, bytecodeTarget, targetMetadata);
    }

    @Override
    public void transferOSRFrame(BytecodeOSRNode osrNode, Frame source, Frame target, int bytecodeTarget, Object targetMetadata) {
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        osrMetadata.transferFrame((FrameWithoutBoxing)source, (FrameWithoutBoxing)target, bytecodeTarget, targetMetadata);
    }

    @Override
    public void restoreOSRFrame(BytecodeOSRNode osrNode, Frame source, Frame target) {
        BytecodeOSRMetadata osrMetadata = (BytecodeOSRMetadata)osrNode.getOSRMetadata();
        osrMetadata.restoreFrame((FrameWithoutBoxing)source, (FrameWithoutBoxing)target);
    }

    @Override
    public ThreadLocalHandshake getThreadLocalHandshake() {
        return OptimizedTruffleRuntime.getRuntime().getThreadLocalHandshake();
    }

    @Override
    public OptionDescriptors getRuntimeOptionDescriptors() {
        return OptimizedTruffleRuntime.getRuntime().getOptionDescriptors();
    }

    @Override
    public boolean isGuestCallStackFrame(StackTraceElement e2) {
        return e2.getMethodName().equals("executeRootNode") && e2.getClassName().equals(OptimizedCallTarget.class.getName());
    }

    @Override
    public void initializeProfile(CallTarget target, Class<?>[] argumentTypes) {
        ((OptimizedCallTarget)target).initializeUnsafeArgumentTypes(argumentTypes);
    }

    @Override
    public <T extends Node> BlockNode<T> createBlockNode(T[] elements, BlockNode.ElementExecutor<T> executor) {
        return new OptimizedBlockNode(elements, executor);
    }

    @Override
    public Assumption createAlwaysValidAssumption() {
        return OptimizedAssumption.createAlwaysValid();
    }

    @Override
    public void reportPolymorphicSpecialize(Node source) {
        OptimizedCallTarget callTarget;
        RootNode rootNode = source.getRootNode();
        OptimizedCallTarget optimizedCallTarget = callTarget = rootNode == null ? null : (OptimizedCallTarget)rootNode.getCallTarget();
        if (callTarget == null) {
            return;
        }
        TruffleSplittingStrategy.newPolymorphicSpecialize(source, callTarget.engine);
        callTarget.polymorphicSpecialize(source);
    }

    @Override
    public Object callInlined(Node callNode, CallTarget target, Object ... arguments) {
        OptimizedCallTarget optimizedCallTarget = (OptimizedCallTarget)target;
        try {
            return optimizedCallTarget.callInlined(callNode, arguments);
        }
        catch (Throwable t2) {
            OptimizedRuntimeAccessor.LANGUAGE.addStackFrameInfo(callNode, null, t2, null);
            throw OptimizedCallTarget.rethrow(t2);
        }
    }

    @Override
    public Object callProfiled(CallTarget target, Object ... arguments) {
        OptimizedCallTarget castTarget = (OptimizedCallTarget)target;
        assert (castTarget.isValidArgumentProfile(arguments)) : "Invalid argument profile. callProfiled requires to explicity initialize the profile.";
        return castTarget.doInvoke(arguments);
    }

    @Override
    public Object[] castArrayFixedLength(Object[] args, int length) {
        return OptimizedCallTarget.castArrayFixedLength(args, length);
    }

    @Override
    public <T> T unsafeCast(Object value, Class<T> type, boolean condition, boolean nonNull, boolean exact) {
        return OptimizedCallTarget.unsafeCast(value, type, condition, nonNull, exact);
    }

    @Override
    public void flushCompileQueue(Object runtimeData) {
        EngineData engine = (EngineData)runtimeData;
        BackgroundCompileQueue queue = OptimizedTruffleRuntime.getRuntime().getCompileQueue();
        if (queue != null) {
            for (OptimizedCallTarget target : queue.getQueuedTargets(engine)) {
                target.cancelCompilation("Polyglot engine was closed.");
            }
        }
    }

    @Override
    public Object tryLoadCachedEngine(OptionValues options, Function<String, TruffleLogger> loggerFactory) {
        return OptimizedTruffleRuntime.getRuntime().getEngineCacheSupport().tryLoadingCachedEngine(options, loggerFactory);
    }

    @Override
    public boolean isStoreEnabled(OptionValues options) {
        return EngineCacheSupport.get().isStoreEnabled(options);
    }

    @Override
    public Object createRuntimeData(Object engine, OptionValues engineOptions, Function<String, TruffleLogger> loggerFactory, SandboxPolicy sandboxPolicy) {
        return new EngineData(engine, engineOptions, loggerFactory, sandboxPolicy);
    }

    @Override
    public void onEngineCreate(Object engine, Object runtimeData) {
        ((EngineData)runtimeData).onEngineCreated(engine);
    }

    @Override
    public void onEnginePatch(Object runtimeData, OptionValues runtimeOptions, Function<String, TruffleLogger> loggerFactory, SandboxPolicy sandboxPolicy) {
        ((EngineData)runtimeData).onEnginePatch(runtimeOptions, loggerFactory, sandboxPolicy);
    }

    @Override
    public boolean onEngineClosing(Object runtimeData) {
        return ((EngineData)runtimeData).onEngineClosing();
    }

    @Override
    public void onEngineClosed(Object runtimeData) {
        ((EngineData)runtimeData).onEngineClosed();
    }

    @Override
    public boolean isOSRRootNode(RootNode rootNode) {
        return rootNode instanceof BaseOSRRootNode;
    }

    @Override
    public int getObjectAlignment() {
        return OptimizedTruffleRuntime.getRuntime().getObjectAlignment();
    }

    @Override
    public int getArrayBaseOffset(Class<?> componentType) {
        return OptimizedTruffleRuntime.getRuntime().getArrayBaseOffset(componentType);
    }

    @Override
    public int getArrayIndexScale(Class<?> componentType) {
        return OptimizedTruffleRuntime.getRuntime().getArrayIndexScale(componentType);
    }

    @Override
    public int getBaseInstanceSize(Class<?> type) {
        return OptimizedTruffleRuntime.getRuntime().getBaseInstanceSize(type);
    }

    @Override
    public boolean isLegacyCompilerOption(String key) {
        return OptimizedTruffleRuntime.CompilerOptionsDescriptors.isLegacyOption(key);
    }

    @Override
    public int[] getFieldOffsets(Class<?> type, boolean includePrimitive, boolean includeSuperclasses) {
        return OptimizedTruffleRuntime.getRuntime().getFieldOffsets(type, includePrimitive, includeSuperclasses);
    }

    @Override
    public AbstractFastThreadLocal getContextThreadLocal() {
        AbstractFastThreadLocal local = OptimizedTruffleRuntime.getRuntime().getFastThreadLocalImpl();
        if (local == null) {
            return super.getContextThreadLocal();
        }
        return local;
    }

    @Override
    public <T> ThreadLocal<T> createTerminatingThreadLocal(Supplier<T> initialValue, Consumer<T> onThreadTermination) {
        return OptimizedTruffleRuntime.createTerminatingThreadLocal(initialValue, onThreadTermination);
    }
}

