/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.client.gui.container;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetArrowedListField;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.client.gui.image.Image;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.core.client.gui.container.DisplayErrorsComponent;
import org.cyclops.integratedscripting.GeneralConfig;
import org.cyclops.integratedscripting.IntegratedScripting;
import org.cyclops.integratedscripting.api.language.ILanguageHandler;
import org.cyclops.integratedscripting.client.gui.component.input.WidgetDialog;
import org.cyclops.integratedscripting.client.gui.component.input.WidgetTextArea;
import org.cyclops.integratedscripting.client.gui.image.ScriptImages;
import org.cyclops.integratedscripting.core.language.LanguageHandlers;
import org.cyclops.integratedscripting.inventory.container.ContainerTerminalScripting;
import org.cyclops.integratedscripting.network.packet.TerminalScriptingDeleteScriptPacket;
import org.cyclops.integratedscripting.network.packet.TerminalScriptingModifiedScriptPacket;

public class ContainerScreenTerminalScripting
extends ContainerScreenExtended<ContainerTerminalScripting> {
    public static int PATHS_X = 19;
    public static int PATHS_Y = 18;
    public static int PATHS_WIDTH = 56;
    public static int PATHS_HEIGHT = 214;
    public static int PATHS_ROW_HEIGHT = 8;
    public static int PATHS_MAX_ROWS = PATHS_HEIGHT / PATHS_ROW_HEIGHT;
    public static int SCRIPT_X = 80;
    public static int SCRIPT_X_INNER = 94;
    public static int SCRIPT_Y = 18;
    public static int SCRIPT_WIDTH = 168;
    public static int SCRIPT_HEIGHT = 115;
    private final Player player;
    private WidgetArrowedListField<Integer> fieldDisk;
    private WidgetScrollBar scrollBar;
    private int firstRow;
    private WidgetTextArea textArea;
    private ButtonText buttonCreateFile;
    private WidgetDialog pendingScriptRemovalDialog;
    private int lastClientSyncTick;
    private final DisplayErrorsComponent displayErrors = new DisplayErrorsComponent();
    private final Map<Path, Integer> lastScriptCursorPos = Maps.newHashMap();
    private final Map<Path, Integer> lastScriptSelectionPos = Maps.newHashMap();
    private final Int2ObjectMap<Path> lastDiskScript = new Int2ObjectAVLTreeMap();

    public ContainerScreenTerminalScripting(ContainerTerminalScripting container, Inventory inventory, Component title) {
        super((ContainerExtended)container, inventory, title);
        this.player = inventory.player;
        this.imageHeight = 240;
        this.titleLabelX = 88;
        this.titleLabelY = 6;
        this.inventoryLabelX = 88;
        this.inventoryLabelY = this.imageHeight - 94;
        this.firstRow = 0;
        this.lastClientSyncTick = 0;
    }

    public void init() {
        super.init();
        this.fieldDisk = new WidgetArrowedListField(Minecraft.getInstance().font, this.leftPos + 30, this.topPos + 4, 42, 15, true, (Component)Component.translatable((String)"gui.integratedscripting.disk"), true, (List)((ContainerTerminalScripting)this.getMenu()).getAvailableDisks());
        this.fieldDisk.setMaxLength(5);
        this.fieldDisk.setVisible(true);
        this.fieldDisk.setTextColor(0xFFFFFF);
        this.fieldDisk.setCanLoseFocus(true);
        this.fieldDisk.setEditable(true);
        this.fieldDisk.setValue(String.valueOf(((ContainerTerminalScripting)this.getMenu()).getActiveDisk()));
        this.scrollBar = new WidgetScrollBar(this.leftPos + 5, this.topPos + 18, 162, (Component)Component.translatable((String)"gui.cyclopscore.scrollbar"), this::setFirstRow, PATHS_MAX_ROWS){

            public int getTotalRows() {
                Map<Path, String> scripts = ContainerScreenTerminalScripting.this.getActiveScripts();
                return scripts == null ? 0 : scripts.keySet().size();
            }
        };
        this.textArea = new WidgetTextArea(Minecraft.getInstance().font, this.leftPos + SCRIPT_X + 1, this.topPos + SCRIPT_Y + 1, SCRIPT_WIDTH, SCRIPT_HEIGHT, (Component)Component.translatable((String)"gui.integratedscripting.script"), true, true);
        this.textArea.setListener(this::onActiveScriptModified);
        this.textArea.setListenerSelection(this::onSelectionModified);
        this.textArea.setListenerCursor(this::onSelectionModified);
        this.textArea.setMarkupProvider((style, line) -> {
            Path path = ((ContainerTerminalScripting)this.getMenu()).getActiveScriptPath();
            ILanguageHandler languageHandler = path != null ? LanguageHandlers.REGISTRY.getProvider(path) : null;
            return languageHandler != null ? languageHandler.markupLine(line) : Stream.of(Pair.of((Object)style, (Object)line)).collect(Collectors.toList());
        });
        this.addRenderableWidget(this.textArea);
        this.buttonCreateFile = new ButtonText(this.leftPos + 19, this.topPos + 222, 56, 10, (Component)Component.translatable((String)"gui.integratedscripting.create_file"), (Component)Component.literal((String)"+"), button -> ((ContainerTerminalScripting)this.getMenu()).createNewFile(), true);
        this.addRenderableWidget((GuiEventListener)this.buttonCreateFile);
    }

    protected void containerTick() {
        super.containerTick();
        this.textArea.tick();
        if (this.lastClientSyncTick == 0) {
            this.syncDirtyScripts();
        }
        this.lastClientSyncTick = (this.lastClientSyncTick + 1) % GeneralConfig.terminalScriptingClientSyncTickInterval;
    }

    protected void syncDirtyScripts() {
        for (Pair<Integer, Path> entry : ((ContainerTerminalScripting)this.getMenu()).getClientScriptsDirty()) {
            String script;
            Map diskScripts = (Map)((ContainerTerminalScripting)this.getMenu()).getLastScripts().get(entry.getLeft());
            if (diskScripts == null || (script = (String)diskScripts.get(entry.getRight())) == null) continue;
            IntegratedScripting._instance.getPacketHandler().sendToServer((PacketBase)new TerminalScriptingModifiedScriptPacket((Integer)entry.getLeft(), (Path)entry.getRight(), script));
        }
        ((ContainerTerminalScripting)this.getMenu()).getClientScriptsDirty().clear();
    }

    public void onClose() {
        this.syncDirtyScripts();
        super.onClose();
    }

    protected ResourceLocation constructGuiTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"integratedscripting", (String)"textures/gui/scripting_terminal.png");
    }

    public int getBaseXSize() {
        return 256;
    }

    public int getBaseYSize() {
        return 240;
    }

    protected int getErrorX() {
        return 212;
    }

    protected int getErrorY() {
        return 139;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, partialTicks, mouseX, mouseY);
        this.fieldDisk.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.scrollBar.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (!((ContainerTerminalScripting)this.getMenu()).getAvailableDisks().isEmpty()) {
            this.renderScriptPaths(guiGraphics, mouseX, mouseY, partialTicks);
        } else {
            guiGraphics.fill(this.leftPos + PATHS_X, this.topPos + PATHS_Y, this.leftPos + PATHS_X + PATHS_WIDTH, this.topPos + PATHS_Y + PATHS_HEIGHT, IModHelpers.get().getBaseHelpers().RGBAToInt(50, 50, 50, 100));
        }
        if (((ContainerTerminalScripting)this.getMenu()).getActiveScript() == null) {
            guiGraphics.fill(this.leftPos + SCRIPT_X_INNER, this.topPos + SCRIPT_Y, this.leftPos + SCRIPT_X_INNER + SCRIPT_WIDTH, this.topPos + SCRIPT_Y + SCRIPT_HEIGHT, IModHelpers.get().getBaseHelpers().RGBAToInt(50, 50, 50, 100));
        }
        this.displayErrors.drawBackground(guiGraphics, ((ContainerTerminalScripting)this.getMenu()).getReadErrors(), this.getErrorX(), this.getErrorY(), this.getErrorX(), this.getErrorY(), (ContainerScreenExtended)this, this.leftPos, this.topPos, ((ContainerTerminalScripting)this.getMenu()).canWriteScriptToVariable());
    }

    @Nullable
    protected Map<Path, String> getActiveScripts() {
        return (Map)((ContainerTerminalScripting)this.container).getLastScripts().get(((ContainerTerminalScripting)this.container).getActiveDisk());
    }

    protected List<Path> getVisibleScriptPaths() {
        List paths;
        Map<Path, String> scripts = this.getActiveScripts();
        if (scripts != null && !(paths = scripts.keySet().stream().sorted().collect(Collectors.toList())).isEmpty()) {
            return paths.subList(Math.max(0, this.firstRow), Math.max(0, this.firstRow) + Math.min(paths.size(), this.scrollBar.getVisibleRows()));
        }
        return Collections.emptyList();
    }

    protected void renderScriptPaths(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        List<Path> paths = this.getVisibleScriptPaths();
        int i2 = 0;
        for (Path path : paths) {
            boolean hovering = this.isHovering(PATHS_X, PATHS_Y + i2 * PATHS_ROW_HEIGHT, PATHS_WIDTH, PATHS_ROW_HEIGHT, mouseX, mouseY);
            boolean active = path.equals(((ContainerTerminalScripting)this.getMenu()).getActiveScriptPath());
            if (active) {
                guiGraphics.fill(this.leftPos + PATHS_X, this.topPos + PATHS_Y + i2 * PATHS_ROW_HEIGHT, this.leftPos + PATHS_X + PATHS_WIDTH, this.topPos + PATHS_Y + (i2 + 1) * PATHS_ROW_HEIGHT, IModHelpers.get().getBaseHelpers().RGBAToInt(110, 130, 240, 255));
            }
            ILanguageHandler languageHandler = LanguageHandlers.REGISTRY.getProvider(path);
            Image icon = ScriptImages.FILE_OTHER;
            if (languageHandler != null) {
                icon = languageHandler.getIcon();
            }
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate((float)(this.leftPos + PATHS_X + 1), (float)(this.topPos + PATHS_Y + i2 * PATHS_ROW_HEIGHT + 1));
            guiGraphics.pose().scale(0.5f, 0.5f);
            icon.draw(guiGraphics, 0, 0);
            guiGraphics.pose().popMatrix();
            IModHelpers.get().getRenderHelpers().drawScaledString(guiGraphics, this.font, StringUtil.truncateStringIfNecessary((String)path.toString(), (int)20, (boolean)true), this.leftPos + PATHS_X + 1 + 7, this.topPos + PATHS_Y + i2 * PATHS_ROW_HEIGHT + 1 + 1, 0.5f, hovering && !active ? IModHelpers.get().getBaseHelpers().RGBAToInt(50, 50, 250, 255) : IModHelpers.get().getBaseHelpers().RGBAToInt(0, 0, 0, 255), false, Font.DisplayMode.NORMAL);
            if (hovering) {
                guiGraphics.pose().pushMatrix();
                float scale = 0.4f;
                int size = (int)((float)Images.ERROR.getWidth() * scale);
                guiGraphics.pose().translate((float)(this.leftPos + PATHS_X + PATHS_WIDTH - size - 1), (float)(this.topPos + PATHS_Y + i2 * PATHS_ROW_HEIGHT + 1));
                guiGraphics.pose().scale(scale, scale);
                if (this.isHovering(PATHS_X + PATHS_WIDTH - size - 1, PATHS_Y + i2 * PATHS_ROW_HEIGHT, PATHS_X + PATHS_WIDTH - size + size - 1, PATHS_Y + i2 * PATHS_ROW_HEIGHT + size, mouseX, mouseY)) {
                    Images.ERROR.draw(guiGraphics, 0, 0);
                } else {
                    Images.ERROR.drawWithColor(guiGraphics, 0, 0, 0.7f, 0.7f, 0.7f, 1.0f);
                }
                guiGraphics.pose().popMatrix();
            }
            ++i2;
        }
    }

    @Nullable
    protected Path getHoveredScriptPath(double mouseX, double mouseY) {
        List<Path> paths = this.getVisibleScriptPaths();
        int i2 = 0;
        for (Path path : paths) {
            if (this.isHovering(PATHS_X, PATHS_Y + i2 * PATHS_ROW_HEIGHT, PATHS_WIDTH, PATHS_ROW_HEIGHT, mouseX, mouseY)) {
                return path;
            }
            ++i2;
        }
        return null;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, IModHelpers.get().getL10NHelpers().localize("gui.integratedscripting.disk", new Object[0]) + ":", 8, 6, ARGB.opaque((int)0xFFFFFF));
        this.displayErrors.drawForeground(guiGraphics, ((ContainerTerminalScripting)this.getMenu()).getReadErrors(), this.getErrorX(), this.getErrorY(), mouseX, mouseY, (ContainerScreenExtended)this, this.leftPos, this.topPos);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.pendingScriptRemovalDialog != null) {
            return this.pendingScriptRemovalDialog.mouseClicked(mouseX, mouseY, mouseButton);
        }
        Path hoveredScriptPath = this.getHoveredScriptPath(mouseX, mouseY);
        if (hoveredScriptPath != null) {
            if (mouseX >= (double)(this.leftPos + PATHS_X + PATHS_WIDTH - (int)((float)Images.ERROR.getWidth() * 0.4f) - 1)) {
                this.fieldDisk.playDownSound(Minecraft.getInstance().getSoundManager());
                this.pendingScriptRemovalDialog = new WidgetDialog(this.font, this.leftPos + this.getBaseXSize() / 2 - 108, this.topPos + 50, (Screen)this, (Component)Component.translatable((String)"gui.integratedscripting.removal_dialog.title"), (Component)Component.translatable((String)"gui.integratedscripting.removal_dialog.message", (Object[])new Object[]{hoveredScriptPath.toString()}), (Component)Component.translatable((String)"gui.integratedscripting.removal_dialog.delete"), (Component)Component.translatable((String)"gui.integratedscripting.removal_dialog.keep"), b2 -> {
                    this.removeWidget(this.pendingScriptRemovalDialog);
                    this.pendingScriptRemovalDialog = null;
                    this.removeScript(hoveredScriptPath);
                }, b2 -> {
                    this.removeWidget(this.pendingScriptRemovalDialog);
                    this.pendingScriptRemovalDialog = null;
                });
                this.addRenderableWidget(this.pendingScriptRemovalDialog);
                return true;
            }
            this.saveCursorPos();
            ((ContainerTerminalScripting)this.getMenu()).setActiveScriptPath(hoveredScriptPath);
            this.onActiveScriptSelected();
            this.restoreCursorPos();
            this.fieldDisk.playDownSound(Minecraft.getInstance().getSoundManager());
            return true;
        }
        int previousDisk = this.getActiveDisk();
        if (this.fieldDisk.mouseClicked(mouseX, mouseY, mouseButton)) {
            this.saveCursorPos();
            this.saveDiskScript(previousDisk);
            ((ContainerTerminalScripting)this.getMenu()).setActiveDisk(this.getActiveDisk());
            this.scrollBar.scrollTo(0.0f);
            this.restoreDiskScript();
            this.restoreCursorPos();
            this.playButtonClickSound();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public int getActiveDisk() {
        try {
            Integer element = (Integer)this.fieldDisk.getActiveElement();
            return element == null ? -1 : element;
        }
        catch (NumberFormatException e2) {
            return -1;
        }
    }

    private void saveCursorPos() {
        Path currentScriptPath = ((ContainerTerminalScripting)this.getMenu()).getActiveScriptPath();
        if (currentScriptPath != null) {
            this.lastScriptCursorPos.put(currentScriptPath, this.textArea.getCursorPos());
            this.lastScriptSelectionPos.put(currentScriptPath, this.textArea.getSelectionPos());
        }
    }

    private void restoreCursorPos() {
        Path currentScriptPath = ((ContainerTerminalScripting)this.getMenu()).getActiveScriptPath();
        Integer scriptCursorPos = this.lastScriptCursorPos.get(currentScriptPath);
        if (scriptCursorPos != null) {
            this.textArea.setCursorPos(scriptCursorPos);
        } else {
            this.textArea.setCursorPos(0);
            if (this.textArea.isFocused()) {
                this.textArea.setFocused(false);
            }
        }
        Integer scriptSelectionPos = this.lastScriptSelectionPos.get(currentScriptPath);
        if (scriptSelectionPos != null) {
            this.textArea.setSelectionPos(scriptSelectionPos);
        } else {
            this.textArea.setSelectionPos(0);
        }
    }

    private void saveDiskScript(int disk) {
        Path currentScriptPath = ((ContainerTerminalScripting)this.getMenu()).getActiveScriptPath();
        if (disk >= 0 && currentScriptPath != null) {
            this.lastDiskScript.put(disk, (Object)currentScriptPath);
        }
    }

    private void restoreDiskScript() {
        int disk = this.getActiveDisk();
        if (disk >= 0) {
            Path scriptPath = (Path)this.lastDiskScript.get(disk);
            ((ContainerTerminalScripting)this.getMenu()).setActiveScriptPath(scriptPath);
            this.onActiveScriptSelected();
        }
    }

    protected void playButtonClickSound() {
        this.getMinecraft().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public void setFirstRow(int firstRow) {
        this.firstRow = firstRow;
    }

    private void onActiveScriptSelected() {
        String script = ((ContainerTerminalScripting)this.getMenu()).getActiveScript();
        this.textArea.setValue(script == null ? "" : script);
    }

    private void onActiveScriptModified() {
        ((ContainerTerminalScripting)this.getMenu()).setActiveScript(this.textArea.getValue());
    }

    private void onSelectionModified() {
        int cursorPos;
        String selected = this.textArea.getSelected();
        if (Strings.isNullOrEmpty((String)selected) && (cursorPos = this.textArea.getCursorPos()) >= 0) {
            String value = this.textArea.getValue();
            Matcher matcherToEnd = ContainerTerminalScripting.INVALID_MEMBER_NAME.matcher(value);
            int endPos = value.length();
            if (matcherToEnd.find(cursorPos)) {
                endPos = matcherToEnd.end() - 1;
            }
            Matcher matcherToStart = ContainerTerminalScripting.INVALID_MEMBER_NAME.matcher(new StringBuilder(value).reverse().toString());
            int startPos = 0;
            if (matcherToStart.find(value.length() - cursorPos)) {
                startPos = value.length() - matcherToStart.end() + 1;
            }
            selected = value.substring(startPos, endPos);
        }
        ((ContainerTerminalScripting)this.getMenu()).setSelection(selected);
    }

    private void removeScript(Path path) {
        IntegratedScripting._instance.getPacketHandler().sendToServer((PacketBase)new TerminalScriptingDeleteScriptPacket(((ContainerTerminalScripting)this.getMenu()).getActiveDisk(), path));
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseZ, double scroll) {
        if (this.textArea.mouseScrolled(mouseX, mouseY, mouseZ, scroll)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, mouseZ, scroll);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseButton, double offsetX, double offsetY) {
        if (this.pendingScriptRemovalDialog != null) {
            return false;
        }
        if (this.textArea.mouseDragged(mouseX, mouseY, mouseButton, offsetX, offsetY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, mouseButton, offsetX, offsetY);
    }

    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (typedChar != 256 && this.pendingScriptRemovalDialog != null) {
            return false;
        }
        if (this.textArea.isFocused()) {
            boolean ret = this.textArea.keyPressed(typedChar, keyCode, modifiers);
            if (typedChar != 256) {
                return ret;
            }
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    public boolean charTyped(char p_94683_, int p_94684_) {
        if (this.pendingScriptRemovalDialog != null) {
            return false;
        }
        return super.charTyped(p_94683_, p_94684_);
    }
}

