/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedscripting.core.evaluate;

import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integratedscripting.api.item.IScriptVariableFacade;
import org.cyclops.integratedscripting.core.evaluate.ScriptVariable;
import org.cyclops.integratedscripting.core.item.ScriptVariableFacade;

public class ScriptVariableFacadeHandler
implements IVariableFacadeHandler<IScriptVariableFacade> {
    private static final IScriptVariableFacade INVALID_FACADE = new ScriptVariableFacade(false, -1, Path.of("", new String[0]), "");
    private static ScriptVariableFacadeHandler _instance;

    private ScriptVariableFacadeHandler() {
    }

    public static ScriptVariableFacadeHandler getInstance() {
        if (_instance == null) {
            _instance = new ScriptVariableFacadeHandler();
        }
        return _instance;
    }

    public ResourceLocation getUniqueName() {
        return ResourceLocation.fromNamespaceAndPath((String)"integratedscripting", (String)"script");
    }

    public IScriptVariableFacade getVariableFacade(ValueDeseralizationContext valueDeseralizationContext, int id, CompoundTag tag) {
        if (!tag.contains("disk") && !tag.contains("disk") || !tag.contains("path") || !tag.contains("member")) {
            return INVALID_FACADE;
        }
        return new ScriptVariableFacade(id, (int)((Integer)tag.getInt("disk").orElseThrow()), Path.of((String)tag.getString("path").orElseThrow(), new String[0]), (String)tag.getString("member").orElseThrow());
    }

    public void setVariableFacade(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag, IScriptVariableFacade variableFacade) {
        tag.putInt("disk", variableFacade.getDisk());
        tag.putString("path", variableFacade.getPath().toString());
        tag.putString("member", variableFacade.getMember());
    }

    public boolean isInstance(IVariableFacade variableFacade) {
        return variableFacade instanceof IScriptVariableFacade;
    }

    public boolean isInstance(IVariable<?> variable) {
        return variable instanceof ScriptVariable;
    }
}

